/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListDialog
extends JDialog {
    private String selection = null;
    private JList jList;
    private JScrollPane scrollPane;
    private JLabel titleLabel;

    public ListDialog(JFrame jFrame, String string, String[] stringArray) {
        super((Frame)jFrame, true);
        this.initComponents();
        this.jList.setListData(stringArray);
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.length() <= n) continue;
            n = string2.length();
        }
        n *= 8;
        int n2 = stringArray.length * 10;
        if (n2 > 600) {
            n2 = 600;
        }
        this.scrollPane.setPreferredSize(new Dimension(n, n2));
        if (string != null) {
            this.titleLabel.setText(string);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.scrollPane = new JScrollPane();
        this.jList = new JList();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ListDialog.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("List Selection");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ListDialog.this.jListMouseClicked(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.jList);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.selection = this.jList.getSelectedValue().toString();
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void jListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.jList.getSelectedValue() != null) {
            this.selection = this.jList.getSelectedValue().toString();
            this.doClose();
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public String showDialog() {
        this.setVisible(true);
        return this.selection;
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = ApiUtil.get_db_obj().get_server_name_list();
            ListDialog listDialog = new ListDialog(null, "Servers", stringArray2);
            String string = listDialog.showDialog();
            if (string != null) {
                System.out.println(string);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)devFailed);
        }
    }
}

