/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.DbServerArchitecture;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DevPropertyDialog
extends JDialog {
    private JDialog parent;
    private DbDevice dev;
    private DbServerArchitecture.TangoAtt att;
    private JTextField[] txt;
    private JButton[] btn;
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public DevPropertyDialog(JDialog jDialog, DbDevice dbDevice, DbServerArchitecture.TangoAtt tangoAtt) {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.dev = dbDevice;
        this.att = tangoAtt;
        this.initComponents();
        this.initOwnComponents();
        this.titleLabel.setText(dbDevice.name() + "/" + tangoAtt.name + "  Properties");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initOwnComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.txt = new JTextField[this.att.prop.length];
        this.btn = new JButton[this.att.prop.length];
        for (int i = 0; i < this.att.prop.length; ++i) {
            int n = 0;
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = i;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)new JLabel(this.att.prop[i].name + " :   "), gridBagConstraints);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = i;
            this.txt[i] = new JTextField();
            this.txt[i].setColumns(25);
            this.txt[i].setText(this.att.prop[i].strval);
            jPanel.add((Component)this.txt[i], gridBagConstraints);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = i;
            jPanel.add((Component)new JLabel("   "), gridBagConstraints);
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = i;
            this.btn[i] = new JButton("Histo");
            this.btn[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DevPropertyDialog.this.histoActionPerformed(actionEvent);
                }
            });
            jPanel.add((Component)this.btn[i], gridBagConstraints);
        }
        this.getContentPane().add((Component)jPanel, "Center");
        this.okBtn.setText("Apply");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DevPropertyDialog.this.closeDialog(windowEvent);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevPropertyDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevPropertyDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.txt.length; ++i) {
            String string = this.txt[i].getText();
            if (string.equals(this.att.prop[i].strval)) continue;
            try {
                String string2 = new DbAttribute(this.att.name);
                DbDatum dbDatum = new DbDatum(this.att.prop[i].name);
                dbDatum.insert(string);
                string2.add(dbDatum);
                this.dev.put_attribute_property((DbAttribute)string2);
                arrayList.add(this.att.prop[i].name + ":    " + this.att.prop[i].strval + " --> " + (String)string);
                this.att.prop[i].strval = string;
                continue;
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, (String)"att.prop[i]", (DevFailed)devFailed);
            }
        }
        String string = "";
        if (arrayList.size() > 0) {
            for (String string2 : arrayList) {
                string = string + string2;
            }
        } else {
            string = "Nothing changed !";
        }
        Utils.popupMessage(this, string);
        this.doClose();
    }

    private void histoActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        int n = -1;
        for (int i = 0; i < this.btn.length; ++i) {
            if (jButton != this.btn[i]) continue;
            n = i;
        }
        if (n < 0) {
            Utils.popupError(this, "Cannot retreive Device, attribute...");
            return;
        }
        try {
            String string = this.att.prop[n].name;
            Database database = ApiUtil.get_db_obj();
            DbHistory[] dbHistoryArray = database.get_device_attribute_property_history(this.dev.name(), this.att.name, string);
            Object[] objectArray = new String[dbHistoryArray.length];
            int n2 = dbHistoryArray.length;
            if (n2 == 0) {
                Utils.popupError(this, "No history found !");
                return;
            }
            for (int i = 0; i < dbHistoryArray.length; ++i) {
                objectArray[n2 - i - 1] = dbHistoryArray[i].getDate() + ":      " + dbHistoryArray[i].getValue();
            }
            String string2 = (String)JOptionPane.showInputDialog(this.parent, this.dev.name() + "/" + this.att.name + "-" + string + " :", "", 1, null, objectArray, objectArray[0]);
            if (string2 != null) {
                int n3 = string2.indexOf(":   ") + 1;
                this.txt[n].setText(string2.substring(n3).trim());
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Attribute Property History", (DevFailed)devFailed);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

