/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import admin.astor.tango_release.TangoClassRelease;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class TangoServerRelease
extends ArrayList<TangoClassRelease> {
    String name;
    String exeName;
    String instanceName;
    double releaseNumber = 0.0;
    String error = "";
    private static final String dserverClassName = "DServer";

    public TangoServerRelease(String string) {
        this.name = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        this.exeName = stringTokenizer.nextToken();
        this.instanceName = stringTokenizer.nextToken();
        try {
            DbServer dbServer = new DbServer(string);
            int n = new DeviceProxy("dserver/" + string).getTangoVersion();
            String[] stringArray = this.getClasses(dbServer);
            if (n >= 100) {
                this.releaseNumber = 0.01 * (double)n;
            }
            if (stringArray.length > 0) {
                for (String string2 : stringArray) {
                    this.add(new TangoClassRelease(dbServer, string2));
                }
            } else {
                this.error = "No class found on server " + this.name;
            }
        }
        catch (DevFailed devFailed) {
            this.error = devFailed.errors[0].desc;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.error = "TangORB is too old to check Tango release.";
        }
    }

    public String[] getClasses(DbServer dbServer) throws DevFailed {
        return dbServer.get_class_list();
    }

    public boolean hasIDL(int n) {
        for (TangoClassRelease tangoClassRelease : this) {
            if (tangoClassRelease.idl != n || tangoClassRelease.className.equals(dserverClassName)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<TangoClassRelease> getIdlClasses(int n) {
        ArrayList<TangoClassRelease> arrayList = new ArrayList<TangoClassRelease>();
        for (TangoClassRelease tangoClassRelease : this) {
            if (tangoClassRelease.idl != n || tangoClassRelease.className.equals(dserverClassName)) continue;
            arrayList.add(tangoClassRelease);
        }
        return arrayList;
    }

    public String toStringFull() {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        stringBuilder.append("\n");
        for (TangoClassRelease tangoClassRelease : this) {
            stringBuilder.append(tangoClassRelease).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name + " (");
        if (this.releaseNumber >= 1.0) {
            stringBuilder.append("Tango-").append(String.format("%1.1f", this.releaseNumber));
        } else {
            stringBuilder.append(this.error);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        String string = "VacGaugeServer/sr_c1-pen";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            TangoServerRelease tangoServerRelease = new TangoServerRelease(string);
            System.out.println(tangoServerRelease);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

