/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.ServerStat;
import admin.astor.statistics.ServerStatisticsPanel;
import admin.astor.statistics.StarterStat;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class StarterStatTable
extends JDialog {
    private DataTableModel model;
    private JTable jtable;
    private String[][] data;
    private JFrame parent;
    private JLabel titleLabel;
    private StarterStat starterStat;

    public StarterStatTable(JFrame jFrame, String string, StarterStat starterStat) {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.starterStat = starterStat;
        this.data = starterStat.toTable();
        this.initComponents();
        this.initMyComponents(string);
    }

    public StarterStatTable(JFrame jFrame, String string) throws DevFailed {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.starterStat = new StarterStat(string);
        this.data = this.starterStat.toTable();
        this.initComponents();
        this.initMyComponents(string);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StarterStatTable.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("Dismiss");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StarterStatTable.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void initMyComponents(String string) {
        this.model = new DataTableModel();
        this.jtable = new JTable(this.model);
        this.jtable.setRowSelectionAllowed(true);
        this.jtable.setColumnSelectionAllowed(true);
        this.jtable.setDragEnabled(true);
        this.jtable.setSelectionMode(0);
        this.jtable.getTableHeader().setFont(new Font("Dialog", 1, 14));
        this.jtable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                StarterStatTable.this.headerTableActionPerformed(mouseEvent);
            }
        });
        this.jtable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                StarterStatTable.this.tableActionPerformed(mouseEvent);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.jtable);
        int n = 18 + 18 * this.data.length;
        if (n > 400) {
            n = 400;
        }
        int[] nArray = new int[]{180, 180, 70, 130};
        Enumeration<TableColumn> enumeration = this.jtable.getColumnModel().getColumns();
        int n2 = 0;
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n3]);
            n2 += nArray[n3];
            ++n3;
        }
        jScrollPane.setPreferredSize(new Dimension(n2, n));
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.model.fireTableDataChanged();
        this.titleLabel.setText(string);
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.pack();
    }

    private void headerTableActionPerformed(MouseEvent mouseEvent) {
        int n = this.jtable.getTableHeader().columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        new UsedData().sort(n);
        this.model.fireTableDataChanged();
    }

    private void tableActionPerformed(MouseEvent mouseEvent) {
        int n = this.jtable.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        int n2 = this.jtable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && n == 0) {
            String string = this.data[n2][0];
            for (ServerStat serverStat : this.starterStat) {
                if (!serverStat.name.equals(string)) continue;
                if (this.parent != null) {
                    new ServerStatisticsPanel(this.parent, string, serverStat).setVisible(true);
                } else {
                    new ServerStatisticsPanel(this, string, serverStat).setVisible(true);
                }
                return;
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.parent == null) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Crate name ?");
            System.exit(0);
        }
        try {
            new StarterStatTable(null, stringArray[0]).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return StarterStatTable.this.data[0].length;
        }

        @Override
        public int getRowCount() {
            return StarterStatTable.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            if (n >= this.getColumnCount()) {
                return StarterStat.tableHeader[this.getColumnCount() - 1];
            }
            return StarterStat.tableHeader[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return StarterStatTable.this.data[n][n2];
        }
    }

    class UsedData
    extends ArrayList<String[]> {
        private int column;

        UsedData() {
            for (String[] stringArray : StarterStatTable.this.data) {
                this.add(stringArray);
            }
        }

        void sort(int n) {
            this.column = n;
            MyCompare myCompare = new MyCompare();
            Collections.sort(this, myCompare);
            for (int i = 0; i < this.size(); ++i) {
                ((StarterStatTable)StarterStatTable.this).data[i] = (String[])this.get(i);
            }
        }

        class MyCompare
        implements Comparator<String[]> {
            MyCompare() {
            }

            @Override
            public int compare(String[] stringArray, String[] stringArray2) {
                String string = stringArray[UsedData.this.column];
                String string2 = stringArray2[UsedData.this.column];
                try {
                    double d = Double.parseDouble(string);
                    double d2 = Double.parseDouble(string2);
                    return d < d2 ? 1 : 0;
                }
                catch (NumberFormatException numberFormatException) {
                    return string.compareToIgnoreCase(string2) > 0 ? 1 : 0;
                }
            }
        }
    }
}

