/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.ServerRecord;
import admin.astor.statistics.ServerStat;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ServerStatisticsTable
extends JTable {
    private ServerStat serverStatistics;
    private ServerStat filteredStatistics;
    private DataTableModel model;
    private static final int STATE = 0;
    private static final int START_TIME = 1;
    private static final int END_TIME = 2;
    private static final int DURATION = 3;
    private static final int AUTO_START = 4;
    private final Column[] columns = new Column[]{new Column("State", 50), new Column("Begin", 150), new Column("End", 150), new Column("Duration", 170), new Column("Started", 50)};

    public ServerStatisticsTable(ServerStat serverStat) {
        this.serverStatistics = serverStat;
        this.copyServerStat();
        this.buildTableComponent();
    }

    private void copyServerStat() {
        this.filteredStatistics = new ServerStat(this.serverStatistics.name);
        this.filteredStatistics.starterStat = this.serverStatistics.starterStat;
        this.filteredStatistics.nbFailures = this.serverStatistics.nbFailures;
        this.filteredStatistics.failedDuration = this.serverStatistics.failedDuration;
        this.filteredStatistics.runDuration = this.serverStatistics.runDuration;
        this.filteredStatistics.oldestTime = this.serverStatistics.oldestTime;
        for (ServerRecord serverRecord : this.serverStatistics) {
            this.filteredStatistics.add(serverRecord);
        }
    }

    private void buildTableComponent() {
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setDragEnabled(false);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ServerStatisticsTable.this.tableActionPerformed(mouseEvent);
            }
        });
        this.model = new DataTableModel();
        this.setModel(this.model);
        this.setDefaultRenderer(String.class, new StatCellRenderer());
        this.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ServerStatisticsTable.this.headerTableActionPerformed(mouseEvent);
            }
        });
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(this.columns[n++].width);
        }
        this.sort(1);
    }

    public int getDefaultHeight() {
        int n = 600;
        int n2 = 22 + 17 * this.filteredStatistics.size();
        if (n2 > n) {
            n2 = n;
        }
        return n2;
    }

    public int getDefaultWidth() {
        int n = 0;
        for (Column column : this.columns) {
            n += column.width;
        }
        return n;
    }

    private void tableActionPerformed(MouseEvent mouseEvent) {
    }

    private void headerTableActionPerformed(MouseEvent mouseEvent) {
        this.sort(this.getTableHeader().columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY())));
    }

    private void sort(int n) {
        MyCompare myCompare = new MyCompare();
        myCompare.setSelectedColumn(n);
        Collections.sort(this.filteredStatistics, myCompare);
        this.model.fireTableDataChanged();
    }

    private String getRecordValueString(ServerRecord serverRecord, int n) {
        switch (n) {
            case 0: {
                return serverRecord.stateName;
            }
            case 1: {
                return Utils.formatDate(serverRecord.startTime);
            }
            case 2: {
                return Utils.formatDate(serverRecord.endTime);
            }
            case 3: {
                return Utils.formatDuration(serverRecord.duration);
            }
            case 4: {
                if (serverRecord.state == DevState.ON) {
                    if (serverRecord.autoRestart == 2) {
                        return "Auto";
                    }
                    if (serverRecord.autoRestart == 1) {
                        return "On Req.";
                    }
                    return "";
                }
                return "";
            }
        }
        return "--";
    }

    public void setFilterOnRunning(boolean bl) {
        this.filteredStatistics.clear();
        for (ServerRecord serverRecord : this.serverStatistics) {
            if (!bl && serverRecord.state != DevState.FAULT) continue;
            this.filteredStatistics.add(serverRecord);
        }
        this.model.fireTableDataChanged();
    }

    class MyCompare
    implements Comparator<ServerRecord> {
        private int column;

        MyCompare() {
        }

        private void setSelectedColumn(int n) {
            this.column = n;
        }

        @Override
        public int compare(ServerRecord serverRecord, ServerRecord serverRecord2) {
            switch (this.column) {
                case 1: {
                    return serverRecord.startTime < serverRecord2.startTime ? 1 : 0;
                }
                case 2: {
                    return serverRecord.endTime < serverRecord2.endTime ? 1 : 0;
                }
                case 3: {
                    return serverRecord.duration < serverRecord2.duration ? 1 : 0;
                }
                case 4: {
                    return serverRecord.autoRestart < serverRecord2.autoRestart ? 1 : 0;
                }
            }
            return serverRecord.stateName.compareTo(serverRecord2.stateName) > 0 ? 1 : 0;
        }
    }

    public class StatCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public StatCellRenderer() {
            this.setFont(new Font("Dialog", 0, 12));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ServerRecord serverRecord = (ServerRecord)ServerStatisticsTable.this.filteredStatistics.get(n);
            if (serverRecord.state == DevState.FAULT) {
                this.setBackground(Color.orange);
            } else {
                this.setBackground(Color.green);
            }
            this.setText(ServerStatisticsTable.this.getRecordValueString(serverRecord, n2));
            if (n2 == 4) {
                if (serverRecord.autoRestart == 2) {
                    this.setToolTipText("Auto restarted by Starter");
                } else if (serverRecord.autoRestart == 1) {
                    this.setToolTipText("Started on Request");
                } else {
                    this.setToolTipText("");
                }
            } else {
                this.setToolTipText("");
            }
            return this;
        }
    }

    public class DataTableModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return ServerStatisticsTable.this.columns.length;
        }

        @Override
        public int getRowCount() {
            return ServerStatisticsTable.this.filteredStatistics.size();
        }

        @Override
        public String getColumnName(int n) {
            return ((ServerStatisticsTable)ServerStatisticsTable.this).columns[n].name;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ServerRecord serverRecord = (ServerRecord)ServerStatisticsTable.this.filteredStatistics.get(n);
            return ServerStatisticsTable.this.getRecordValueString(serverRecord, n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class Column {
        String name;
        int width;

        Column(String string, int n) {
            this.name = string;
            this.width = n;
        }
    }
}

