/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.DbPollPanel;
import admin.astor.HostInfoDialog;
import admin.astor.LevelTree;
import admin.astor.ManagePollingDialog;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.PollingProfiler;
import admin.astor.tools.PopupTable;
import admin.astor.tools.Server2TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ServerPopupMenu
extends JPopupMenu
implements AstorDefs {
    private TangoHost host;
    private TangoServer server;
    private LevelTree tree;
    private JFrame jFrame;
    private HostInfoDialog parent;
    private int mode;
    static final int SERVERS = 0;
    static final int LEVELS = 1;
    static final int NOTIFD = 2;
    private static String[] serverMenuLabels = new String[]{"Start server", "Restart server", "Set startup level", "Uptime", "Polling Manager", "Polling Profiler", "Pool Threads Manager", "Configure With Jive", "Configure With Wizard", "DB Attribute Properties", "Server Info", "Class  Info", "Device Dependencies", "Test   Device", "Check  States", "Black  Box", "Export Server to another TANGO_HOST", "Starter logs", "Standard Error"};
    private static String[] levelMenuLabels = new String[]{"Start servers", "Stop  servers", "Change level number", "Set startup level for each server", "Uptime", "Expand Tree"};
    private static String[] notifdMenuLabels = new String[]{"Start daemon"};
    private static final int OFFSET = 2;
    private static final int START_STOP = 0;
    private static final int RESTART = 1;
    private static final int STARTUP_LEVEL = 2;
    private static final int UPTIME = 3;
    private static final int POLLING_MANAGER = 4;
    private static final int POLLING_PROFILER = 5;
    private static final int POOL_THREAD_MAN = 6;
    private static final int CONFIGURE_JIVE = 7;
    private static final int CONFIGURE_WIZARD = 8;
    private static final int DB_ATTRIBUTES = 9;
    private static final int SERVER_INFO = 10;
    private static final int CLASS_INFO = 11;
    private static final int DEPENDENCIES = 12;
    private static final int TEST_DEVICE = 13;
    private static final int CHECK_STATES = 14;
    private static final int BLACK_BOX = 15;
    private static final int EXPORT_SERVER = 16;
    private static final int STARTER_LOGS = 17;
    private static final int STD_ERROR = 18;
    private static final int START = 0;
    private static final int STOP = 1;
    private static final int CHANGE_LEVEL = 2;
    private static final int SERVER_LEVELS = 3;
    private static final int UPTIME_LEVEL = 4;
    private static final int EXPAND = 5;
    private static final boolean TANGO_7 = true;
    private Point location;

    public ServerPopupMenu(JFrame jFrame, HostInfoDialog hostInfoDialog, TangoHost tangoHost, int n) {
        this.jFrame = jFrame;
        this.parent = hostInfoDialog;
        this.host = tangoHost;
        this.mode = n;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        String[] stringArray;
        JLabel jLabel = new JLabel("Server Control :");
        jLabel.setFont(new Font("Dialog", 1, 16));
        this.add(jLabel);
        this.add(new JPopupMenu.Separator());
        switch (this.mode) {
            case 0: {
                stringArray = serverMenuLabels;
                break;
            }
            case 1: {
                stringArray = levelMenuLabels;
                break;
            }
            default: {
                jLabel.setText("Event Notify Daemon");
                stringArray = notifdMenuLabels;
            }
        }
        for (String string : stringArray) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServerPopupMenu.this.cmdActionPerformed(actionEvent);
                }
            });
            this.add(jMenuItem);
        }
    }

    public void showMenu(MouseEvent mouseEvent, JTree jTree, TangoServer tangoServer) {
        boolean bl;
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        jTree.setSelectionPath(treePath);
        String string = tangoServer.getName();
        JLabel jLabel = (JLabel)this.getComponent(0);
        jLabel.setText("  " + string + "  :");
        this.server = tangoServer;
        JMenuItem jMenuItem = (JMenuItem)this.getComponent(2);
        boolean bl2 = bl = tangoServer.getState() == DevState.ON;
        if (bl || tangoServer.getState() == DevState.MOVING) {
            jMenuItem.setText("Kill  Server");
        } else {
            jMenuItem.setText("Start Server");
        }
        this.getComponent(3).setEnabled(bl);
        this.getComponent(7).setEnabled(bl);
        this.getComponent(15).setEnabled(bl);
        this.getComponent(16).setEnabled(bl);
        this.getComponent(17).setEnabled(bl);
        this.getComponent(18).setEnabled(true);
        this.getComponent(10).setEnabled(bl);
        this.getComponent(11).setVisible(!bl);
        this.getComponent(8).setVisible(true);
        this.getComponent(14).setVisible(true);
        this.getComponent(9).setEnabled(true);
        if (Astor.rwMode != 0) {
            this.getComponent(18).setVisible(false);
        }
        if (Astor.rwMode == 2) {
            this.getComponent(2).setVisible(false);
            this.getComponent(3).setVisible(false);
            this.getComponent(4).setVisible(false);
            this.getComponent(6).setVisible(false);
            this.getComponent(8).setVisible(false);
            this.getComponent(15).setVisible(false);
        }
        if (Astor.rwMode != 0) {
            this.getComponent(10).setVisible(false);
        }
        this.location = jTree.getLocationOnScreen();
        this.location.x += mouseEvent.getX();
        this.location.y += mouseEvent.getY();
        this.show(jTree, mouseEvent.getX(), mouseEvent.getY());
    }

    public void showMenu(MouseEvent mouseEvent, LevelTree levelTree, boolean bl) {
        this.tree = levelTree;
        JLabel jLabel = (JLabel)this.getComponent(0);
        jLabel.setText("  " + levelTree + "  :");
        JMenuItem jMenuItem = (JMenuItem)this.getComponent(7);
        jMenuItem.setText(bl ? "Collapse Tree" : levelMenuLabels[5]);
        this.getComponent(5).setVisible(false);
        if (Astor.rwMode == 2) {
            this.getComponent(2).setVisible(false);
            this.getComponent(3).setVisible(false);
            this.getComponent(4).setVisible(false);
        }
        this.location = levelTree.getLocationOnScreen();
        this.location.x += mouseEvent.getX();
        this.location.y += mouseEvent.getY();
        this.show(levelTree, mouseEvent.getX(), mouseEvent.getY());
    }

    public void showMenu(MouseEvent mouseEvent) {
        if (Astor.rwMode == 2) {
            return;
        }
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        boolean bl = this.host.notifydState == 3;
        this.getComponent(2).setEnabled(!bl);
        this.location = jLabel.getLocationOnScreen();
        this.show(jLabel, mouseEvent.getX(), mouseEvent.getY());
    }

    private void cmdActionPerformed(ActionEvent actionEvent) {
        switch (this.mode) {
            case 0: {
                this.serverCmdActionPerformed(actionEvent);
                break;
            }
            case 1: {
                this.levelCmdActionPerformed(actionEvent);
                break;
            }
            case 2: {
                this.notifdCmdActionPerformed(actionEvent);
            }
        }
    }

    private void notifdCmdActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = -1;
        for (int i = 0; i < notifdMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != object) continue;
            n = i;
        }
        switch (n) {
            case 0: {
                this.host.startServer(this.parent, "notify_daemon/" + this.host.getName());
            }
        }
    }

    private void levelCmdActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = -1;
        for (int i = 0; i < levelMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != object) continue;
            n = i;
        }
        switch (n) {
            case 0: {
                this.parent.startLevel(this.tree.getLevelRow());
                break;
            }
            case 1: {
                this.parent.stopLevel(this.tree.getLevelRow());
                break;
            }
            case 2: {
                this.tree.changeChangeLevel(this.tree.getLevelRow());
                break;
            }
            case 3: {
                this.tree.changeServerLevels();
                break;
            }
            case 4: {
                this.tree.displayUptime();
                break;
            }
            case 5: {
                this.tree.toggleExpandCollapse();
            }
        }
    }

    private void serverCmdActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = -1;
        for (int i = 0; i < serverMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != object) continue;
            n = i;
        }
        switch (n) {
            case 2: {
                if (!this.server.startupLevel(this.parent, this.host.getName(), this.location)) break;
                this.parent.updateData();
                break;
            }
            case 3: {
                try {
                    String[] stringArray = this.server.getServerUptime();
                    String[] stringArray2 = new String[]{"Last   exported", "Last unexported"};
                    PopupTable popupTable = new PopupTable(this.parent, this.server.getName(), stringArray2, (String[][])new String[][]{stringArray}, new Dimension(450, 50));
                    popupTable.setVisible(true);
                }
                catch (DevFailed devFailed) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                }
                break;
            }
            case 4: {
                if (this.server.getState() == DevState.ON) {
                    new ManagePollingDialog(this.parent, this.server).setVisible(true);
                    break;
                }
                try {
                    new DbPollPanel(this.parent, this.server.getName()).setVisible(true);
                }
                catch (DevFailed devFailed) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                }
                break;
            }
            case 6: {
                this.server.poolThreadManager(this.parent, this.host);
                break;
            }
            case 5: {
                this.startPollingProfiler();
                break;
            }
            case 13: {
                this.server.testDevice(this.parent);
                break;
            }
            case 14: {
                this.server.checkStates(this.parent);
                break;
            }
            case 15: {
                this.server.displayBlackBox(this.parent);
                break;
            }
            case 17: {
                this.host.displayLogging(this.parent, this.server.toString());
                break;
            }
            case 7: {
                this.server.showJive(this.jFrame);
                break;
            }
            case 8: {
                this.server.configureWithWizard(this.parent);
                break;
            }
            case 10: {
                this.server.displayServerInfo(this.parent);
                break;
            }
            case 9: {
                this.server.manageMemorizedAttributes(this.parent);
                break;
            }
            case 11: {
                this.server.displayClassInfo(this.jFrame);
                break;
            }
            case 12: {
                try {
                    new DeviceHierarchyDialog(this.parent, this.server.getName()).setVisible(true);
                }
                catch (DevFailed devFailed) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                }
                break;
            }
            case 18: {
                if (this.server != null) {
                    this.host.readStdErrorFile(this.jFrame, this.server.getName());
                    break;
                }
                this.host.readStdErrorFile(this.jFrame, "notify_daemon/" + this.host.getName());
                break;
            }
            case 16: {
                try {
                    new Server2TangoHost(this.parent, this.server.get_server_name()).setVisible(true);
                    this.parent.updateData();
                }
                catch (DevFailed devFailed) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                }
                break;
            }
            case 1: {
                this.server.restart(this.parent, this.host, true);
                break;
            }
            case 0: {
                if (this.server.getState() == DevState.ON || this.server.getState() == DevState.MOVING) {
                    try {
                        if (JOptionPane.showConfirmDialog(this.parent, "Are you sure to want to kill " + this.server.getName(), "Confirm Dialog", 0) != 0) {
                            return;
                        }
                        this.host.stopServer(this.server.getName());
                    }
                    catch (DevFailed devFailed) {
                        if (devFailed.errors[0].reason.equals("SERVER_NOT_RESPONDING")) {
                            try {
                                if (JOptionPane.showConfirmDialog(this.parent, devFailed.errors[0].desc + "\n" + "Do you even want to kill it ?", "Confirm Dialog", 0) != 0) {
                                    return;
                                }
                                this.host.hardKillServer(this.server.getName());
                            }
                            catch (DevFailed devFailed2) {
                                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed2);
                            }
                            break;
                        }
                        ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                    }
                    break;
                }
                this.host.startServer(this.parent, this.server.getName());
            }
        }
    }

    private void startPollingProfiler() {
        try {
            String[] stringArray = this.server.queryDevice();
            new PollingProfiler((JDialog)this.parent, stringArray).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }
}

