/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.Main;
import fr.esrf.logviewer.MyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Level;

class ControlPanel
extends JPanel {
    private boolean closeOnExit;
    private Main parent;

    ControlPanel(final MyTableModel myTableModel, Main main, boolean bl) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Controls"));
        this.parent = main;
        this.closeOnExit = bl;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Level Filter");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        int n = 1;
        jLabel = new JLabel("Time Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Thread Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Source Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Message Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        Level[] levelArray = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG};
        final JComboBox<Level> jComboBox = new JComboBox<Level>(levelArray);
        Level level = levelArray[levelArray.length - 1];
        jComboBox.setSelectedItem(level);
        myTableModel.setLevelFilter(level);
        jComboBox.setEditable(false);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                myTableModel.setLevelFilter((Level)jComboBox.getSelectedItem());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        jPanel.add(jComboBox, gridBagConstraints);
        n = 1;
        final JTextField jTextField = new JTextField("");
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                myTableModel.setTimeStampFilter(jTextField.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                myTableModel.setTimeStampFilter(jTextField.getText());
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                myTableModel.setTimeStampFilter(jTextField.getText());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        final JTextField jTextField2 = new JTextField("");
        jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                myTableModel.setThreadFilter(jTextField2.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                myTableModel.setThreadFilter(jTextField2.getText());
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                myTableModel.setThreadFilter(jTextField2.getText());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField2, gridBagConstraints);
        final JTextField jTextField3 = new JTextField("");
        jTextField3.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                myTableModel.setCategoryFilter(jTextField3.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                myTableModel.setCategoryFilter(jTextField3.getText());
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                myTableModel.setCategoryFilter(jTextField3.getText());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField3, gridBagConstraints);
        final JTextField jTextField4 = new JTextField("");
        jTextField4.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                myTableModel.setMessageFilter(jTextField4.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                myTableModel.setMessageFilter(jTextField4.getText());
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                myTableModel.setMessageFilter(jTextField4.getText());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField4, gridBagConstraints);
        n = 1;
        JButton jButton = new JButton("Exit");
        jButton.setMnemonic('x');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.exitBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton(" ");
        jButton2.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jButton2, gridBagConstraints);
        JButton jButton3 = new JButton("Clear");
        jButton3.setMnemonic('c');
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                myTableModel.clear();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jButton3, gridBagConstraints);
        final JButton jButton4 = new JButton("Pause");
        jButton4.setMnemonic('p');
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                myTableModel.toggle();
                jButton4.setText(myTableModel.isPaused() ? "Resume" : "Pause");
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jButton4, gridBagConstraints);
        this.add((Component)jPanel, "Center");
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.parent.exitForm();
    }
}

