/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zeromq.ZMQ;

public class ZLoop {
    private final List<SPoller> pollers = new ArrayList<SPoller>();
    private final List<STimer> timers = new ArrayList<STimer>();
    private int pollSize;
    private ZMQ.Poller pollset;
    private SPoller[] pollact;
    private boolean dirty;
    private boolean verbose;
    private final List<Object> zombies = new ArrayList<Object>();
    private final List<STimer> newTimers = new ArrayList<STimer>();

    public void destroy() {
    }

    private void rebuild() {
        this.pollact = null;
        this.pollSize = this.pollers.size();
        this.pollset = new ZMQ.Poller(this.pollSize);
        this.pollact = new SPoller[this.pollSize];
        int n = 0;
        for (SPoller sPoller : this.pollers) {
            this.pollset.register(sPoller.item);
            this.pollact[n] = sPoller;
            ++n;
        }
        this.dirty = false;
    }

    private long ticklessTimer() {
        long l = System.currentTimeMillis() + 3600000L;
        for (STimer sTimer : this.timers) {
            if (sTimer.when == -1L) {
                sTimer.when = (long)sTimer.delay + System.currentTimeMillis();
            }
            if (l <= sTimer.when) continue;
            l = sTimer.when;
        }
        long l2 = l - System.currentTimeMillis();
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (this.verbose) {
            System.out.printf("I: zloop: polling for %d msec\n", l2);
        }
        return l2;
    }

    public int addPoller(ZMQ.PollItem pollItem, IZLoopHandler iZLoopHandler, Object object) {
        ZMQ.PollItem pollItem2 = pollItem;
        if (pollItem2.getRawSocket() == null && pollItem2.getSocket() == null) {
            return -1;
        }
        SPoller sPoller = new SPoller(pollItem, iZLoopHandler, object);
        this.pollers.add(sPoller);
        this.dirty = true;
        if (this.verbose) {
            System.out.printf("I: zloop: register %s poller (%s, %s)\n", pollItem2.getSocket() != null ? Integer.valueOf(pollItem2.getSocket().getType()) : "RAW", pollItem2.getSocket(), pollItem2.getRawSocket());
        }
        return 0;
    }

    public void removePoller(ZMQ.PollItem pollItem) {
        ZMQ.PollItem pollItem2 = pollItem;
        Iterator<SPoller> iterator = this.pollers.iterator();
        while (iterator.hasNext()) {
            SPoller sPoller = iterator.next();
            if (!pollItem2.equals(sPoller.item)) continue;
            iterator.remove();
            this.dirty = true;
        }
        if (this.verbose) {
            System.out.printf("I: zloop: cancel %s poller (%s, %s)", pollItem2.getSocket() != null ? Integer.valueOf(pollItem2.getSocket().getType()) : "RAW", pollItem2.getSocket(), pollItem2.getRawSocket());
        }
    }

    public int addTimer(int n, int n2, IZLoopHandler iZLoopHandler, Object object) {
        STimer sTimer = new STimer(n, n2, iZLoopHandler, object);
        this.newTimers.add(sTimer);
        if (this.verbose) {
            System.out.printf("I: zloop: register timer delay=%d times=%d\n", n, n2);
        }
        return 0;
    }

    public int removeTimer(Object object) {
        assert (object != null);
        this.zombies.add(object);
        if (this.verbose) {
            System.out.printf("I: zloop: cancel timer\n", new Object[0]);
        }
        return 0;
    }

    public void verbose(boolean bl) {
        this.verbose = bl;
    }

    public int start() {
        int n = 0;
        this.timers.addAll(this.newTimers);
        this.newTimers.clear();
        for (STimer sTimer : this.timers) {
            sTimer.when = (long)sTimer.delay + System.currentTimeMillis();
        }
        while (!Thread.currentThread().isInterrupted()) {
            long l;
            if (this.dirty) {
                this.rebuild();
            }
            if ((n = this.pollset.poll(l = this.ticklessTimer())) == -1) {
                if (this.verbose) {
                    System.out.printf("I: zloop: interrupted (%d)\n", n);
                }
                n = 0;
                break;
            }
            Iterator<STimer> iterator = this.timers.iterator();
            while (iterator.hasNext()) {
                STimer sTimer = iterator.next();
                if (System.currentTimeMillis() < sTimer.when || sTimer.when == -1L) continue;
                if (this.verbose) {
                    System.out.println("I: zloop: call timer handler");
                }
                if ((n = sTimer.handler.handle(this, null, sTimer.arg)) == -1) break;
                if (sTimer.times != 0 && --sTimer.times == 0) {
                    iterator.remove();
                    continue;
                }
                sTimer.when = (long)sTimer.delay + System.currentTimeMillis();
            }
            if (n == -1) break;
            for (int i = 0; i < this.pollSize; ++i) {
                SPoller sPoller = this.pollact[i];
                if (this.pollset.getItem(i).isError()) {
                    if (this.verbose) {
                        System.out.printf("I: zloop: can't poll %s socket (%s, %s)", sPoller.item.getSocket() != null ? Integer.valueOf(sPoller.item.getSocket().getType()) : "RAW", sPoller.item.getSocket(), sPoller.item.getRawSocket());
                    }
                    if (sPoller.errors++ > 0) {
                        this.removePoller(sPoller.item);
                    }
                } else {
                    sPoller.errors = 0;
                }
                if (this.pollset.getItem(i).readyOps() <= 0) continue;
                if (this.verbose) {
                    System.out.printf("I: zloop: call %s socket handler (%s, %s)\n", sPoller.item.getSocket() != null ? Integer.valueOf(sPoller.item.getSocket().getType()) : "RAW", sPoller.item.getSocket(), sPoller.item.getRawSocket());
                }
                if ((n = sPoller.handler.handle(this, sPoller.item, sPoller.arg)) == -1) break;
            }
            for (Object e : this.zombies) {
                iterator = this.timers.iterator();
                while (iterator.hasNext()) {
                    STimer sTimer = iterator.next();
                    if (sTimer.arg != e) continue;
                    iterator.remove();
                }
            }
            this.timers.addAll(this.newTimers);
            this.newTimers.clear();
            if (n != -1) continue;
            break;
        }
        return n;
    }

    private class STimer {
        int delay;
        int times;
        IZLoopHandler handler;
        Object arg;
        long when;

        public STimer(int n, int n2, IZLoopHandler iZLoopHandler, Object object) {
            this.delay = n;
            this.times = n2;
            this.handler = iZLoopHandler;
            this.arg = object;
            this.when = -1L;
        }
    }

    private class SPoller {
        ZMQ.PollItem item;
        IZLoopHandler handler;
        Object arg;
        int errors;

        protected SPoller(ZMQ.PollItem pollItem, IZLoopHandler iZLoopHandler, Object object) {
            this.item = pollItem;
            this.handler = iZLoopHandler;
            this.arg = object;
            this.errors = 0;
        }
    }

    public static interface IZLoopHandler {
        public int handle(ZLoop var1, ZMQ.PollItem var2, Object var3);
    }
}

