/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.zeromq.ZMQ;

public class ZFrame {
    public static final int MORE = 2;
    public static final int REUSE = 128;
    public static final int DONTWAIT = 1;
    private boolean more;
    private byte[] data;

    protected ZFrame() {
    }

    public ZFrame(byte[] byArray) {
        if (byArray != null) {
            this.data = (byte[])byArray.clone();
        }
    }

    public ZFrame(String string) {
        if (string != null) {
            this.data = string.getBytes();
        }
    }

    public void destroy() {
        if (this.hasData()) {
            this.data = null;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean hasMore() {
        return this.more;
    }

    public int size() {
        if (this.hasData()) {
            return this.data.length;
        }
        return 0;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean send(ZMQ.Socket socket, int n) {
        if (socket == null) {
            throw new IllegalArgumentException("socket parameter must be set");
        }
        if (!this.hasData()) {
            throw new IllegalAccessError("Cannot send frame without data");
        }
        return socket.send(this.data, n);
    }

    public boolean sendAndKeep(ZMQ.Socket socket, int n) {
        return this.send(socket, n);
    }

    public boolean sendAndKeep(ZMQ.Socket socket) {
        return this.sendAndKeep(socket, 0);
    }

    public boolean sendAndDestroy(ZMQ.Socket socket, int n) {
        boolean bl = this.send(socket, n);
        if (bl) {
            this.destroy();
        }
        return bl;
    }

    public boolean sendAndDestroy(ZMQ.Socket socket) {
        return this.sendAndDestroy(socket, 0);
    }

    public ZFrame duplicate() {
        return new ZFrame((byte[])this.data.clone());
    }

    public boolean hasSameData(ZFrame zFrame) {
        if (zFrame == null) {
            return false;
        }
        if (this.size() == zFrame.size() && this.hasData() && zFrame.hasData()) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.data[i] == zFrame.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void reset(byte[] byArray) {
        this.data = byArray;
    }

    public void reset(String string) {
        this.reset(string.getBytes());
    }

    public String strhex() {
        String string = "0123456789ABCDEF";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            int n = this.data[i] >>> 4 & 0xF;
            int n2 = this.data[i] & 0xF;
            stringBuilder.append(string.charAt(n));
            stringBuilder.append(string.charAt(n2));
        }
        return stringBuilder.toString();
    }

    public boolean streq(String string) {
        if (!this.hasData()) {
            return false;
        }
        return new String(this.data).compareTo(string) == 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ZFrame zFrame = (ZFrame)object;
        return Arrays.equals(this.data, zFrame.data);
    }

    public int hashCode() {
        return this.data != null ? Arrays.hashCode(this.data) : 0;
    }

    public String toString() {
        if (!this.hasData()) {
            return null;
        }
        boolean bl = true;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] >= 32 && this.data[i] <= 127) continue;
            bl = false;
        }
        if (bl) {
            return new String(this.data);
        }
        return this.strhex();
    }

    private byte[] recv(ZMQ.Socket socket, int n) {
        if (socket == null) {
            throw new IllegalArgumentException("socket parameter must not be null");
        }
        this.data = socket.recv(n);
        this.more = socket.hasReceiveMore();
        return this.data;
    }

    public static ZFrame recvFrame(ZMQ.Socket socket) {
        ZFrame zFrame = new ZFrame();
        zFrame.recv(socket, 0);
        return zFrame;
    }

    public static ZFrame recvFrame(ZMQ.Socket socket, int n) {
        ZFrame zFrame = new ZFrame();
        zFrame.recv(socket, n);
        return zFrame;
    }

    public void print(String string) {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.printf("%s", string);
        }
        byte[] byArray = this.getData();
        int n2 = this.size();
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            if (byArray[n] >= 9 && byArray[n] <= 127) continue;
            bl = true;
        }
        printWriter.printf("[%03d] ", n2);
        int n3 = bl ? 35 : 70;
        String string2 = "";
        if (n2 > n3) {
            n2 = n3;
            string2 = "...";
        }
        for (n = 0; n < n2; ++n) {
            if (bl) {
                printWriter.printf("%02X", byArray[n]);
                continue;
            }
            printWriter.printf("%c", byArray[n]);
        }
        printWriter.printf("%s\n", string2);
        printWriter.flush();
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.print(stringWriter.toString());
    }
}

