/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZContext
implements Closeable {
    private ZMQ.Context context = null;
    private List<ZMQ.Socket> sockets = new CopyOnWriteArrayList<ZMQ.Socket>();
    private int ioThreads = 1;
    private int linger = 0;
    private boolean main = true;

    public void destroy() {
        ListIterator<ZMQ.Socket> listIterator = this.sockets.listIterator();
        while (listIterator.hasNext()) {
            this.destroySocket(listIterator.next());
        }
        this.sockets.clear();
        if (this.isMain() && this.context != null) {
            this.context.term();
        }
    }

    public ZMQ.Socket createSocket(int n) {
        if (this.context == null) {
            this.context = ZMQ.context(this.ioThreads);
        }
        ZMQ.Socket socket = this.context.socket(n);
        this.sockets.add(socket);
        return socket;
    }

    public void destroySocket(ZMQ.Socket socket) {
        if (socket == null) {
            return;
        }
        if (this.sockets.contains(socket)) {
            block4: {
                try {
                    socket.setLinger(this.linger);
                }
                catch (ZMQException zMQException) {
                    if ((long)zMQException.getErrorCode() == ZMQ.ETERM()) break block4;
                    throw zMQException;
                }
            }
            socket.close();
            this.sockets.remove(socket);
        }
    }

    public static ZContext shadow(ZContext zContext) {
        ZContext zContext2 = new ZContext();
        zContext2.setContext(zContext.getContext());
        zContext2.setMain(false);
        return zContext2;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int n) {
        this.ioThreads = n;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int n) {
        this.linger = n;
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean bl) {
        this.main = bl;
    }

    public ZMQ.Context getContext() {
        return this.context;
    }

    public void setContext(ZMQ.Context context) {
        this.context = context;
    }

    public List<ZMQ.Socket> getSockets() {
        return this.sockets;
    }

    @Override
    public void close() throws IOException {
        this.destroy();
    }
}

