/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.security.sas.GSSUPNameSpi;
import org.jacorb.security.sas.ISASContext;
import org.omg.CORBA.ORB;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.GSSUP.InitialContextToken;
import org.omg.IOP.Codec;
import org.slf4j.Logger;

public class GssUpContext
implements ISASContext {
    private Logger logger = null;
    private static String username = "";
    private static String password = "";
    protected InitialContextToken initialContextToken = null;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getLogger("jacorb.security.sas.GSSUP.log.verbosity");
    }

    public static void setUsernamePassword(String username, String password) {
        GssUpContext.username = username;
        GssUpContext.password = password;
    }

    @Override
    public String getMechOID() {
        return "oid:2.23.130.1.1.1".substring(4);
    }

    @Override
    public byte[] createClientContext(ORB orb, Codec codec, CompoundSecMechList csmList) {
        byte[] contextToken = csmList == null || csmList.mechanism_list == null || csmList.mechanism_list.length == 0 ? GSSUPNameSpi.encode(orb, codec, username, password, new byte[0]) : GSSUPNameSpi.encode(orb, codec, username, password, csmList.mechanism_list[0].as_context_mech.target_name);
        this.initialContextToken = GSSUPNameSpi.decode(orb, codec, contextToken);
        return contextToken;
    }

    @Override
    public String getClientPrincipal() {
        return username;
    }

    @Override
    public boolean validateContext(ORB orb, Codec codec, byte[] contextToken) {
        this.initialContextToken = GSSUPNameSpi.decode(orb, codec, contextToken);
        return this.initialContextToken != null;
    }

    @Override
    public String getValidatedPrincipal() {
        if (this.initialContextToken == null) {
            return null;
        }
        return new String(this.initialContextToken.username);
    }

    @Override
    public void initClient() {
    }

    @Override
    public void initTarget() {
    }
}

