/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.typecode;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.typecode.AbstractInterfaceTypeCodeReader;
import org.jacorb.orb.typecode.AliasTypeCodeReader;
import org.jacorb.orb.typecode.EnumTypeCodeReader;
import org.jacorb.orb.typecode.ExceptTypeCodeReader;
import org.jacorb.orb.typecode.IndirectionTypeCodeReader;
import org.jacorb.orb.typecode.ObjectReferenceTypeCodeReader;
import org.jacorb.orb.typecode.PrimitiveTypeCodeReader;
import org.jacorb.orb.typecode.SequenceTypeCodeReader;
import org.jacorb.orb.typecode.SimpleTypeCodeReader;
import org.jacorb.orb.typecode.StructTypeCodeReader;
import org.jacorb.orb.typecode.TypeCodeReader;
import org.jacorb.orb.typecode.UnionTypeCodeReader;
import org.jacorb.orb.typecode.ValueBoxTypeCodeReader;
import org.jacorb.orb.typecode.ValueTypeCodeReader;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TypeCode;
import org.slf4j.Logger;

public class DelegatingTypeCodeReader {
    private final Map readerMap = new HashMap();

    public DelegatingTypeCodeReader() {
        this.readerMap.put(-1, new IndirectionTypeCodeReader());
        PrimitiveTypeCodeReader primitiveReader = new PrimitiveTypeCodeReader();
        for (int x = 0; x < 14; ++x) {
            this.readerMap.put(x, primitiveReader);
        }
        this.readerMap.put(23, primitiveReader);
        this.readerMap.put(24, primitiveReader);
        this.readerMap.put(26, primitiveReader);
        this.readerMap.put(14, new ObjectReferenceTypeCodeReader());
        this.readerMap.put(15, new StructTypeCodeReader());
        this.readerMap.put(16, new UnionTypeCodeReader());
        this.readerMap.put(17, new EnumTypeCodeReader());
        this.readerMap.put(21, new AliasTypeCodeReader());
        this.readerMap.put(22, new ExceptTypeCodeReader());
        this.readerMap.put(29, new ValueTypeCodeReader());
        this.readerMap.put(30, new ValueBoxTypeCodeReader());
        this.readerMap.put(32, new AbstractInterfaceTypeCodeReader());
        SimpleTypeCodeReader simpleReader = new SimpleTypeCodeReader();
        this.readerMap.put(18, simpleReader);
        this.readerMap.put(27, simpleReader);
        this.readerMap.put(28, simpleReader);
        SequenceTypeCodeReader sequenceReader = new SequenceTypeCodeReader();
        this.readerMap.put(19, sequenceReader);
        this.readerMap.put(20, sequenceReader);
    }

    public TypeCode readTypeCode(Logger logger, CDRInputStream in, Map recursiveTCMap, Map repeatedTCMap) {
        in.mark(0);
        int kind = in.read_long();
        int start_pos = in.get_pos() - 4;
        try {
            in.reset();
        }
        catch (IOException e) {
            assert (false);
            throw new RuntimeException("should not happen");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(in.getIndentString() + "read TypeCode kind " + kind + " at startposition " + start_pos);
        }
        TypeCode result = this.doReadTypeCode(in, recursiveTCMap, repeatedTCMap, kind);
        if (logger.isDebugEnabled()) {
            logger.debug(in.getIndentString() + "return " + result + " (" + result.getClass().getName() + "@" + System.identityHashCode(result) + ")");
        }
        return result;
    }

    private TypeCode doReadTypeCode(CDRInputStream in, Map recursiveTCMap, Map repeatedTCMap, int kind) {
        TypeCodeReader delegate = (TypeCodeReader)this.readerMap.get(kind);
        if (delegate == null) {
            throw new MARSHAL("cannot handle TypeCode with kind=" + kind);
        }
        return delegate.readTypeCode(in, recursiveTCMap, repeatedTCMap);
    }
}

