/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.events;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.events.JacORBEventChannelPOA;
import org.jacorb.events.ProxyPullConsumerImpl;
import org.jacorb.events.ProxyPullSupplierImpl;
import org.jacorb.events.ProxyPushConsumerImpl;
import org.jacorb.events.ProxyPushSupplierImpl;
import org.omg.CORBA.Any;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CosEventChannelAdmin.ConsumerAdmin;
import org.omg.CosEventChannelAdmin.ConsumerAdminHelper;
import org.omg.CosEventChannelAdmin.ProxyPullConsumer;
import org.omg.CosEventChannelAdmin.ProxyPullSupplier;
import org.omg.CosEventChannelAdmin.ProxyPushConsumer;
import org.omg.CosEventChannelAdmin.ProxyPushSupplier;
import org.omg.CosEventChannelAdmin.SupplierAdmin;
import org.omg.CosEventChannelAdmin.SupplierAdminHelper;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class EventChannelImpl
extends JacORBEventChannelPOA {
    private Vector pullSuppliers = new Vector();
    private Vector pullConsumers = new Vector();
    private Vector pushSuppliers = new Vector();
    private Vector pushConsumers = new Vector();
    private Vector pendingEvents = new Vector();
    private Any nullAny = null;
    private ORB myOrb = null;
    private POA myPoa = null;

    public EventChannelImpl(ORB orb, POA poa) {
        this.myOrb = orb;
        this.myPoa = poa;
        this._this_object(this.myOrb);
        this.nullAny = this.myOrb.create_any();
        this.nullAny.type(this.myOrb.get_primitive_tc(TCKind.tk_null));
        try {
            this.myPoa = poa;
            this.myPoa.the_POAManager().activate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void consumerAdminDestroy() {
        this.releaseList(this.pullSuppliers);
        this.releaseList(this.pushSuppliers);
    }

    private void supplierAdminDestroy() {
        this.releaseList(this.pullConsumers);
        this.releaseList(this.pushConsumers);
    }

    private void releaseList(Vector list) {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            Servant servant = (Servant)e.nextElement();
            this.releaseServant(servant);
        }
    }

    private void releaseServant(Servant servant) {
        try {
            servant._poa().deactivate_object(servant._object_id());
        }
        catch (WrongPolicy wpEx) {
            wpEx.printStackTrace();
        }
        catch (ObjectNotActive onaEx) {
            onaEx.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        this.consumerAdminDestroy();
        this.supplierAdminDestroy();
        this.releaseServant(this);
    }

    @Override
    public ConsumerAdmin for_consumers() {
        try {
            return ConsumerAdminHelper.narrow(this.myPoa.servant_to_reference(this));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public SupplierAdmin for_suppliers() {
        try {
            return SupplierAdminHelper.narrow(this.myPoa.servant_to_reference(this));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyPullConsumer obtain_pull_consumer() {
        Vector vector = this.pullConsumers;
        synchronized (vector) {
            ProxyPullConsumerImpl p = new ProxyPullConsumerImpl(this, this._orb(), this.myPoa);
            this.pullConsumers.addElement(p);
            return p._this(this.myOrb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyPullSupplier obtain_pull_supplier() {
        Vector vector = this.pullSuppliers;
        synchronized (vector) {
            ProxyPullSupplierImpl p = new ProxyPullSupplierImpl(this, this._orb(), this.myPoa);
            this.pullSuppliers.addElement(p);
            return p._this(this.myOrb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyPushConsumer obtain_push_consumer() {
        Vector vector = this.pushConsumers;
        synchronized (vector) {
            ProxyPushConsumerImpl p = new ProxyPushConsumerImpl(this, this._orb(), this.myPoa);
            this.pushConsumers.addElement(p);
            return p._this(this.myOrb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyPushSupplier obtain_push_supplier() {
        Vector vector = this.pushSuppliers;
        synchronized (vector) {
            ProxyPushSupplierImpl p = new ProxyPushSupplierImpl(this, this._orb(), this.myPoa);
            this.pushSuppliers.addElement(p);
            return p._this(this.myOrb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push_event(Any event) {
        int i;
        ProxyPushSupplierImpl push = null;
        ProxyPullSupplierImpl pull = null;
        Vector vector = this.pushSuppliers;
        synchronized (vector) {
            for (i = this.pushSuppliers.size() - 1; i >= 0; --i) {
                push = (ProxyPushSupplierImpl)this.pushSuppliers.elementAt(i);
                try {
                    push.push_to_consumer(event);
                    continue;
                }
                catch (COMM_FAILURE comm) {
                    this.pushSuppliers.removeElementAt(i);
                }
            }
        }
        vector = this.pullSuppliers;
        synchronized (vector) {
            for (i = this.pullSuppliers.size() - 1; i >= 0; --i) {
                pull = (ProxyPullSupplierImpl)this.pullSuppliers.elementAt(i);
                try {
                    pull.push_to_supplier(event);
                    continue;
                }
                catch (COMM_FAILURE comm) {
                    this.pullSuppliers.removeElementAt(i);
                }
            }
        }
    }

    public static void main(String[] args) {
        ORB orb = ORB.init(args, null);
        try {
            POA poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            EventChannelImpl channel = new EventChannelImpl(orb, poa);
            poa.the_POAManager().activate();
            Object o = poa.servant_to_reference(channel);
            NamingContextExt nc = NamingContextExtHelper.narrow(orb.resolve_initial_references("NameService"));
            String channelName = args.length > 0 ? args[0] : "Generic.channel";
            nc.bind(nc.to_name(channelName), o);
            orb.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public POA _default_POA() {
        return this.myPoa;
    }
}

