/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.CommunicationTimeout;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoDs.NamedDevFailed;
import fr.esrf.TangoDs.NamedDevFailedList;
import fr.esrf.TangoDs.TangoConst;
import java.io.Serializable;
import org.omg.CORBA.SystemException;

public class Except
implements TangoConst,
Serializable {
    public static String str_exception(Exception exception) {
        String string = "";
        if (exception instanceof ConnectionFailed) {
            string = string + ((ConnectionFailed)exception).getStack();
        } else if (exception instanceof CommunicationFailed) {
            string = string + ((CommunicationFailed)exception).getStack();
        } else if (exception instanceof WrongNameSyntax) {
            string = string + ((WrongNameSyntax)exception).getStack();
        } else if (exception instanceof WrongData) {
            string = string + ((WrongData)exception).getStack();
        } else if (exception instanceof NonDbDevice) {
            string = string + ((NonDbDevice)exception).getStack();
        } else if (exception instanceof NonSupportedFeature) {
            string = string + ((NonSupportedFeature)exception).getStack();
        } else if (exception instanceof EventSystemFailed) {
            string = string + ((EventSystemFailed)exception).getStack();
        } else if (exception instanceof AsynReplyNotArrived) {
            string = string + ((AsynReplyNotArrived)exception).getStack();
        } else if (exception instanceof DevFailed) {
            DevFailed devFailed = (DevFailed)exception;
            string = string + "Tango exception  " + devFailed.toString() + "\n";
            for (int i = 0; i < devFailed.errors.length; ++i) {
                string = string + "Severity -> ";
                switch (devFailed.errors[i].severity.value()) {
                    case 0: {
                        string = string + "WARNING \n";
                        break;
                    }
                    case 1: {
                        string = string + "ERROR \n";
                        break;
                    }
                    case 2: {
                        string = string + "PANIC \n";
                        break;
                    }
                    default: {
                        string = string + "Unknown severity code";
                    }
                }
                string = string + "Desc   -> " + devFailed.errors[i].desc + "\n";
                string = string + "Reason -> " + devFailed.errors[i].reason + "\n";
                string = string + "Origin -> " + devFailed.errors[i].origin + "\n";
                if (i >= devFailed.errors.length - 1) continue;
                string = string + "-------------------------------------------------------------\n";
            }
        } else {
            string = exception.toString();
        }
        return string;
    }

    public static void print_exception(DevError[] devErrorArray) {
        Except.print_exception(new DevFailed(devErrorArray));
    }

    public static void print_exception(Exception exception) {
        if (exception instanceof DevFailed) {
            DevFailed devFailed = (DevFailed)exception;
            for (int i = 0; i < devFailed.errors.length; ++i) {
                System.err.println("Tango exception");
                System.err.print("Severity -> ");
                switch (devFailed.errors[i].severity.value()) {
                    case 0: {
                        System.err.println("WARNING ");
                        break;
                    }
                    case 1: {
                        System.err.println("ERROR ");
                        break;
                    }
                    case 2: {
                        System.err.println("PANIC ");
                        break;
                    }
                    default: {
                        System.err.println("Unknown severity code");
                    }
                }
                System.err.println("Desc -> " + devFailed.errors[i].desc);
                if (exception instanceof NamedDevFailedList) {
                    NamedDevFailedList namedDevFailedList = (NamedDevFailedList)exception;
                    if (i < namedDevFailedList.get_faulty_attr_nb()) {
                        NamedDevFailed namedDevFailed = namedDevFailedList.elementAt(i);
                        for (DevError devError : namedDevFailed.err_stack) {
                            System.out.println("Reason -> " + devError.reason);
                        }
                    }
                } else {
                    System.err.println("Reason -> " + devFailed.errors[i].reason);
                }
                System.err.println("Origin -> " + devFailed.errors[i].origin);
            }
        } else {
            String string = exception.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n < 0) {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
                return;
            }
            String string2 = string.substring(n + 1);
            int n2 = string.lastIndexOf(46, n - 1);
            if (n2 < 0) {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
                return;
            }
            String string3 = string.substring(n2 + 1, n);
            if (string3.equals("CORBA")) {
                SystemException systemException = (SystemException)exception;
                System.err.println("CORBA system exception " + string2);
                System.err.println(exception.getMessage());
                System.err.print("Completed: ");
                switch (systemException.completed.value()) {
                    case 0: {
                        System.err.println("yes");
                        break;
                    }
                    case 1: {
                        System.err.println("no");
                        break;
                    }
                    case 2: {
                        System.err.println("maybe");
                    }
                }
                System.err.println("Minor code: " + systemException.minor);
            } else {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public static void print_exception_stack(Exception exception) {
        Except.print_exception(exception);
        exception.printStackTrace();
    }

    public static void throw_exception(String string, String string2, String string3) throws DevFailed {
        DevError[] devErrorArray = new DevError[]{new DevError()};
        devErrorArray[0].desc = string2;
        devErrorArray[0].severity = ErrSeverity.ERR;
        devErrorArray[0].reason = string;
        devErrorArray[0].origin = string3;
        throw new DevFailed(devErrorArray);
    }

    public static void throw_exception(String string, String string2, String string3, ErrSeverity errSeverity) throws DevFailed {
        DevError[] devErrorArray = new DevError[]{new DevError()};
        devErrorArray[0].desc = string2;
        devErrorArray[0].severity = errSeverity;
        devErrorArray[0].reason = string;
        devErrorArray[0].origin = string3;
        throw new DevFailed(devErrorArray);
    }

    public static void re_throw_exception(DevFailed devFailed, String string, String string2, String string3) throws DevFailed {
        int n = devFailed.errors.length;
        DevError[] devErrorArray = new DevError[n + 1];
        System.arraycopy(devFailed.errors, 0, devErrorArray, 0, n);
        devErrorArray[n] = new DevError();
        devErrorArray[n].desc = string2;
        devErrorArray[n].severity = ErrSeverity.ERR;
        devErrorArray[n].reason = string;
        devErrorArray[n].origin = string3;
        throw new DevFailed(devErrorArray);
    }

    public static void re_throw_exception(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws DevFailed {
        int n = devFailed.errors.length;
        DevError[] devErrorArray = new DevError[n + 1];
        System.arraycopy(devFailed.errors, 0, devErrorArray, 0, n);
        devErrorArray[n] = new DevError();
        devErrorArray[n].desc = string2;
        devErrorArray[n].severity = errSeverity;
        devErrorArray[n].reason = string;
        devErrorArray[n].origin = string3;
        throw new DevFailed(devErrorArray);
    }

    public static void throw_exception(SystemException systemException, String string) throws DevFailed {
        DevError[] devErrorArray = new DevError[]{new DevError()};
        devErrorArray[0].desc = Except.print_CORBA_SystemException(systemException);
        devErrorArray[0].severity = ErrSeverity.ERR;
        devErrorArray[0].reason = "API_CorbaSysException";
        devErrorArray[0].origin = string;
        throw new DevFailed(devErrorArray);
    }

    public static String print_CORBA_SystemException(SystemException systemException) {
        String string = systemException.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "Unknown system exception !!!!!!!!";
        }
        String string2 = string.substring(n + 1);
        int n2 = string.lastIndexOf(46, n - 1);
        if (n2 == -1) {
            return "Unknown system exception !!!!!!!!";
        }
        String string3 = string.substring(n2 + 1, n);
        if (string3.equals("CORBA")) {
            StringBuffer stringBuffer = new StringBuffer("CORBA system exception ");
            stringBuffer.append(string2);
            stringBuffer.append(systemException.getMessage());
            stringBuffer.append("Completed: ");
            switch (systemException.completed.value()) {
                case 0: {
                    stringBuffer.append("yes");
                    break;
                }
                case 1: {
                    stringBuffer.append("no");
                    break;
                }
                case 2: {
                    stringBuffer.append("maybe");
                }
            }
            stringBuffer.append("Minor code: ");
            stringBuffer.append(systemException.minor);
            return stringBuffer.toString();
        }
        return "Unknown system exception !!!!!!!!";
    }

    public static void throw_connection_failed(String string, String string2, String string3) throws ConnectionFailed {
        Except.throw_connection_failed(null, string, string2, string3, ErrSeverity.from_int(2));
    }

    public static void throw_connection_failed(DevFailed devFailed, String string, String string2, String string3) throws ConnectionFailed {
        Except.throw_connection_failed(devFailed, string, string2, string3, ErrSeverity.from_int(2));
    }

    public static void throw_connection_failed(String string, String string2, String string3, ErrSeverity errSeverity) throws ConnectionFailed {
        Except.throw_connection_failed(null, string, string2, string3, errSeverity);
    }

    public static void throw_connection_failed(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws ConnectionFailed {
        DevError[] devErrorArray;
        if (devFailed == null) {
            devErrorArray = new DevError[1];
        } else {
            devErrorArray = new DevError[devFailed.errors.length + 1];
            for (int i = 0; i < devFailed.errors.length; ++i) {
                devErrorArray[i] = devFailed.errors[i];
            }
        }
        devErrorArray[i] = new DevError(string, errSeverity, string2, string3);
        throw new ConnectionFailed(devErrorArray);
    }

    public static void throw_communication_failed(String string, String string2, String string3) throws CommunicationFailed {
        Except.throw_communication_failed(null, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_communication_failed(DevFailed devFailed, String string, String string2, String string3) throws CommunicationFailed {
        Except.throw_communication_failed(devFailed, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_communication_timeout(String string, String string2, String string3) throws CommunicationTimeout {
        Except.throw_communication_timeout(null, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_communication_failed(String string, String string2, String string3, ErrSeverity errSeverity) throws CommunicationFailed {
        Except.throw_communication_failed(null, string, string2, string3, errSeverity);
    }

    public static void throw_communication_failed(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws CommunicationFailed {
        DevError[] devErrorArray;
        if (devFailed == null) {
            devErrorArray = new DevError[1];
        } else {
            devErrorArray = new DevError[devFailed.errors.length + 1];
            for (int i = 0; i < devFailed.errors.length; ++i) {
                devErrorArray[i] = devFailed.errors[i];
            }
        }
        devErrorArray[i] = new DevError(string, errSeverity, string2, string3);
        throw new CommunicationFailed(devErrorArray);
    }

    public static void throw_communication_timeout(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws CommunicationTimeout {
        DevError[] devErrorArray;
        if (devFailed == null) {
            devErrorArray = new DevError[1];
        } else {
            devErrorArray = new DevError[devFailed.errors.length + 1];
            for (int i = 0; i < devFailed.errors.length; ++i) {
                devErrorArray[i] = devFailed.errors[i];
            }
        }
        devErrorArray[i] = new DevError(string, errSeverity, string2, string3);
        throw new CommunicationTimeout(devErrorArray);
    }

    public static void throw_wrong_syntax_exception(String string, String string2, String string3) throws WrongNameSyntax {
        Except.throw_wrong_syntax_exception(null, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_wrong_syntax_exception(DevFailed devFailed, String string, String string2, String string3) throws WrongNameSyntax {
        Except.throw_wrong_syntax_exception(devFailed, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_wrong_syntax_exception(String string, String string2, String string3, ErrSeverity errSeverity) throws WrongNameSyntax {
        Except.throw_wrong_syntax_exception(null, string, string2, string3, errSeverity);
    }

    public static void throw_wrong_syntax_exception(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws WrongNameSyntax {
        DevError[] devErrorArray;
        if (devFailed == null) {
            devErrorArray = new DevError[1];
        } else {
            devErrorArray = new DevError[devFailed.errors.length + 1];
            for (int i = 0; i < devFailed.errors.length; ++i) {
                devErrorArray[i] = devFailed.errors[i];
            }
        }
        devErrorArray[i] = new DevError(string, errSeverity, string2, string3);
        throw new WrongNameSyntax(devErrorArray);
    }

    public static void throw_wrong_data_exception(String string, String string2, String string3) throws WrongData {
        Except.throw_wrong_data_exception(null, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_wrong_data_exception(DevFailed devFailed, String string, String string2, String string3) throws WrongData {
        Except.throw_wrong_data_exception(devFailed, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_wrong_data_exception(String string, String string2, String string3, ErrSeverity errSeverity) throws WrongData {
        Except.throw_wrong_data_exception(null, string, string2, string3, errSeverity);
    }

    public static void throw_wrong_data_exception(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws WrongData {
        DevError[] devErrorArray;
        if (devFailed == null) {
            devErrorArray = new DevError[1];
        } else {
            devErrorArray = new DevError[devFailed.errors.length + 1];
            for (int i = 0; i < devFailed.errors.length; ++i) {
                devErrorArray[i] = devFailed.errors[i];
            }
        }
        devErrorArray[i] = new DevError(string, errSeverity, string2, string3);
        throw new WrongData(devErrorArray);
    }

    public static void throw_non_db_exception(String string, String string2, String string3) throws NonDbDevice {
        Except.throw_non_db_exception(null, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_non_db_exception(DevFailed devFailed, String string, String string2, String string3) throws NonDbDevice {
        Except.throw_non_db_exception(devFailed, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_non_db_exception(String string, String string2, String string3, ErrSeverity errSeverity) throws NonDbDevice {
        Except.throw_non_db_exception(null, string, string2, string3, errSeverity);
    }

    public static void throw_non_db_exception(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws NonDbDevice {
        DevError[] devErrorArray;
        if (devFailed == null) {
            devErrorArray = new DevError[1];
        } else {
            devErrorArray = new DevError[devFailed.errors.length + 1];
            for (int i = 0; i < devFailed.errors.length; ++i) {
                devErrorArray[i] = devFailed.errors[i];
            }
        }
        devErrorArray[i] = new DevError(string, errSeverity, string2, string3);
        throw new NonDbDevice(devErrorArray);
    }

    public static void throw_non_supported_exception(String string, String string2, String string3) throws NonSupportedFeature {
        Except.throw_non_supported_exception(null, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_non_supported_exception(DevFailed devFailed, String string, String string2, String string3) throws NonSupportedFeature {
        Except.throw_non_supported_exception(devFailed, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_non_supported_exception(String string, String string2, String string3, ErrSeverity errSeverity) throws NonSupportedFeature {
        Except.throw_non_supported_exception(null, string, string2, string3, errSeverity);
    }

    public static void throw_non_supported_exception(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws NonSupportedFeature {
        DevError[] devErrorArray;
        if (devFailed == null) {
            devErrorArray = new DevError[1];
        } else {
            devErrorArray = new DevError[devFailed.errors.length + 1];
            for (int i = 0; i < devFailed.errors.length; ++i) {
                devErrorArray[i] = devFailed.errors[i];
            }
        }
        devErrorArray[i] = new DevError(string, errSeverity, string2, string3);
        throw new NonSupportedFeature(devErrorArray);
    }

    public static void throw_asyn_reply_not_arrived(String string, String string2, String string3) throws AsynReplyNotArrived {
        Except.throw_asyn_reply_not_arrived(null, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_asyn_reply_not_arrived(DevFailed devFailed, String string, String string2, String string3) throws AsynReplyNotArrived {
        Except.throw_asyn_reply_not_arrived(devFailed, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_asyn_reply_not_arrived(String string, String string2, String string3, ErrSeverity errSeverity) throws AsynReplyNotArrived {
        Except.throw_asyn_reply_not_arrived(null, string, string2, string3, errSeverity);
    }

    public static void throw_asyn_reply_not_arrived(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws AsynReplyNotArrived {
        DevError[] devErrorArray;
        if (devFailed == null) {
            devErrorArray = new DevError[1];
        } else {
            devErrorArray = new DevError[devFailed.errors.length + 1];
            for (int i = 0; i < devFailed.errors.length; ++i) {
                devErrorArray[i] = devFailed.errors[i];
            }
        }
        devErrorArray[i] = new DevError(string, errSeverity, string2, string3);
        throw new AsynReplyNotArrived(devErrorArray);
    }

    public static void throw_event_system_failed(String string, String string2, String string3) throws EventSystemFailed {
        Except.throw_event_system_failed(null, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_event_system_failed(DevFailed devFailed, String string, String string2, String string3) throws EventSystemFailed {
        Except.throw_event_system_failed(devFailed, string, string2, string3, ErrSeverity.from_int(1));
    }

    public static void throw_event_system_failed(String string, String string2, String string3, ErrSeverity errSeverity) throws EventSystemFailed {
        Except.throw_event_system_failed(null, string, string2, string3, errSeverity);
    }

    public static void throw_event_system_failed(DevFailed devFailed, String string, String string2, String string3, ErrSeverity errSeverity) throws EventSystemFailed {
        DevError[] devErrorArray;
        if (devFailed == null) {
            devErrorArray = new DevError[1];
        } else {
            devErrorArray = new DevError[devFailed.errors.length + 1];
            for (int i = 0; i < devFailed.errors.length; ++i) {
                devErrorArray[i] = devFailed.errors[i];
            }
        }
        devErrorArray[i] = new DevError(string, errSeverity, string2, string3);
        throw new EventSystemFailed(devErrorArray);
    }
}

