/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoUserListener;
import fr.esrf.TangoApi.events.TangoUserEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoUser
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoUser(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoUserListener(ITangoUserListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoUserListener.class, listener);
        this.event_identifier = this.subscribe_user_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoUserListener(ITangoUserListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoUserListener.class, listener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoUser tangoUser = this;
        if (EventUtil.graphicAvailable()) {
            Runnable do_work_later = new Runnable(){

                @Override
                public void run() {
                    TangoUser.this.fireTangoUserEvent(tangoUser, eventData);
                }
            };
            SwingUtilities.invokeLater(do_work_later);
        } else {
            this.fireTangoUserEvent(tangoUser, eventData);
        }
    }

    private void fireTangoUserEvent(TangoUser tangoUser, EventData eventData) {
        TangoUserEvent tangoUserEvent = new TangoUserEvent(tangoUser, eventData);
        ArrayList<EventListener> listeners = this.event_listeners.getListeners(ITangoUserListener.class);
        for (EventListener eventListener : listeners) {
            ((ITangoUserListener)eventListener).user(tangoUserEvent);
        }
    }
}

