/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import java.util.Hashtable;

class KeepAliveThread
extends Thread
implements TangoConst {
    private static final long EVENT_RESUBSCRIBE_PERIOD = 600000L;
    private static final long EVENT_HEARTBEAT_PERIOD = 10000L;
    private static boolean stop = false;
    private static KeepAliveThread instance = null;

    private KeepAliveThread() {
        this.setName("KeepAliveThread");
    }

    @Override
    public void run() {
        while (!stop) {
            long l = System.currentTimeMillis();
            try {
                EventConsumer.subscribeIfNotDone();
                this.resubscribe_if_needed();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
            long l2 = 10000L - (System.currentTimeMillis() - l);
            if (l2 < 5L) {
                l2 = 5L;
            }
            this.waitNextLoop(l2);
        }
    }

    private synchronized void waitNextLoop(long l) {
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
    }

    synchronized void stopThread() {
        stop = true;
        if (instance != null) {
            this.notify();
        }
        instance = null;
    }

    static KeepAliveThread getInstance() {
        if (instance == null) {
            instance = new KeepAliveThread();
            instance.start();
        }
        return instance;
    }

    static boolean heartbeatHasBeenSkipped(EventChannelStruct eventChannelStruct) {
        long l = System.currentTimeMillis();
        return l - eventChannelStruct.last_heartbeat > 10000L;
    }

    private void resubscribe_if_needed() {
        Enumeration<String> enumeration = EventConsumer.getChannelMap().keys();
        long l = System.currentTimeMillis();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            EventChannelStruct eventChannelStruct = EventConsumer.getChannelMap().get(string);
            if (l - eventChannelStruct.last_subscribed > 200000L) {
                this.reSubscribeByName(eventChannelStruct, string);
            }
            eventChannelStruct.consumer.checkIfHeartbeatSkipped(string, eventChannelStruct);
        }
    }

    private void reSubscribeByName(EventChannelStruct eventChannelStruct, String string) {
        Hashtable<String, EventCallBackStruct> hashtable = EventConsumer.getEventCallbackMap();
        EventCallBackStruct eventCallBackStruct = null;
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct2 = hashtable.get(string2);
            if (!eventCallBackStruct2.channel_name.equals(string)) continue;
            eventCallBackStruct = eventCallBackStruct2;
        }
        if (eventCallBackStruct != null) {
            eventCallBackStruct.consumer.reSubscribeByName(eventChannelStruct, string);
        }
    }
}

