/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.LockerLanguage;
import fr.esrf.TangoApi.DevLockManager;
import fr.esrf.TangoDs.Except;
import java.util.UUID;

public class LockerInfo {
    private LockerLanguage language;
    private int cpp_pid = 0;
    private UUID uuid;
    private String hostname;
    private String classname;
    private String status;
    private boolean locked;
    private static final int STATUS_IDX = 0;
    private static final int ADD_IDX = 1;
    private static final int CLASS_IDX = 2;
    private static final int LOCK_IDX = 0;
    private static final int PID_IDX = 1;
    private static final int UUID_IDX = 2;

    LockerInfo(DevVarLongStringArray devVarLongStringArray) {
        this.locked = devVarLongStringArray.lvalue[0] != 0;
        this.cpp_pid = devVarLongStringArray.lvalue[1];
        if (this.cpp_pid == 0) {
            this.language = LockerLanguage.JAVA;
            long l = this.build64(devVarLongStringArray.lvalue[2], devVarLongStringArray.lvalue[3]);
            long l2 = this.build64(devVarLongStringArray.lvalue[4], devVarLongStringArray.lvalue[5]);
            this.uuid = new UUID(l, l2);
        } else {
            this.language = LockerLanguage.CPP;
        }
        this.status = devVarLongStringArray.svalue[0];
        this.hostname = this.parseHostAddress(devVarLongStringArray.svalue[1]);
        if (this.language == LockerLanguage.JAVA) {
            this.classname = devVarLongStringArray.svalue[2];
        }
    }

    private String parseHostAddress(String string) {
        int n;
        String string2 = "giop:tcp:";
        if (string.startsWith(string2)) {
            string = string.substring(string2.length());
        }
        if ((n = string.lastIndexOf(58)) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private long build64(int n, int n2) {
        long l = n;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        return (l << 32) + l2;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isJavaProcess() {
        return this.language == LockerLanguage.JAVA;
    }

    public boolean isCppProcess() {
        return this.language == LockerLanguage.CPP;
    }

    public UUID getJavaUUID() throws DevFailed {
        if (this.language == LockerLanguage.CPP) {
            Except.throw_exception("API_WrongData", "The locker is not a java process", "LockerInfo.getJavaUUID()");
        }
        return this.uuid;
    }

    public int getCppPID() throws DevFailed {
        if (this.language == LockerLanguage.JAVA) {
            Except.throw_exception("API_WrongData", "The locker is not a Cpp process", "LockerInfo.getCppPID()");
        }
        return this.cpp_pid;
    }

    public String getClassName() {
        return this.classname;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getStatus() {
        return this.status;
    }

    boolean isMe() {
        DevLockManager devLockManager = DevLockManager.getInstance();
        if (!devLockManager.getMainClass().equals(this.classname)) {
            System.out.println(devLockManager.getMainClass() + "!=" + this.classname);
            return false;
        }
        if (this.uuid.compareTo(devLockManager.getUUID()) != 0) {
            System.out.println("UUID different");
            return false;
        }
        return this.hostname.equals(devLockManager.getHost());
    }

    public String toString() {
        return this.status;
    }
}

