/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangoUrl;
import java.util.Hashtable;

public class DeviceProxyFactory {
    private static Hashtable<String, DeviceProxy> proxy_table = new Hashtable();

    public static DeviceProxy get(String string) throws DevFailed {
        String string2 = string.startsWith("tango:") ? string : new TangoUrl(string).toString().toLowerCase();
        String string3 = ApiUtil.get_default_db_obj().getUrl().getTangoHost();
        return DeviceProxyFactory.get(string2, string3);
    }

    public static DeviceProxy get(String string, String string2) throws DevFailed {
        String string3 = string.startsWith("tango://") || string.startsWith("//") ? string : "tango://" + string2 + "/" + string;
        DeviceProxy deviceProxy = proxy_table.get(string3);
        if (deviceProxy == null) {
            try {
                deviceProxy = new DeviceProxy(string);
                proxy_table.put(string3, deviceProxy);
            }
            catch (DevFailed devFailed) {
                devFailed.printStackTrace();
                throw devFailed;
            }
        }
        return deviceProxy;
    }

    public static boolean exists(String string) throws DevFailed {
        String string2 = new TangoUrl(string).toString();
        DeviceProxy deviceProxy = proxy_table.get(string2);
        return deviceProxy != null;
    }

    public static void remove(String string) {
        try {
            String string2 = new TangoUrl(string).toString();
            if (proxy_table.containsKey(string2)) {
                proxy_table.remove(string2);
            }
        }
        catch (DevFailed devFailed) {
            System.err.println(devFailed.errors[0].desc);
        }
    }

    public static void remove(DeviceProxy deviceProxy) {
        String string = deviceProxy.url.toString();
        if (proxy_table.containsKey(string)) {
            proxy_table.remove(string);
        }
    }

    static void add(DeviceProxy deviceProxy) {
        String string = deviceProxy.url.toString();
        DeviceProxy deviceProxy2 = proxy_table.get(string);
        if (deviceProxy2 == null) {
            proxy_table.put(string, deviceProxy);
        }
    }
}

