/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.JavaClntIdent;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.DeviceProxyFactory;
import fr.esrf.TangoApi.LockerInfo;
import fr.esrf.TangoDs.Except;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.UUID;
import java.util.Vector;

class DevLockManager {
    private static DevLockManager instance = null;
    private static UUID uuid;
    private static long[] l_uuid;
    private static String mainClass;
    private static String host_add;
    private static JavaClntIdent j_ident;
    private static ClntIdent ident;
    private static boolean hasManagementClasses;
    private static Hashtable<String, LockedDeviceAmin> relockMap;
    private static final long VALIDITY_DELAY = 500L;

    static DevLockManager getInstance() {
        if (instance == null) {
            instance = new DevLockManager();
        }
        return instance;
    }

    private DevLockManager() {
        RuntimeMXBean runtimeMXBean;
        StackTraceElement[] stackTraceElementArray;
        int n;
        uuid = UUID.randomUUID();
        l_uuid = new long[2];
        DevLockManager.l_uuid[0] = uuid.getMostSignificantBits();
        DevLockManager.l_uuid[1] = uuid.getLeastSignificantBits();
        String string = null;
        if (hasManagementClasses && (n = (stackTraceElementArray = (runtimeMXBean = ManagementFactory.getRuntimeMXBean()).getName()).indexOf(64)) > 0) {
            string = stackTraceElementArray.substring(0, n);
        }
        try {
            int n2 = 0;
            n2 = 1 / n2;
            System.out.println(n2);
        }
        catch (Exception exception) {
            stackTraceElementArray = exception.getStackTrace();
            String string2 = stackTraceElementArray[stackTraceElementArray.length - 1].toString();
            int n3 = string2.indexOf(".main");
            if (n3 > 0) {
                mainClass = string2.substring(0, n3);
                if (string != null) {
                    mainClass = mainClass + " - PID=" + string;
                }
            }
            mainClass = string != null ? "PID=" + string : string2.substring(string2.lastIndexOf(40));
        }
        j_ident = new JavaClntIdent(mainClass, l_uuid);
        ident = new ClntIdent();
        ident.java_clnt(j_ident);
        try {
            host_add = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    JavaClntIdent getJavaClntIdent() {
        return j_ident;
    }

    ClntIdent getClntIdent() {
        return ident;
    }

    String getMainClass() {
        return mainClass;
    }

    String getHost() {
        return host_add;
    }

    UUID getUUID() {
        return uuid;
    }

    public String toString() {
        String string = mainClass + ":\n";
        for (long l : l_uuid) {
            string = string + l + "\n";
        }
        return string.trim();
    }

    void lock(DeviceProxy deviceProxy, int n) throws DevFailed {
        deviceProxy.import_admin_device("lock");
        DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
        devVarLongStringArray.svalue = new String[1];
        devVarLongStringArray.lvalue = new int[1];
        devVarLongStringArray.svalue[0] = deviceProxy.get_name();
        devVarLongStringArray.lvalue[0] = n;
        DeviceData deviceData = new DeviceData();
        deviceData.insert(devVarLongStringArray);
        deviceProxy.getAdm_dev().command_inout("LockDevice", deviceData);
        this.addToRelockList(deviceProxy, n);
    }

    int unlock(DeviceProxy deviceProxy) throws DevFailed {
        deviceProxy.import_admin_device("unlock");
        DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
        devVarLongStringArray.svalue = new String[1];
        devVarLongStringArray.lvalue = new int[1];
        devVarLongStringArray.svalue[0] = deviceProxy.get_name();
        devVarLongStringArray.lvalue[0] = 0;
        DeviceData deviceData = new DeviceData();
        deviceData.insert(devVarLongStringArray);
        DeviceData deviceData2 = deviceProxy.getAdm_dev().command_inout("UnlockDevice", deviceData);
        int n = deviceData2.extractLong();
        if (n == 0) {
            this.removeToRelockList(deviceProxy);
        }
        return n;
    }

    boolean isLocked(DeviceProxy deviceProxy) throws DevFailed {
        LockerInfo lockerInfo = this.getLockerInfo(deviceProxy);
        return lockerInfo.isLocked();
    }

    boolean isLockedByMe(DeviceProxy deviceProxy) throws DevFailed {
        LockerInfo lockerInfo = this.getLockerInfo(deviceProxy);
        return lockerInfo.isMe();
    }

    String getLockerStatus(DeviceProxy deviceProxy) throws DevFailed {
        LockerInfo lockerInfo = this.getLockerInfo(deviceProxy);
        return lockerInfo.getStatus();
    }

    LockerInfo getLockerInfo(DeviceProxy deviceProxy) throws DevFailed {
        deviceProxy.import_admin_device("getLockerInfo");
        DeviceData deviceData = new DeviceData();
        deviceData.insert(deviceProxy.get_name());
        DeviceData deviceData2 = deviceProxy.getAdm_dev().command_inout("DevLockStatus", deviceData);
        return new LockerInfo(deviceData2.extractLongStringArray());
    }

    void addToRelockList(DeviceProxy deviceProxy, int n) throws DevFailed {
        String string;
        if (relockMap == null) {
            relockMap = new Hashtable();
            Runtime.getRuntime().addShutdownHook(new ShutdownThread());
            new GarbageThread().start();
        }
        try {
            string = deviceProxy.adm_name();
        }
        catch (DevFailed devFailed) {
            return;
        }
        LockedDevice lockedDevice = new LockedDevice(deviceProxy.get_name(), n);
        if (!relockMap.containsKey(string)) {
            LockedDeviceAmin lockedDeviceAmin = new LockedDeviceAmin(string, lockedDevice);
            lockedDeviceAmin.start();
            relockMap.put(string, lockedDeviceAmin);
        } else {
            LockedDeviceAmin lockedDeviceAmin = relockMap.get(string);
            lockedDeviceAmin.add(lockedDevice);
        }
    }

    void removeToRelockList(DeviceProxy deviceProxy) {
        String string;
        try {
            string = deviceProxy.adm_name();
        }
        catch (DevFailed devFailed) {
            return;
        }
        if (relockMap.containsKey(string)) {
            LockedDeviceAmin lockedDeviceAmin = relockMap.get(string);
            lockedDeviceAmin.remove(deviceProxy.get_name());
        }
    }

    static {
        mainClass = null;
        host_add = null;
        hasManagementClasses = true;
        try {
            Class<ManagementFactory> clazz = ManagementFactory.class;
        }
        catch (Exception exception) {
            hasManagementClasses = false;
        }
        catch (Error error) {
            hasManagementClasses = false;
        }
        relockMap = null;
    }

    private class LockedDeviceAmin
    extends Thread {
        private DeviceProxy device = null;
        private final String name;
        private long t_relock;
        private final Vector<LockedDevice> devices;

        LockedDeviceAmin(String string, LockedDevice lockedDevice) throws DevFailed {
            this.device = DeviceProxyFactory.get(string);
            this.name = string;
            this.devices = new Vector();
            this.devices.add(lockedDevice);
            this.t_relock = System.currentTimeMillis();
        }

        private void add(LockedDevice lockedDevice) {
            for (LockedDevice lockedDevice2 : this.devices) {
                if (!lockedDevice2.name.equals(lockedDevice.name)) continue;
                return;
            }
            this.devices.add(lockedDevice);
            this.wakeUp();
        }

        private String[] getDeviceNames() {
            String[] stringArray = new String[this.devices.size()];
            for (int i = 0; i < this.devices.size(); ++i) {
                stringArray[i] = this.devices.get(i).name;
            }
            return stringArray;
        }

        private void remove(String string) {
            for (int i = 0; i < this.devices.size(); ++i) {
                LockedDevice lockedDevice = this.devices.get(i);
                if (!lockedDevice.name.equals(string)) continue;
                System.out.println("------- >removing " + string);
                this.devices.remove(lockedDevice);
            }
            if (this.devices.size() == 0) {
                relockMap.remove(this.name);
            }
            this.wakeUp();
        }

        private void cleanUp() {
            try {
                DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
                devVarLongStringArray.svalue = new String[this.devices.size()];
                for (int i = 0; i < this.devices.size(); ++i) {
                    devVarLongStringArray.svalue[i] = this.devices.get(0).name;
                }
                devVarLongStringArray.lvalue = new int[1];
                devVarLongStringArray.lvalue[0] = 1;
                DeviceData deviceData = new DeviceData();
                deviceData.insert(devVarLongStringArray);
                DeviceProxy deviceProxy = DeviceProxyFactory.get(this.name);
                deviceProxy.import_admin_device("CleanUp");
                deviceProxy.getAdm_dev().command_inout("UnlockDevice", deviceData);
                System.out.println("all devices unlocked.");
            }
            catch (DevFailed devFailed) {
                Except.print_exception(devFailed);
            }
        }

        private int getMinValidity() {
            int n = 0xFFFFFFF;
            for (LockedDevice lockedDevice : this.devices) {
                if (n <= lockedDevice.validity) continue;
                n = lockedDevice.validity;
            }
            if (n == 0xFFFFFFF) {
                n = 1;
            }
            return n;
        }

        private void traceRelock(String[] stringArray) {
            System.out.print(this.name + ":\tRelockDevices for ");
            for (String string : stringArray) {
                System.out.print(" " + string);
            }
            System.out.println();
        }

        private void relock() {
            String[] stringArray = this.getDeviceNames();
            this.traceRelock(stringArray);
            try {
                DeviceData deviceData = new DeviceData();
                deviceData.insert(stringArray);
                this.device.command_inout("RelockDevices", deviceData);
            }
            catch (DevFailed devFailed) {
                for (DevError devError : devFailed.errors) {
                    int n;
                    Object object;
                    String string = devError.reason;
                    if (string.equals("TangoApi_DEVICE_NOT_EXPORTED")) {
                        object = stringArray;
                        n = ((String[])object).length;
                        for (int i = 0; i < n; ++i) {
                            Object object2 = object[i];
                            this.remove((String)object2);
                        }
                        continue;
                    }
                    if (!string.equals("API_DeviceNotLocked") && !string.equals("API_DeviceLocked") || (n = ((String)(object = devError.desc)).indexOf(58)) <= 0) continue;
                    String string2 = ((String)object).substring(0, n).trim();
                    this.remove(string2);
                }
            }
        }

        private synchronized void wakeUp() {
            this.notify();
        }

        private long getTimeToSleep() {
            long l = System.currentTimeMillis();
            int n = this.getMinValidity() * 1000;
            return (long)n - (l - this.t_relock) - 500L;
        }

        private synchronized void waitNext() {
            long l = this.getTimeToSleep();
            while (l > 500L && this.devices.size() > 0) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l = this.getTimeToSleep();
            }
        }

        @Override
        public void run() {
            while (this.devices.size() > 0) {
                this.waitNext();
                if (this.devices.size() <= 0) continue;
                this.relock();
                this.t_relock = System.currentTimeMillis();
            }
            System.out.println("thread for " + this.name + "  exiting....");
        }
    }

    private class LockedDevice {
        private final String name;
        private final int validity;

        LockedDevice(String string, int n) {
            this.name = string;
            this.validity = n;
        }
    }

    private class GarbageThread
    extends Thread {
        private GarbageThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (relockMap.size() > 0) {
                    System.gc();
                }
                try {
                    GarbageThread.sleep(9500L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            System.out.println("exiting.....");
            Enumeration enumeration = relockMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                LockedDeviceAmin lockedDeviceAmin = (LockedDeviceAmin)relockMap.get(string);
                lockedDeviceAmin.cleanUp();
            }
        }
    }
}

