/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangoEnv;
import fr.esrf.TangoDs.Except;
import java.util.Hashtable;
import java.util.Vector;

class AccessProxy
extends DeviceProxy {
    protected static String user = null;
    protected static String hostAddr = null;
    protected boolean forced = TangoEnv.isSuperTango();
    private static boolean muliIP = true;
    protected Hashtable<String, String> dev_right_table = new Hashtable();
    protected Hashtable<String, String[]> allowed_cmd_table = new Hashtable();
    private static final Object monitor = new Object();

    AccessProxy(String string) throws DevFailed {
        super(string, false);
        System.out.println(string + " -> Forced to write access = " + this.forced);
        if (!this.forced) {
            this.set_transparency_reconnection(false);
            this.ping();
            this.set_transparency_reconnection(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkAccessControl(String string) throws DevFailed {
        if (this.forced) {
            return 1;
        }
        Object object = monitor;
        synchronized (object) {
            String string2 = this.dev_right_table.get(string);
            if (string2 != null) {
                if (string2.equals("write")) {
                    return 1;
                }
                return 0;
            }
            try {
                String string3;
                if (user == null) {
                    user = System.getProperty("user.name").toLowerCase();
                }
                hostAddr = ApiUtil.getHostAddress();
                DeviceData deviceData = new DeviceData();
                if (muliIP) {
                    Vector<String> vector = ApiUtil.getHostAddresses();
                    String[] stringArray = new String[vector.size() + 2];
                    int n = 0;
                    stringArray[n++] = user;
                    stringArray[n++] = string;
                    for (String string4 : vector) {
                        stringArray[n++] = string4;
                    }
                    deviceData.insert(stringArray);
                    string3 = this.command_inout("GetAccessForMultiIP", deviceData).extractString();
                } else {
                    deviceData.insert(new String[]{user, hostAddr, string});
                    string3 = this.command_inout("GetAccess", deviceData).extractString();
                }
                this.dev_right_table.put(string, string3);
                if (string3.equals("write")) {
                    return 1;
                }
                return 0;
            }
            catch (DevFailed devFailed) {
                if (!devFailed.errors[0].reason.equals("TangoApi_DEVICE_NOT_EXPORTED")) {
                    if (muliIP && devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                        System.err.println(devFailed.errors[0].desc + "  -  TAC server is an old version");
                        muliIP = false;
                        return this.checkAccessControl(string);
                    }
                    throw devFailed;
                }
                Except.re_throw_exception(devFailed, "TangoApi_CANNOT_CHECK_ACCESS_CONTROL", "Cannot import Access Control device !", "AccessProxy.checkAccessControl()");
            }
        }
        return 0;
    }

    boolean isCommandAllowed(String string, String string2) {
        String[] stringArray = this.allowed_cmd_table.get(string);
        if (stringArray == null) {
            stringArray = this.getAllowedCommands(string);
        }
        if (stringArray.length == 0) {
            return false;
        }
        for (String string3 : stringArray) {
            if (!string3.toLowerCase().equals(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected String[] getAllowedCommands(String string) {
        try {
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = this.command_inout("GetAllowedCommands", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            this.allowed_cmd_table.put(string, stringArray);
            return stringArray;
        }
        catch (DevFailed devFailed) {
            String[] stringArray = new String[]{};
            this.allowed_cmd_table.put(string, stringArray);
            return stringArray;
        }
    }
}

