/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import ij.plugin.ScreenGrabber;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Recorder;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Hashtable;
import java.util.Vector;

public class GenericDialog
extends Dialog
implements ActionListener,
TextListener,
FocusListener,
ItemListener,
KeyListener,
AdjustmentListener {
    public static final int MAX_SLIDERS = 25;
    protected Vector numberField;
    protected Vector stringField;
    protected Vector checkbox;
    protected Vector choice;
    protected Vector slider;
    protected TextArea textArea1;
    protected TextArea textArea2;
    protected Vector defaultValues;
    protected Vector defaultText;
    protected Component theLabel;
    private Button cancel;
    private Button okay;
    private boolean wasCanceled;
    private boolean wasOKed;
    private int y;
    private int nfIndex;
    private int sfIndex;
    private int cbIndex;
    private int choiceIndex;
    private int textAreaIndex;
    private GridBagLayout grid;
    private GridBagConstraints c;
    private boolean firstNumericField = true;
    private boolean firstSlider = true;
    private boolean invalidNumber;
    private String errorMessage;
    private boolean firstPaint = true;
    private Hashtable labels;
    private boolean macro;
    private String macroOptions;
    private int topInset;
    private int leftInset;
    private int bottomInset;
    private boolean customInsets;
    private int[] sliderIndexes;
    private Checkbox previewCheckbox;
    private Vector dialogListeners;
    private PlugInFilterRunner pfr;
    private String previewLabel = " Preview";
    private static final String previewRunning = "wait...";
    private boolean recorderOn;

    public GenericDialog(String title) {
        this(title, WindowManager.getCurrentImage() != null ? WindowManager.getCurrentImage().getWindow() : (IJ.getInstance() != null ? IJ.getInstance() : new Frame()));
    }

    public GenericDialog(String title, Frame parent) {
        super(parent == null ? new Frame() : parent, title, true);
        if (Prefs.blackCanvas) {
            this.setForeground(SystemColor.controlText);
            this.setBackground(SystemColor.control);
        }
        this.grid = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.grid);
        this.macroOptions = Macro.getOptions();
        this.macro = this.macroOptions != null;
        this.addKeyListener(this);
    }

    public void addNumericField(String label, double defaultValue, int digits) {
        this.addNumericField(label, defaultValue, digits, 6, null);
    }

    public void addNumericField(String label, double defaultValue, int digits, int columns, String units) {
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        Label theLabel = this.makeLabel(label2);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstNumericField ? this.getInsets(5, 0, 3, 0) : this.getInsets(0, 0, 3, 0);
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        if (IJ.isWindows()) {
            columns -= 2;
        }
        if (columns < 1) {
            columns = 1;
        }
        TextField tf = new TextField(IJ.d2s(defaultValue, digits), columns);
        if (IJ.isLinux()) {
            tf.setBackground(Color.white);
        }
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.numberField.addElement(tf);
        this.defaultValues.addElement(new Double(defaultValue));
        this.defaultText.addElement(tf.getText());
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        tf.setEditable(true);
        if (this.firstNumericField) {
            tf.selectAll();
        }
        this.firstNumericField = false;
        if (units == null || units.equals("")) {
            this.grid.setConstraints(tf, this.c);
            this.add(tf);
        } else {
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0, 0, 0));
            panel.add(tf);
            panel.add(new Label(" " + units));
            this.grid.setConstraints(panel, this.c);
            this.add(panel);
        }
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
        ++this.y;
    }

    private Label makeLabel(String label) {
        if (IJ.isMacintosh()) {
            label = label + " ";
        }
        return new Label(label);
    }

    private void saveLabel(Component component, String label) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        if (label.length() > 0) {
            if (label.charAt(0) == ' ') {
                label = label.trim();
            }
            this.labels.put(component, label);
        }
    }

    public void addStringField(String label, String defaultText) {
        this.addStringField(label, defaultText, 8);
    }

    public void addStringField(String label, String defaultText, int columns) {
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        Label theLabel = this.makeLabel(label2);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        if (this.stringField == null) {
            this.stringField = new Vector(4);
            this.c.insets = this.getInsets(5, 0, 5, 0);
        } else {
            this.c.insets = this.getInsets(0, 0, 5, 0);
        }
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        TextField tf = new TextField(defaultText, columns);
        if (IJ.isLinux()) {
            tf.setBackground(Color.white);
        }
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(tf, this.c);
        tf.setEditable(true);
        this.add(tf);
        this.stringField.addElement(tf);
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
        ++this.y;
    }

    public void addCheckbox(String label, boolean defaultValue) {
        this.addCheckbox(label, defaultValue, false);
    }

    private void addCheckbox(String label, boolean defaultValue, boolean isPreview) {
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        if (this.checkbox == null) {
            this.checkbox = new Vector(4);
            this.c.insets = this.getInsets(15, 20, 0, 0);
        } else {
            this.c.insets = this.getInsets(0, 20, 0, 0);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        Checkbox cb = new Checkbox(label2);
        this.grid.setConstraints(cb, this.c);
        cb.setState(defaultValue);
        cb.addItemListener(this);
        cb.addKeyListener(this);
        this.add(cb);
        this.checkbox.addElement(cb);
        if (!isPreview && (Recorder.record || this.macro)) {
            this.saveLabel(cb, label);
        }
        if (isPreview) {
            this.previewCheckbox = cb;
        }
        ++this.y;
    }

    public void addPreviewCheckbox(PlugInFilterRunner pfr) {
        if (this.previewCheckbox != null) {
            return;
        }
        this.pfr = pfr;
        this.addCheckbox(this.previewLabel, false, true);
    }

    public void addPreviewCheckbox(PlugInFilterRunner pfr, String label) {
        if (this.previewCheckbox != null) {
            return;
        }
        this.previewLabel = label;
        this.pfr = pfr;
        this.addCheckbox(this.previewLabel, false, true);
    }

    public void addCheckboxGroup(int rows, int columns, String[] labels, boolean[] defaultValues) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(rows, columns, 5, 0));
        int startCBIndex = this.cbIndex;
        int i1 = 0;
        int[] index = new int[labels.length];
        if (this.checkbox == null) {
            this.checkbox = new Vector(12);
        }
        boolean addListeners = labels.length <= 4;
        for (int row = 0; row < rows; ++row) {
            int i2;
            for (int col = 0; col < columns && (i2 = col * rows + row) < labels.length; ++col) {
                index[i1] = i2;
                String label = labels[i1];
                if (label.indexOf(95) != -1) {
                    label = label.replace('_', ' ');
                }
                Checkbox cb = new Checkbox(label);
                this.checkbox.addElement(cb);
                cb.setState(defaultValues[i1]);
                if (addListeners) {
                    cb.addItemListener(this);
                }
                if (Recorder.record || this.macro) {
                    this.saveLabel(cb, labels[i1]);
                }
                panel.add(cb);
                ++i1;
            }
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(10, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addChoice(String label, String[] items, String defaultItem) {
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        Label theLabel = this.makeLabel(label2);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        if (this.choice == null) {
            this.choice = new Vector(4);
            this.c.insets = this.getInsets(5, 0, 5, 0);
        } else {
            this.c.insets = this.getInsets(0, 0, 5, 0);
        }
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        Choice thisChoice = new Choice();
        thisChoice.addKeyListener(this);
        thisChoice.addItemListener(this);
        for (int i = 0; i < items.length; ++i) {
            thisChoice.addItem(items[i]);
        }
        thisChoice.select(defaultItem);
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(thisChoice, this.c);
        this.add(thisChoice);
        this.choice.addElement(thisChoice);
        if (Recorder.record || this.macro) {
            this.saveLabel(thisChoice, label);
        }
        ++this.y;
    }

    public void addMessage(String text) {
        this.theLabel = text.indexOf(10) >= 0 ? new MultiLineLabel(text) : new Label(text);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(text.equals("") ? 0 : 10, 20, 0, 0);
        this.grid.setConstraints(this.theLabel, this.c);
        this.add(this.theLabel);
        ++this.y;
    }

    public void addTextAreas(String text1, String text2, int rows, int columns) {
        if (this.textArea1 != null) {
            return;
        }
        Panel panel = new Panel();
        this.textArea1 = new TextArea(text1, rows, columns, 3);
        if (IJ.isLinux()) {
            this.textArea1.setBackground(Color.white);
        }
        this.textArea1.addTextListener(this);
        panel.add(this.textArea1);
        if (text2 != null) {
            this.textArea2 = new TextArea(text2, rows, columns, 3);
            if (IJ.isLinux()) {
                this.textArea2.setBackground(Color.white);
            }
            panel.add(this.textArea2);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(15, 20, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addSlider(String label, double minValue, double maxValue, double defaultValue) {
        int columns = 4;
        int digits = 0;
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        Label theLabel = this.makeLabel(label2);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = new Insets(0, 0, 3, 0);
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        if (this.slider == null) {
            this.slider = new Vector(5);
            this.sliderIndexes = new int[25];
        }
        Scrollbar s = new Scrollbar(0, (int)defaultValue, 1, (int)minValue, (int)maxValue + 1);
        this.slider.addElement(s);
        s.addAdjustmentListener(this);
        s.setUnitIncrement(1);
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        if (IJ.isWindows()) {
            columns -= 2;
        }
        if (columns < 1) {
            columns = 1;
        }
        TextField tf = new TextField(IJ.d2s(defaultValue, digits), columns);
        if (IJ.isLinux()) {
            tf.setBackground(Color.white);
        }
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.numberField.addElement(tf);
        this.sliderIndexes[this.slider.size() - 1] = this.numberField.size() - 1;
        this.defaultValues.addElement(new Double(defaultValue));
        this.defaultText.addElement(tf.getText());
        tf.setEditable(true);
        if (this.firstNumericField && this.firstSlider) {
            tf.selectAll();
        }
        this.firstSlider = false;
        Panel panel = new Panel();
        GridBagLayout pgrid = new GridBagLayout();
        GridBagConstraints pc = new GridBagConstraints();
        panel.setLayout(pgrid);
        pc.gridx = 0;
        pc.gridy = 0;
        pc.gridwidth = 1;
        pc.ipadx = 75;
        pc.anchor = 17;
        pgrid.setConstraints(s, pc);
        panel.add(s);
        pc.ipadx = 0;
        pc.gridx = 1;
        pc.insets = new Insets(5, 5, 0, 0);
        pc.anchor = 13;
        pgrid.setConstraints(tf, pc);
        panel.add(tf);
        this.grid.setConstraints(panel, this.c);
        this.c.gridx = 1;
        this.c.gridy = this.y++;
        this.c.gridwidth = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(0, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
    }

    public void addPanel(Panel panel) {
        this.addPanel(panel, 17, new Insets(5, 0, 0, 0));
    }

    public void addPanel(Panel panel, int contraints, Insets insets) {
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = contraints;
        this.c.insets = insets;
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void setInsets(int top, int left, int bottom) {
        this.topInset = top;
        this.leftInset = left;
        this.bottomInset = bottom;
        this.customInsets = true;
    }

    Insets getInsets(int top, int left, int bottom, int right) {
        if (this.customInsets) {
            this.customInsets = false;
            return new Insets(this.topInset, this.leftInset, this.bottomInset, 0);
        }
        return new Insets(top, left, bottom, right);
    }

    public void addDialogListener(DialogListener dl) {
        if (this.dialogListeners == null) {
            this.dialogListeners = new Vector();
        }
        this.dialogListeners.addElement(dl);
        if (IJ.debugMode) {
            IJ.log("GenericDialog: Listener added: " + dl);
        }
    }

    public boolean wasCanceled() {
        if (this.wasCanceled) {
            Macro.abort();
        }
        return this.wasCanceled;
    }

    public boolean wasOKed() {
        return this.wasOKed || this.macro;
    }

    public double getNextNumber() {
        double value;
        if (this.numberField == null) {
            return -1.0;
        }
        TextField tf = (TextField)this.numberField.elementAt(this.nfIndex);
        String theText = tf.getText();
        String label = null;
        if (this.macro) {
            label = (String)this.labels.get(tf);
            theText = Macro.getValue(this.macroOptions, label, theText);
        }
        String originalText = (String)this.defaultText.elementAt(this.nfIndex);
        double defaultValue = (Double)this.defaultValues.elementAt(this.nfIndex);
        if (theText.equals(originalText)) {
            value = defaultValue;
        } else {
            Double d = this.getValue(theText);
            if (d != null) {
                value = d;
            } else {
                this.invalidNumber = true;
                this.errorMessage = "\"" + theText + "\" is an invalid number";
                value = 0.0;
                if (this.macro) {
                    IJ.error("Macro Error", "Numeric value expected in run() function\n \n   Dialog: \"" + this.getTitle() + "\"\n" + "   Label: \"" + label + "\"\n" + "   Value: \"" + theText + "\"");
                }
            }
        }
        if (this.recorderOn) {
            this.recordOption(tf, this.trim(theText));
        }
        ++this.nfIndex;
        return value;
    }

    private String trim(String value) {
        if (value.endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        if (value.endsWith(".00")) {
            value = value.substring(0, value.length() - 3);
        }
        return value;
    }

    private void recordOption(Component component, String value) {
        String label = (String)this.labels.get(component);
        Recorder.recordOption(label, value);
    }

    private void recordCheckboxOption(Checkbox cb) {
        String label = (String)this.labels.get(cb);
        if (label != null) {
            if (cb.getState()) {
                Recorder.recordOption(label);
            } else if (Recorder.getCommandOptions() == null) {
                Recorder.recordOption(" ");
            }
        }
    }

    protected Double getValue(String theText) {
        Double d;
        try {
            d = new Double(theText);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        return d;
    }

    public boolean invalidNumber() {
        boolean wasInvalid = this.invalidNumber;
        this.invalidNumber = false;
        return wasInvalid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getNextString() {
        if (this.stringField == null) {
            return "";
        }
        TextField tf = (TextField)this.stringField.elementAt(this.sfIndex);
        String theText = tf.getText();
        if (this.macro) {
            String label = (String)this.labels.get(tf);
            theText = Macro.getValue(this.macroOptions, label, theText);
        }
        if (this.recorderOn) {
            this.recordOption(tf, theText);
        }
        ++this.sfIndex;
        return theText;
    }

    public boolean getNextBoolean() {
        if (this.checkbox == null) {
            return false;
        }
        Checkbox cb = (Checkbox)this.checkbox.elementAt(this.cbIndex);
        if (this.recorderOn) {
            this.recordCheckboxOption(cb);
        }
        boolean state = cb.getState();
        if (this.macro) {
            String label = (String)this.labels.get(cb);
            String key = Macro.trimKey(label);
            state = this.isMatch(this.macroOptions, key + " ");
        }
        ++this.cbIndex;
        return state;
    }

    boolean isMatch(String s1, String s2) {
        int len1 = s1.length();
        int len2 = s2.length();
        boolean inLiteral = false;
        for (int i = 0; i < len1 - len2 + 1; ++i) {
            char c = s1.charAt(i);
            if (inLiteral && c == ']') {
                inLiteral = false;
            } else if (c == '[') {
                inLiteral = true;
            }
            if (c != s2.charAt(0) || inLiteral || i > 1 && s1.charAt(i - 1) == '=') continue;
            boolean match = true;
            for (int j = 0; j < len2; ++j) {
                if (s2.charAt(j) == s1.charAt(i + j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public String getNextChoice() {
        if (this.choice == null) {
            return "";
        }
        Choice thisChoice = (Choice)this.choice.elementAt(this.choiceIndex);
        String item = thisChoice.getSelectedItem();
        if (this.macro) {
            String label = (String)this.labels.get(thisChoice);
            item = Macro.getValue(this.macroOptions, label, item);
        }
        if (this.recorderOn) {
            this.recordOption(thisChoice, item);
        }
        ++this.choiceIndex;
        return item;
    }

    public int getNextChoiceIndex() {
        if (this.choice == null) {
            return -1;
        }
        Choice thisChoice = (Choice)this.choice.elementAt(this.choiceIndex);
        int index = thisChoice.getSelectedIndex();
        if (this.macro) {
            String label = (String)this.labels.get(thisChoice);
            String oldItem = thisChoice.getSelectedItem();
            int oldIndex = thisChoice.getSelectedIndex();
            String item = Macro.getValue(this.macroOptions, label, oldItem);
            thisChoice.select(item);
            index = thisChoice.getSelectedIndex();
            if (index == oldIndex && !item.equals(oldItem)) {
                IJ.error(this.getTitle(), "\"" + item + "\" is not a valid choice for \"" + label + "\"");
            }
        }
        if (this.recorderOn) {
            this.recordOption(thisChoice, thisChoice.getSelectedItem());
        }
        ++this.choiceIndex;
        return index;
    }

    public String getNextText() {
        String text;
        if (this.textAreaIndex == 0 && this.textArea1 != null) {
            text = this.textArea1.getText();
            ++this.textAreaIndex;
            if (this.macro) {
                text = Macro.getValue(this.macroOptions, "text1", text);
            }
            if (this.recorderOn) {
                String text2 = text;
                String cmd = Recorder.getCommand();
                if (cmd != null && cmd.equals("Convolve...")) {
                    text2 = text.replaceAll("\n", "\\\\n");
                    if (!text.endsWith("\n")) {
                        text2 = text2 + "\\\\n";
                    }
                } else {
                    text2 = text.replace('\n', ' ');
                }
                Recorder.recordOption("text1", text2);
            }
        } else if (this.textAreaIndex == 1 && this.textArea2 != null) {
            this.textArea2.selectAll();
            text = this.textArea2.getText();
            ++this.textAreaIndex;
            if (this.macro) {
                text = Macro.getValue(this.macroOptions, "text2", text);
            }
            if (this.recorderOn) {
                Recorder.recordOption("text2", text.replace('\n', ' '));
            }
        } else {
            text = null;
        }
        return text;
    }

    public void showDialog() {
        if (this.macro) {
            this.dispose();
        } else {
            if (this.pfr != null) {
                this.pfr.setDialog(this);
            }
            if (this.stringField != null && this.numberField == null) {
                TextField tf = (TextField)this.stringField.elementAt(0);
                tf.selectAll();
            }
            Panel buttons = new Panel();
            buttons.setLayout(new FlowLayout(1, 5, 0));
            this.cancel = new Button("Cancel");
            this.cancel.addActionListener(this);
            this.cancel.addKeyListener(this);
            this.okay = new Button("  OK  ");
            this.okay.addActionListener(this);
            this.okay.addKeyListener(this);
            if (IJ.isMacintosh()) {
                buttons.add(this.cancel);
                buttons.add(this.okay);
            } else {
                buttons.add(this.okay);
                buttons.add(this.cancel);
            }
            this.c.gridx = 0;
            this.c.gridy = this.y;
            this.c.anchor = 13;
            this.c.gridwidth = 2;
            this.c.insets = new Insets(15, 0, 0, 0);
            this.grid.setConstraints(buttons, this.c);
            this.add(buttons);
            if (IJ.isMacintosh()) {
                this.setResizable(false);
            }
            this.pack();
            this.setup();
            GUI.center(this);
            this.show();
            this.recorderOn = Recorder.record;
        }
        if (!this.wasCanceled && this.dialogListeners != null && this.dialogListeners.size() > 0) {
            this.resetCounters();
            ((DialogListener)this.dialogListeners.elementAt(0)).dialogItemChanged(this, null);
            this.recorderOn = false;
        }
        this.resetCounters();
        if (!this.macro) {
            IJ.wait(100);
        }
    }

    private void resetCounters() {
        this.nfIndex = 0;
        this.sfIndex = 0;
        this.cbIndex = 0;
        this.choiceIndex = 0;
        this.textAreaIndex = 0;
        this.invalidNumber = false;
    }

    public Vector getNumericFields() {
        return this.numberField;
    }

    public Vector getStringFields() {
        return this.stringField;
    }

    public Vector getCheckboxes() {
        return this.checkbox;
    }

    public Vector getChoices() {
        return this.choice;
    }

    public Vector getSliders() {
        return this.slider;
    }

    public TextArea getTextArea1() {
        return this.textArea1;
    }

    public TextArea getTextArea2() {
        return this.textArea2;
    }

    public Component getMessage() {
        return this.theLabel;
    }

    public Checkbox getPreviewCheckbox() {
        return this.previewCheckbox;
    }

    public void previewRunning(boolean isRunning) {
        if (this.previewCheckbox != null) {
            this.previewCheckbox.setLabel(isRunning ? previewRunning : this.previewLabel);
            if (IJ.isMacOSX()) {
                this.repaint();
            }
        }
    }

    protected void setup() {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okay || source == this.cancel) {
            this.wasCanceled = source == this.cancel;
            this.wasOKed = source == this.okay;
            this.closeDialog();
        } else {
            this.notifyListeners(e);
        }
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public void textValueChanged(TextEvent e) {
        this.notifyListeners(e);
        if (this.slider == null) {
            return;
        }
        Object source = e.getSource();
        for (int i = 0; i < this.slider.size(); ++i) {
            TextField tf;
            double value;
            int index = this.sliderIndexes[i];
            if (source != this.numberField.elementAt(index) || Double.isNaN(value = Tools.parseDouble((tf = (TextField)this.numberField.elementAt(index)).getText()))) continue;
            Scrollbar sb = (Scrollbar)this.slider.elementAt(i);
            sb.setValue((int)value);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.notifyListeners(e);
    }

    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            ((TextField)c).selectAll();
        }
    }

    public void focusLost(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            ((TextField)c).select(0, 0);
        }
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        if (keyCode == 10 && this.textArea1 == null) {
            this.closeDialog();
        } else if (keyCode == 27) {
            this.wasCanceled = true;
            this.closeDialog();
            IJ.resetEscape();
        }
    }

    public void keyReleased(KeyEvent e) {
        boolean shift;
        int keyCode = e.getKeyCode();
        IJ.setKeyUp(keyCode);
        int flags = e.getModifiers();
        boolean control = (flags & 2) != 0;
        boolean meta = (flags & 4) != 0;
        boolean bl = shift = (flags & 1) != 0;
        if (keyCode == 71 && shift && (control || meta) && IJ.isJava2()) {
            new ScreenGrabber().run("");
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public Insets getInsets() {
        Insets i = super.getInsets();
        return new Insets(i.top + 10, i.left + 10, i.bottom + 10, i.right + 10);
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        for (int i = 0; i < this.slider.size(); ++i) {
            if (source != this.slider.elementAt(i)) continue;
            Scrollbar sb = (Scrollbar)source;
            TextField tf = (TextField)this.numberField.elementAt(this.sliderIndexes[i]);
            tf.setText("" + sb.getValue());
        }
    }

    private void notifyListeners(AWTEvent e) {
        boolean workaroundOSXbug;
        if (this.dialogListeners == null) {
            return;
        }
        boolean everythingOk = true;
        for (int i = 0; everythingOk && i < this.dialogListeners.size(); ++i) {
            try {
                this.resetCounters();
                if (((DialogListener)this.dialogListeners.elementAt(i)).dialogItemChanged(this, e)) continue;
                everythingOk = false;
                continue;
            }
            catch (Exception err) {
                IJ.beep();
                IJ.log("ERROR: " + err + "\nin DialogListener of " + this.dialogListeners.elementAt(i) + "\nat " + err.getStackTrace()[0] + "\nfrom " + err.getStackTrace()[1]);
            }
        }
        boolean bl = workaroundOSXbug = IJ.isMacOSX() && !this.okay.isEnabled() && everythingOk;
        if (this.previewCheckbox != null) {
            this.previewCheckbox.setEnabled(everythingOk);
        }
        this.okay.setEnabled(everythingOk);
        if (workaroundOSXbug) {
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint) {
            if (this.numberField != null) {
                TextField tf = (TextField)this.numberField.elementAt(0);
                tf.requestFocus();
                if (IJ.isMacOSX()) {
                    tf.setEditable(false);
                    tf.setEditable(true);
                }
            } else if (this.stringField == null) {
                this.okay.requestFocus();
            }
            this.firstPaint = false;
        }
    }
}

