/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.ArrayArrayCommand;
import fr.esrf.tangoatk.core.command.ArrayScalarCommand;
import fr.esrf.tangoatk.core.command.ArrayTableCommand;
import fr.esrf.tangoatk.core.command.ArrayVoidCommand;
import fr.esrf.tangoatk.core.command.BooleanVoidCommand;
import fr.esrf.tangoatk.core.command.InvalidCommand;
import fr.esrf.tangoatk.core.command.ScalarArrayCommand;
import fr.esrf.tangoatk.core.command.ScalarScalarCommand;
import fr.esrf.tangoatk.core.command.ScalarTableCommand;
import fr.esrf.tangoatk.core.command.ScalarVoidCommand;
import fr.esrf.tangoatk.core.command.StringVoidCommand;
import fr.esrf.tangoatk.core.command.TableArrayCommand;
import fr.esrf.tangoatk.core.command.TableScalarCommand;
import fr.esrf.tangoatk.core.command.TableTableCommand;
import fr.esrf.tangoatk.core.command.TableVoidCommand;
import fr.esrf.tangoatk.core.command.VoidArrayCommand;
import fr.esrf.tangoatk.core.command.VoidScalarCommand;
import fr.esrf.tangoatk.core.command.VoidTableCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class CommandFactory
extends AEntityFactory {
    private Vector<ACommand> commands = new Vector();
    private String[] cmdNames = new String[0];
    private static CommandFactory instance;

    protected CommandFactory() {
    }

    @Override
    public int getSize() {
        return this.commands.size();
    }

    public static CommandFactory getInstance() {
        if (instance == null) {
            instance = new CommandFactory();
        }
        return instance;
    }

    private int getCommandPos(String string) {
        return Arrays.binarySearch(this.cmdNames, string.toLowerCase());
    }

    @Override
    protected synchronized List<IEntity> getWildCardEntities(String string, Device device) throws DevFailed {
        Vector<IEntity> vector = new Vector<IEntity>();
        CommandInfo[] commandInfoArray = device.getCommandList();
        for (int i = 0; i < commandInfoArray.length; ++i) {
            String string2 = CommandFactory.getFQName(device, commandInfoArray[i].cmd_name);
            ICommand iCommand = this.getSingleCommand(string2, commandInfoArray[i], device);
            vector.add(iCommand);
        }
        return vector;
    }

    private ICommand getSingleCommand(String string, CommandInfo commandInfo, Device device) {
        int n = this.getCommandPos(string);
        if (n >= 0) {
            return this.commands.get(n);
        }
        return this.initCommand(device, commandInfo, -(n + 1), string);
    }

    @Override
    protected synchronized IEntity getSingleEntity(String string, Device device) throws DevFailed {
        String string2 = CommandFactory.extractEntityName(string);
        CommandInfo commandInfo = device.getCommand(string2);
        return this.getSingleCommand(string, commandInfo, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommand getCommand(String string) throws ConnectionException, DevFailed {
        Device device = null;
        IEntity iEntity = null;
        CommandFactory commandFactory = this;
        synchronized (commandFactory) {
            int n = this.getCommandPos(string);
            if (n >= 0) {
                iEntity = this.commands.get(n);
            }
        }
        if (iEntity == null) {
            device = this.getDevice(CommandFactory.extractDeviceName(string));
            iEntity = this.getSingleEntity(string, device);
        }
        if (iEntity instanceof ACommand) {
            return (ACommand)iEntity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACommand[] getCommands() {
        ACommand[] aCommandArray = new ACommand[this.commands.size()];
        CommandFactory commandFactory = this;
        synchronized (commandFactory) {
            for (int i = 0; i < this.commands.size(); ++i) {
                aCommandArray[i] = this.commands.get(i);
            }
        }
        return aCommandArray;
    }

    public boolean isCommand(String string) {
        try {
            return this.getCommand(string) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private ACommand initCommand(Device device, CommandInfo commandInfo, int n, String string) {
        ACommand aCommand = this.getCommandOfType(device.getName(), commandInfo);
        aCommand.init(device, commandInfo.cmd_name, commandInfo);
        int n2 = this.cmdNames.length;
        String[] stringArray = new String[n2 + 1];
        System.arraycopy(this.cmdNames, 0, stringArray, 0, n);
        System.arraycopy(this.cmdNames, n, stringArray, n + 1, n2 - n);
        stringArray[n] = string.toLowerCase();
        this.cmdNames = stringArray;
        this.commands.add(n, aCommand);
        this.dumpFactory("Adding " + string);
        return aCommand;
    }

    private ACommand getCommandOfType(String string, CommandInfo commandInfo) {
        if (commandInfo == null) {
            System.out.println("Warning, DeviceFactory.getCommandOfType(): null CommandInfo pointer got from " + string);
            return new InvalidCommand();
        }
        int n = commandInfo.in_type;
        int n2 = commandInfo.out_type;
        String string2 = commandInfo.cmd_name;
        if (ACommand.isTable(n2)) {
            if (ACommand.isTable(n)) {
                return new TableTableCommand();
            }
            if (ACommand.isArray(n)) {
                return new ArrayTableCommand();
            }
            if (ACommand.isScalar(n)) {
                return new ScalarTableCommand();
            }
            if (ACommand.isVoid(n)) {
                return new VoidTableCommand();
            }
        }
        if (ACommand.isArray(n2)) {
            if (ACommand.isTable(n)) {
                return new TableArrayCommand();
            }
            if (ACommand.isArray(n)) {
                return new ArrayArrayCommand();
            }
            if (ACommand.isScalar(n)) {
                return new ScalarArrayCommand();
            }
            if (ACommand.isVoid(n)) {
                return new VoidArrayCommand();
            }
        }
        if (ACommand.isScalar(n2)) {
            if (ACommand.isTable(n)) {
                return new TableScalarCommand();
            }
            if (ACommand.isArray(n)) {
                return new ArrayScalarCommand();
            }
            if (ACommand.isScalar(n)) {
                return new ScalarScalarCommand();
            }
            if (ACommand.isVoid(n)) {
                return new VoidScalarCommand();
            }
        }
        if (ACommand.isVoid(n2)) {
            if (ACommand.isTable(n)) {
                return new TableVoidCommand();
            }
            if (ACommand.isArray(n)) {
                return new ArrayVoidCommand();
            }
            if (ACommand.isBoolean(n)) {
                return new BooleanVoidCommand();
            }
            if (ACommand.isString(n)) {
                return new StringVoidCommand();
            }
            if (ACommand.isScalar(n)) {
                return new ScalarVoidCommand();
            }
            if (ACommand.isVoid(n)) {
                return new VoidVoidCommand();
            }
        }
        System.out.println("DeviceFactory.getCommandOfType() : Warning, Unsupported type for command " + string + " " + string2 + "(in type=" + n + ",out type=" + n2 + ")");
        return new InvalidCommand();
    }

    private void dumpFactory(String string) {
        if ((DeviceFactory.getInstance().getTraceMode() & 0x400) != 0) {
            System.out.println("-- CommnadFactory : " + string + " ------------");
            for (int i = 0; i < this.cmdNames.length; ++i) {
                System.out.println("  " + i + ":" + this.cmdNames[i]);
            }
            System.out.println("-- CommnadFactory --------------------------------------");
        }
    }

    @Override
    public String getVersion() {
        return "$Id: CommandFactory.java 12968 2009-01-26 17:54:56Z poncet $";
    }
}

