/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.INumberSpectrumHistory;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberSpectrumHistory;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NumberSpectrum
extends ANumber
implements INumberSpectrum {
    double[] spectrumValue;
    double[] spectrumSetPointValue;
    double[] devSpectrumValue;
    double[] devSpectrumSetPointValue;
    boolean hasXminmaxProperties = false;
    boolean hasXminmaxAttributes = false;
    String XminAttName = null;
    String XmaxAttName = null;
    double xminValue = -1.0;
    double xmaxValue = -1.0;

    public ANumberSpectrumHelper getNumberSpectrumHelper() {
        return (ANumberSpectrumHelper)this.getNumberHelper();
    }

    @Override
    public void addSpectrumListener(ISpectrumListener iSpectrumListener) {
        this.propChanges.addSpectrumListener(iSpectrumListener);
    }

    @Override
    public void removeSpectrumListener(ISpectrumListener iSpectrumListener) {
        this.propChanges.removeSpectrumListener(iSpectrumListener);
    }

    public void setValue(double[][] dArray) {
        this.setValue(dArray[0]);
    }

    public double[][] getValue() {
        double[][] dArrayArray = new double[][]{this.getSpectrumValue()};
        return dArrayArray;
    }

    @Override
    public void setValue(double[] dArray) {
        try {
            this.insert(dArray);
            this.writeAtt();
            this.refresh();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    protected void checkDimensions(double[] dArray) {
        if (dArray.length > this.getMaxXDimension()) {
            throw new IllegalStateException();
        }
    }

    protected void insert(double[] dArray) {
        this.checkDimensions(dArray);
        this.getNumberSpectrumHelper().insert(dArray);
    }

    @Override
    public void refresh() {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                DeviceAttribute deviceAttribute = this.readValueFromNetwork();
                this.spectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplayValue(deviceAttribute);
                this.spectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplaySetPoint(deviceAttribute);
                this.devSpectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumValue(deviceAttribute);
                this.devSpectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumSetPoint(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.getNumberSpectrumHelper().fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.devSpectrumValue = null;
            this.devSpectrumSetPointValue = null;
            System.out.println("NumberSpectrum.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberSpectrum.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplayValue(deviceAttribute);
                this.spectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplaySetPoint(deviceAttribute);
                this.devSpectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumValue(deviceAttribute);
                this.devSpectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumSetPoint(deviceAttribute);
                this.getNumberSpectrumHelper().fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.devSpectrumValue = null;
            this.devSpectrumSetPointValue = null;
            System.out.println("NumberSpectrum.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberSpectrum.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed devFailed) {
        this.spectrumValue = null;
        this.spectrumSetPointValue = null;
        this.devSpectrumValue = null;
        this.devSpectrumSetPointValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    @Override
    public double[] getSpectrumValue() {
        return this.spectrumValue;
    }

    @Override
    public double[] getSpectrumDeviceValue() {
        return this.devSpectrumValue;
    }

    @Override
    public double[] getSpectrumStandardValue() {
        double d = 1.0;
        d = this.getStandardUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return this.devSpectrumValue;
        }
        if (this.devSpectrumValue == null) {
            return null;
        }
        double[] dArray = new double[this.devSpectrumValue.length];
        for (int i = 0; i < this.devSpectrumValue.length; ++i) {
            dArray[i] = this.devSpectrumValue[i] * d;
        }
        return dArray;
    }

    @Override
    public double[] getSpectrumSetPoint() {
        return this.spectrumSetPointValue;
    }

    @Override
    public double[] getSpectrumDeviceSetPoint() {
        return this.devSpectrumSetPointValue;
    }

    @Override
    public double[] getSpectrumStandardSetPoint() {
        double d = 1.0;
        d = this.getStandardUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return this.devSpectrumSetPointValue;
        }
        if (this.devSpectrumSetPointValue == null) {
            return null;
        }
        double[] dArray = new double[this.devSpectrumSetPointValue.length];
        for (int i = 0; i < this.devSpectrumSetPointValue.length; ++i) {
            dArray[i] = this.devSpectrumSetPointValue[i] * d;
        }
        return dArray;
    }

    @Override
    public INumberSpectrumHistory[] getNumberSpectrumHistory() {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = null;
        try {
            iNumberSpectrumHistoryArray = (NumberSpectrumHistory[])this.getNumberSpectrumHelper().getSpectrumAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            iNumberSpectrumHistoryArray = null;
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
            iNumberSpectrumHistoryArray = null;
        }
        return iNumberSpectrumHistoryArray;
    }

    @Override
    public INumberSpectrumHistory[] getNumberSpectrumDeviceHistory() {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = null;
        try {
            iNumberSpectrumHistoryArray = (NumberSpectrumHistory[])this.getNumberSpectrumHelper().getSpectrumDeviceAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            iNumberSpectrumHistoryArray = null;
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
            iNumberSpectrumHistoryArray = null;
        }
        return iNumberSpectrumHistoryArray;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        this.eventType = tangoPeriodicEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "NumberSpectrum.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.devSpectrumValue = null;
            this.devSpectrumSetPointValue = null;
            System.out.println("NumberSpectrum.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplayValue(deviceAttribute);
                this.spectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplaySetPoint(deviceAttribute);
                this.devSpectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumValue(deviceAttribute);
                this.devSpectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumSetPoint(deviceAttribute);
                this.getNumberSpectrumHelper().fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                System.out.println("NumberSpectrum.periodic.getNumberSpectrumDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberSpectrum.periodic.getNumberSpectrumDisplayValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        this.eventType = tangoChangeEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "NumberSpectrum.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.devSpectrumValue = null;
            this.devSpectrumSetPointValue = null;
            System.out.println("NumberSpectrum.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplayValue(deviceAttribute);
                this.spectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplaySetPoint(deviceAttribute);
                this.devSpectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumValue(deviceAttribute);
                this.devSpectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumSetPoint(deviceAttribute);
                this.getNumberSpectrumHelper().fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                System.out.println("NumberSpectrum.change.getNumberSpectrumDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberSpectrum.change.getNumberSpectrumDisplayValue()------------------------------------------------");
            }
        }
    }

    @Override
    public void freeInternalData() {
        super.freeInternalData();
        this.spectrumValue = null;
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    @Override
    public String getVersion() {
        return "$Id: NumberSpectrum.java 22752 2013-06-03 11:45:34Z jlpons $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public int getYDimension() {
        return 1;
    }

    @Override
    public int getMaxYDimension() {
        return 1;
    }

    @Override
    public boolean hasMinxMaxxAttributes() {
        return this.hasXminmaxAttributes;
    }

    @Override
    public boolean hasMinxMaxxProperties() {
        return this.hasXminmaxProperties;
    }

    @Override
    public String getMinxAttName() {
        return this.XminAttName;
    }

    @Override
    public String getMaxxAttName() {
        return this.XmaxAttName;
    }

    @Override
    public double getMinx() {
        return this.xminValue;
    }

    @Override
    public double getMaxx() {
        return this.xmaxValue;
    }

    @Override
    public void loadAttProperties() {
        DbAttribute dbAttribute = null;
        DbDatum dbDatum = null;
        String string = null;
        String string2 = null;
        double d = -1.0;
        double d2 = -1.0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.attPropertiesLoaded = true;
            dbAttribute = this.getDevice().get_attribute_property(this.getNameSansDevice());
            if (dbAttribute == null) {
                return;
            }
            if (!dbAttribute.is_empty("XminAttribute") && (dbDatum = dbAttribute.datum("XminAttribute")) != null && !dbDatum.is_empty()) {
                string = dbDatum.extractString();
            }
            if (!dbAttribute.is_empty("XmaxAttribute") && (dbDatum = dbAttribute.datum("XmaxAttribute")) != null && !dbDatum.is_empty()) {
                string2 = dbDatum.extractString();
            }
            if (string != null && string2 != null && string.length() > 0 && string2.length() > 0) {
                this.hasXminmaxAttributes = true;
            }
            if (this.hasXminmaxAttributes) {
                this.XminAttName = string;
                this.XmaxAttName = string2;
                return;
            }
            if (!dbAttribute.is_empty("Xmin") && (dbDatum = dbAttribute.datum("Xmin")) != null && !dbDatum.is_empty()) {
                bl = true;
                d = dbDatum.extractDouble();
            }
            if (!dbAttribute.is_empty("Xmax") && (dbDatum = dbAttribute.datum("Xmax")) != null && !dbDatum.is_empty()) {
                bl2 = true;
                d2 = dbDatum.extractDouble();
            }
            if (bl && bl2) {
                this.hasXminmaxProperties = true;
                this.xminValue = d;
                this.xmaxValue = d2;
            }
        }
        catch (Exception exception) {
            System.out.println("get_attribute_property(" + this.getName() + ") thrown exception");
            exception.printStackTrace();
        }
    }
}

