/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NumberImage
extends ANumber
implements INumberImage {
    double[][] imageValue;

    public ANumberImageHelper getNumberImageHelper() {
        return (ANumberImageHelper)this.getNumberHelper();
    }

    public void addNumberImageListener(IImageListener iImageListener) {
        this.getNumberImageHelper().addImageListener(iImageListener);
    }

    public void removeNumberImageListener(IImageListener iImageListener) {
        this.getNumberImageHelper().removeImageListener(iImageListener);
    }

    protected void insert(String[][] stringArray) {
        this.checkDimensions(stringArray);
        this.insert(NumberAttributeHelper.str2double(stringArray));
    }

    @Override
    public void refresh() {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.imageValue = this.getNumberImageHelper().getNumberImageDisplayValue(this.readValueFromNetwork());
                this.getNumberImageHelper().fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.imageValue = null;
            System.out.println("NumberImage.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberImage.refresh()------------------------------------------------");
        }
    }

    @Override
    public void addImageListener(IImageListener iImageListener) {
        this.propChanges.addImageListener(iImageListener);
    }

    @Override
    public void removeImageListener(IImageListener iImageListener) {
        this.propChanges.removeImageListener(iImageListener);
    }

    @Override
    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.getNumberImageHelper().getNumberImageDisplayValue(deviceAttribute);
                this.getNumberImageHelper().fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            this.imageValue = null;
            System.out.println("NumberImage.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberImage.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed devFailed) {
        this.imageValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    @Override
    public void setValue(double[][] dArray) {
        try {
            this.checkDimensions(dArray);
            this.insert(dArray);
            this.writeAtt();
            this.getNumberImageHelper().fireImageValueChanged(dArray, System.currentTimeMillis());
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    void insert(double[][] dArray) {
        this.getNumberImageHelper().insert(dArray);
    }

    public String[][] extract() throws DevFailed {
        return this.getNumberImageHelper().getImageValueAsString(this.readValueFromNetwork());
    }

    @Override
    public double[][] getValue() {
        return this.imageValue;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        this.eventType = tangoPeriodicEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "NumberImage.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.imageValue = null;
            System.out.println("NumberImage.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberImage.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.getNumberImageHelper().getNumberImageDisplayValue(deviceAttribute);
                this.getNumberImageHelper().fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.imageValue = null;
                System.out.println("NumberImage.periodic.getNumberImageDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberImage.periodic.getNumberImageDisplayValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        this.eventType = tangoChangeEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "NumberImage.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.imageValue = null;
            System.out.println("NumberImage.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberImage.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.getNumberImageHelper().getNumberImageDisplayValue(deviceAttribute);
                this.getNumberImageHelper().fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.imageValue = null;
                System.out.println("NumberImage.change.getNumberImageDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberImage.change.getNumberImageDisplayValue()------------------------------------------------");
            }
        }
    }

    @Override
    public void freeInternalData() {
        super.freeInternalData();
        this.imageValue = null;
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    @Override
    public String getVersion() {
        return "$Id: NumberImage.java 22752 2013-06-03 11:45:34Z jlpons $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

