/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.DevStateScalarHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DevStateScalar
extends AAttribute
implements IDevStateScalar {
    DevStateScalarHelper devStateHelper = new DevStateScalarHelper(this);
    String devStateValue = null;
    String setPointValue = null;
    boolean invertOpenClose = false;
    boolean invertInsertExtract = false;

    @Override
    public int getXDimension() {
        return 1;
    }

    @Override
    public int getMaxXDimension() {
        return 1;
    }

    @Override
    public String getValue() {
        return this.devStateValue;
    }

    @Override
    public String getDeviceValue() {
        try {
            String string;
            this.devStateValue = string = Device.toString(this.readValueFromNetwork().extractState());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
        }
        catch (Exception exception) {
            System.out.println("DevStateScalar.getDeviceValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.getDeviceValue()------------------------------------------------");
        }
        return this.devStateValue;
    }

    @Override
    public void setValue(String string) {
        try {
            this.attribute.insert(Device.getStateFromString(string));
            this.writeAtt();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
        catch (Exception exception) {
            System.out.println("Received un exception other than DevFailed while setting a devStateScalar");
            this.setAttError("Couldn't set value", new AttributeSetException("Set Exception other than DevFailed."));
        }
    }

    @Override
    public String getSetPoint() {
        return this.setPointValue;
    }

    @Override
    public String getDeviceSetPoint() {
        String string = null;
        try {
            this.setPointValue = string = this.devStateHelper.getDevStateScalarSetPoint(this.readDeviceValueFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
        }
        return string;
    }

    private boolean isConnected() {
        return this.getDevice().isConnected();
    }

    @Override
    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        if (this.skippingRefresh) {
            return;
        }
        if (!this.isConnected()) {
            this.reconnectAtt();
        }
        if (!this.isConnected()) {
            this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") failed, device not connected; will call readAttError", l);
            this.readAttError("Failed to read the state attribute. Connection to device failed.", new AttributeReadException("Failed to read the state attribute. Connection to device failed."));
            return;
        }
        ++this.refreshCount;
        this.trace(4, "DevStateScalar.refresh() method called for " + this.getName(), l);
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") readValueFromNetwork success", l);
                if (deviceAttribute == null) {
                    return;
                }
                this.devStateValue = Device.toString(deviceAttribute.extractState());
                this.setPointValue = this.devStateHelper.getDevStateScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.devStateValue);
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") fireValueChanged(devStateValue) success", l);
            }
            catch (DevFailed devFailed) {
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") failed, caught DevFailed; will call readAttError", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") Code failure, caught other Exception", l);
            System.out.println("DevStateScalar.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.devStateValue = Device.toString(deviceAttribute.extractState());
                this.setPointValue = this.devStateHelper.getDevStateScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.devStateValue);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            System.out.println("DevStateScalar.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed devFailed) {
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String string) {
        this.devStateHelper.fireValueChanged(string, this.timeStamp);
    }

    @Override
    public void addDevStateScalarListener(IDevStateScalarListener iDevStateScalarListener) {
        this.devStateHelper.addDevStateScalarListener(iDevStateScalarListener);
        this.addStateListener(iDevStateScalarListener);
    }

    @Override
    public void removeDevStateScalarListener(IDevStateScalarListener iDevStateScalarListener) {
        this.devStateHelper.removeDevStateScalarListener(iDevStateScalarListener);
        this.removeStateListener(iDevStateScalarListener);
    }

    public String getDevStateValue() {
        return this.devStateValue;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        this.eventType = tangoPeriodicEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "DevStateScalar.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("DevStateScalar.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") setState(da) called", l);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.devStateValue = Device.toString(deviceAttribute.extractState());
                this.setPointValue = this.devStateHelper.getDevStateScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.devStateValue);
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") fireValueChanged(devStateValue) called", l);
            }
            catch (DevFailed devFailed) {
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") failed, got DevFailed when called fireValueChanged(devStateValue)", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", l);
                System.out.println("DevStateScalar.periodic: Device.toString(extractState()) Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("DevStateScalar.periodic: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        this.eventType = tangoChangeEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "DevStateScalar.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("DevStateScalar.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") setState(da) called", l);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.devStateValue = Device.toString(deviceAttribute.extractState());
                this.setPointValue = this.devStateHelper.getDevStateScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.devStateValue);
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") fireValueChanged(devStateValue) called", l);
            }
            catch (DevFailed devFailed) {
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") failed, got DevFailed when called da.extractState()", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", l);
                System.out.println("DevStateScalar.change: Device.toString(extractState()) Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("DevStateScalar.change: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    @Override
    public boolean getInvertedOpenClose() {
        return this.invertOpenClose;
    }

    @Override
    public boolean getInvertedInsertExtract() {
        return this.invertInsertExtract;
    }

    @Override
    public void loadAttProperties() {
        DbAttribute dbAttribute = null;
        DbDatum dbDatum = null;
        try {
            this.attPropertiesLoaded = true;
            dbAttribute = this.getDevice().get_attribute_property(this.getNameSansDevice());
            if (dbAttribute == null) {
                return;
            }
            if (!dbAttribute.is_empty("OpenCloseInverted") && (dbDatum = dbAttribute.datum("OpenCloseInverted")) != null && !dbDatum.is_empty()) {
                this.invertOpenClose = dbDatum.extractBoolean();
            }
            if (!dbAttribute.is_empty("InsertExtractInverted") && (dbDatum = dbAttribute.datum("InsertExtractInverted")) != null && !dbDatum.is_empty()) {
                this.invertInsertExtract = dbDatum.extractBoolean();
            }
        }
        catch (Exception exception) {
            System.out.println("get_attribute_property(" + this.getName() + ") thrown exception");
            exception.printStackTrace();
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    @Override
    public String getVersion() {
        return "$Id: DevStateScalar.java 22752 2013-06-03 11:45:34Z jlpons $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

