/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanImage;
import fr.esrf.tangoatk.core.attribute.BooleanScalar;
import fr.esrf.tangoatk.core.attribute.BooleanSpectrum;
import fr.esrf.tangoatk.core.attribute.DevStateScalar;
import fr.esrf.tangoatk.core.attribute.DevStateSpectrum;
import fr.esrf.tangoatk.core.attribute.DoubleImageHelper;
import fr.esrf.tangoatk.core.attribute.DoubleScalarHelper;
import fr.esrf.tangoatk.core.attribute.DoubleSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.EnumScalar;
import fr.esrf.tangoatk.core.attribute.EnumScalarHelper;
import fr.esrf.tangoatk.core.attribute.FloatImageHelper;
import fr.esrf.tangoatk.core.attribute.FloatScalarHelper;
import fr.esrf.tangoatk.core.attribute.FloatSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.InvalidAttribute;
import fr.esrf.tangoatk.core.attribute.LongImageHelper;
import fr.esrf.tangoatk.core.attribute.LongScalarHelper;
import fr.esrf.tangoatk.core.attribute.LongSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberImage;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import fr.esrf.tangoatk.core.attribute.NumberSpectrum;
import fr.esrf.tangoatk.core.attribute.RawImage;
import fr.esrf.tangoatk.core.attribute.ShortImageHelper;
import fr.esrf.tangoatk.core.attribute.ShortScalarHelper;
import fr.esrf.tangoatk.core.attribute.ShortSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.StringImage;
import fr.esrf.tangoatk.core.attribute.StringScalar;
import fr.esrf.tangoatk.core.attribute.StringSpectrum;
import fr.esrf.tangoatk.core.attribute.UCharImageHelper;
import fr.esrf.tangoatk.core.attribute.UCharScalarHelper;
import fr.esrf.tangoatk.core.attribute.UCharSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.ULongImageHelper;
import fr.esrf.tangoatk.core.attribute.ULongScalarHelper;
import fr.esrf.tangoatk.core.attribute.ULongSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.UShortImageHelper;
import fr.esrf.tangoatk.core.attribute.UShortScalarHelper;
import fr.esrf.tangoatk.core.attribute.UShortSpectrumHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class AttributeFactory
extends AEntityFactory {
    private static AttributeFactory instance;
    protected Vector<AAttribute> attributes = new Vector();
    protected String[] attNames = new String[0];

    protected AttributeFactory() {
    }

    public static AttributeFactory getInstance() {
        if (instance == null) {
            instance = new AttributeFactory();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AAttribute[] getAttributes() {
        AAttribute[] aAttributeArray = new AAttribute[this.attributes.size()];
        AttributeFactory attributeFactory = this;
        synchronized (attributeFactory) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                aAttributeArray[i] = this.attributes.get(i);
            }
        }
        return aAttributeArray;
    }

    @Override
    public int getSize() {
        return this.attributes.size();
    }

    private int getAttributePos(String string) {
        return Arrays.binarySearch(this.attNames, string.toLowerCase());
    }

    @Override
    protected synchronized List<IEntity> getWildCardEntities(String string, Device device) throws DevFailed {
        Vector<IEntity> vector = new Vector<IEntity>();
        AttributeInfoEx[] attributeInfoExArray = device.getAttributeInfo((String[])null);
        for (int i = 0; i < attributeInfoExArray.length; ++i) {
            String string2 = AttributeFactory.getFQName(device, attributeInfoExArray[i].name);
            int n = this.getAttributePos(string2);
            AAttribute aAttribute = n >= 0 ? this.attributes.get(n) : this.initAttribute(device, attributeInfoExArray[i], -(n + 1), string2);
            vector.add(aAttribute);
        }
        return vector;
    }

    Device getConnectionlessDevice(String string) throws ConnectionException {
        return DeviceFactory.getInstance().getConnectionlessDevice(string);
    }

    @Override
    protected synchronized List<IEntity> getConnectionlessSingleAttribute(String string) throws ConnectionException {
        Vector<IEntity> vector = new Vector<IEntity>();
        Device device = this.getConnectionlessDevice(AttributeFactory.extractDeviceName(string));
        vector.add(this.getConnectionlessStateAttribute(string, device));
        return vector;
    }

    protected synchronized IEntity getConnectionlessStateAttribute(String string, Device device) throws ConnectionException {
        int n = this.getAttributePos(string);
        if (n >= 0) {
            return this.attributes.get(n);
        }
        String string2 = AttributeFactory.extractEntityName(string);
        return this.initConnectionlessStateAttribute(device, -(n + 1), string);
    }

    @Override
    protected synchronized IEntity getSingleEntity(String string, Device device) throws DevFailed {
        int n = this.getAttributePos(string);
        if (n >= 0) {
            return this.attributes.get(n);
        }
        String string2 = AttributeFactory.extractEntityName(string);
        AttributeInfoEx attributeInfoEx = device.getAttributeInfo(string2);
        return this.initAttribute(device, attributeInfoEx, -(n + 1), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute getAttribute(String string) throws ConnectionException, DevFailed {
        Device device = null;
        IEntity iEntity = null;
        AAttribute aAttribute = null;
        AttributeFactory attributeFactory = this;
        synchronized (attributeFactory) {
            int n = this.getAttributePos(string);
            if (n >= 0) {
                iEntity = this.attributes.get(n);
            }
        }
        if (iEntity == null) {
            device = this.getDevice(AttributeFactory.extractDeviceName(string));
            iEntity = this.getSingleEntity(string, device);
        }
        if (iEntity == null) {
            return null;
        }
        if (iEntity instanceof AAttribute) {
            aAttribute = (AAttribute)iEntity;
            return aAttribute;
        }
        return null;
    }

    public boolean isAttribute(String string) {
        try {
            return this.getAttribute(string) != null;
        }
        catch (ConnectionException connectionException) {
            System.out.println("AttributeFactory.isAttribute(" + string + ") : " + connectionException.getErrors()[0].desc);
            return false;
        }
        catch (DevFailed devFailed) {
            System.out.println("AttributeFactory.isAttribute(" + string + ") : " + devFailed.errors[0].desc);
            return false;
        }
        catch (Exception exception) {
            System.out.println("AttributeFactory.isAttribute(" + string + ") : Unexpected exception caught...");
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isConnectionLessAttribute(String string) {
        try {
            return this.getConnectionlessSingleAttribute(string) != null;
        }
        catch (ConnectionException connectionException) {
            System.out.println("AttributeFactory.isConnectionLessAttribute(" + string + ") : " + connectionException.getErrors()[0].desc);
            return false;
        }
        catch (Exception exception) {
            System.out.println("AttributeFactory.isConnectionLessAttribute(" + string + ") : Unexpected exception caught...");
            exception.printStackTrace();
            return false;
        }
    }

    protected AAttribute initAttribute(Device device, AttributeInfoEx attributeInfoEx, int n, String string) {
        AAttribute aAttribute = this.getAttributeOfType(device, attributeInfoEx);
        long l = System.currentTimeMillis();
        aAttribute.init(device, attributeInfoEx.name, attributeInfoEx, true);
        DeviceFactory.getInstance().trace(2, "AttributeFactory.init(" + string + ")", l);
        this.buildNames(string, n);
        this.attributes.add(n, aAttribute);
        this.dumpFactory("Adding " + string);
        return aAttribute;
    }

    protected AAttribute initConnectionlessStateAttribute(Device device, int n, String string) throws ConnectionException {
        AAttribute aAttribute = this.getConnectionlessDevStateScalar(device, string);
        long l = System.currentTimeMillis();
        aAttribute.connectionlessInit(device, AttributeFactory.extractEntityName(string), true);
        DeviceFactory.getInstance().trace(2, "AttributeFactory.initConnectionlessStateAttribute(" + string + ")", l);
        this.buildNames(string, n);
        this.attributes.add(n, aAttribute);
        this.dumpFactory("Adding " + string);
        return aAttribute;
    }

    protected void buildNames(String string, int n) {
        int n2 = this.attNames.length;
        String[] stringArray = new String[n2 + 1];
        System.arraycopy(this.attNames, 0, stringArray, 0, n);
        System.arraycopy(this.attNames, n, stringArray, n + 1, n2 - n);
        stringArray[n] = string.toLowerCase();
        this.attNames = stringArray;
    }

    protected AAttribute getAttributeOfType(Device device, AttributeInfoEx attributeInfoEx) {
        if (attributeInfoEx == null) {
            System.out.println("Warning, AttributeFactory.getAttributeOfType(): Warning, null AttributeInfo pointer got from " + device.getName());
            return new InvalidAttribute();
        }
        AttrDataFormat attrDataFormat = attributeInfoEx.data_format;
        String string = attributeInfoEx.name;
        switch (attrDataFormat.value()) {
            case 0: {
                return this.getScalar(device, attributeInfoEx);
            }
            case 1: {
                return this.getSpectrum(device, attributeInfoEx);
            }
            case 2: {
                return this.getImage(device, attributeInfoEx);
            }
        }
        System.out.println("Warning, AttributeFactory.getAttributeOfType(" + device.getName() + "/" + string + ") : Unsupported attribute format [" + attrDataFormat.value() + "]");
        return new InvalidAttribute();
    }

    protected AAttribute getConnectionlessDevStateScalar(Device device, String string) throws ConnectionException {
        String string2 = AttributeFactory.extractEntityName(string);
        if (!string2.equalsIgnoreCase("state")) {
            throw new ConnectionException("Only state attribute can be created without connection to the device.");
        }
        DevStateScalar devStateScalar = new DevStateScalar();
        return devStateScalar;
    }

    private EnumScalar getEnumScalar(Device device, AttributeInfoEx attributeInfoEx) {
        String string = attributeInfoEx.name;
        DbAttribute dbAttribute = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        EnumScalar enumScalar = null;
        try {
            dbAttribute = device.get_attribute_property(string);
            if (dbAttribute != null && !dbAttribute.is_empty("EnumLabels") && (stringArray = dbAttribute.get_value("EnumLabels")) != null) {
                stringArray2 = EnumScalar.getNonEmptyLabels(stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println("get_attribute_property(" + string + ") thrown exception");
            exception.printStackTrace();
        }
        if (stringArray2 == null) {
            return null;
        }
        if (stringArray2.length <= 1) {
            return null;
        }
        try {
            dbAttribute = device.get_attribute_property(string);
            if (dbAttribute != null && !dbAttribute.is_empty("EnumSetExclusion") && (stringArray = dbAttribute.get_value("EnumSetExclusion")) != null) {
                stringArray3 = EnumScalar.getNonEmptyLabels(stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println("get_attribute_property(" + string + ") thrown exception");
            exception.printStackTrace();
        }
        if (stringArray3 != null && stringArray3.length < 1) {
            stringArray3 = null;
        }
        enumScalar = new EnumScalar(stringArray2, stringArray3);
        return enumScalar;
    }

    private AAttribute getScalar(Device device, AttributeInfoEx attributeInfoEx) {
        String string = attributeInfoEx.name;
        int n = attributeInfoEx.data_type;
        BooleanScalar booleanScalar = null;
        DevStateScalar devStateScalar = null;
        EnumScalar enumScalar = null;
        RawImage rawImage = null;
        if (n == 8) {
            return new StringScalar();
        }
        NumberScalar numberScalar = new NumberScalar();
        switch (n) {
            case 22: {
                numberScalar.setNumberHelper(new UCharScalarHelper(numberScalar));
                return numberScalar;
            }
            case 2: {
                enumScalar = this.getEnumScalar(device, attributeInfoEx);
                if (enumScalar != null) {
                    enumScalar.setEnumHelper(new EnumScalarHelper(enumScalar));
                    return enumScalar;
                }
                numberScalar.setNumberHelper(new ShortScalarHelper(numberScalar));
                break;
            }
            case 6: {
                numberScalar.setNumberHelper(new UShortScalarHelper(numberScalar));
                break;
            }
            case 5: {
                numberScalar.setNumberHelper(new DoubleScalarHelper(numberScalar));
                break;
            }
            case 4: {
                numberScalar.setNumberHelper(new FloatScalarHelper(numberScalar));
                break;
            }
            case 3: {
                numberScalar.setNumberHelper(new LongScalarHelper(numberScalar));
                break;
            }
            case 7: {
                numberScalar.setNumberHelper(new ULongScalarHelper(numberScalar));
                break;
            }
            case 1: {
                booleanScalar = new BooleanScalar();
                return booleanScalar;
            }
            case 19: {
                devStateScalar = new DevStateScalar();
                return devStateScalar;
            }
            case 28: {
                if (attributeInfoEx.format.equalsIgnoreCase("RawImage")) {
                    rawImage = new RawImage();
                    return rawImage;
                }
                System.out.println("Warning, AttributeFactory.getScalar(" + device.getName() + "/" + string + ") : Unsupported DevEncoded attribute. Try to set the format attribute property to 'RawImage'.");
                return new InvalidAttribute();
            }
            default: {
                System.out.println("Warning, AttributeFactory.getScalar(" + device.getName() + "/" + string + ") : Unsupported data type [" + n + "]");
                return new InvalidAttribute();
            }
        }
        return numberScalar;
    }

    private AAttribute getSpectrum(Device device, AttributeInfoEx attributeInfoEx) {
        String string = attributeInfoEx.name;
        int n = attributeInfoEx.data_type;
        NumberSpectrum numberSpectrum = new NumberSpectrum();
        StringSpectrum stringSpectrum = null;
        BooleanSpectrum booleanSpectrum = null;
        DevStateSpectrum devStateSpectrum = null;
        switch (n) {
            case 22: {
                numberSpectrum.setNumberHelper(new UCharSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 2: {
                numberSpectrum.setNumberHelper(new ShortSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 6: {
                numberSpectrum.setNumberHelper(new UShortSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 5: {
                numberSpectrum.setNumberHelper(new DoubleSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 4: {
                numberSpectrum.setNumberHelper(new FloatSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 3: {
                numberSpectrum.setNumberHelper(new LongSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 7: {
                numberSpectrum.setNumberHelper(new ULongSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 8: {
                stringSpectrum = new StringSpectrum();
                return stringSpectrum;
            }
            case 1: {
                booleanSpectrum = new BooleanSpectrum();
                return booleanSpectrum;
            }
            case 19: {
                devStateSpectrum = new DevStateSpectrum();
                return devStateSpectrum;
            }
        }
        System.out.println("Warning, AttributeFactory.getSpectrum(" + device.getName() + "/" + string + ") : Unsupported data type [" + n + "]");
        return new InvalidAttribute();
    }

    private AAttribute getImage(Device device, AttributeInfoEx attributeInfoEx) {
        String string = attributeInfoEx.name;
        int n = attributeInfoEx.data_type;
        NumberImage numberImage = new NumberImage();
        BooleanImage booleanImage = null;
        StringImage stringImage = null;
        switch (n) {
            case 22: {
                numberImage.setNumberHelper(new UCharImageHelper(numberImage));
                return numberImage;
            }
            case 2: {
                numberImage.setNumberHelper(new ShortImageHelper(numberImage));
                return numberImage;
            }
            case 6: {
                numberImage.setNumberHelper(new UShortImageHelper(numberImage));
                return numberImage;
            }
            case 5: {
                numberImage.setNumberHelper(new DoubleImageHelper(numberImage));
                return numberImage;
            }
            case 4: {
                numberImage.setNumberHelper(new FloatImageHelper(numberImage));
                return numberImage;
            }
            case 3: {
                numberImage.setNumberHelper(new LongImageHelper(numberImage));
                return numberImage;
            }
            case 7: {
                numberImage.setNumberHelper(new ULongImageHelper(numberImage));
                return numberImage;
            }
            case 1: {
                booleanImage = new BooleanImage();
                return booleanImage;
            }
            case 8: {
                stringImage = new StringImage();
                return stringImage;
            }
        }
        System.out.println("Warning, AttributeFactory.getSpectrum(" + device.getName() + "/" + string + ") : Unsupported data type [" + n + "]");
        return new InvalidAttribute();
    }

    private void dumpFactory(String string) {
        if ((DeviceFactory.getInstance().getTraceMode() & 0x200) != 0) {
            System.out.println("-- AttributeFactory : " + string + " --");
            for (int i = 0; i < this.attNames.length; ++i) {
                System.out.println("  " + i + ":" + this.attNames[i]);
            }
            System.out.println("-- AttributeFactory --------------------------------------");
        }
    }

    @Override
    public String getVersion() {
        return "$Id: AttributeFactory.java 15105 2010-09-24 13:11:54Z poncet $";
    }
}

