/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityCollection;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IEntityList;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IListStateListener;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.Refresher;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;

public abstract class AEntityList
extends DefaultListModel
implements IEntityCollection,
ComboBoxModel,
IEntityList {
    public static final int REFRESHER_STARTED = 1;
    public static final int REFRESHER_STOPPED = 2;
    protected int refreshInterval = 1000;
    protected AEntityFactory factory;
    protected Refresher refresher = null;
    protected List<IErrorListener> errorListeners = new Vector<IErrorListener>();
    protected List<IRefresherListener> refresherListeners = new Vector<IRefresherListener>();
    protected List<IListStateListener> listStateListeners = new Vector<IListStateListener>();
    protected List<ISetErrorListener> setErrorListeners = new Vector<ISetErrorListener>();
    protected IEntity selectedItem;
    boolean refresherStarted = false;
    protected IEntityFilter filter = new IEntityFilter(){

        @Override
        public boolean keep(IEntity iEntity) {
            return true;
        }
    };
    protected boolean synchronizedPeriod = false;
    protected boolean traceUnexpected = false;
    private static String VERSION = "$Id: AEntityList.java 18545 2011-12-02 08:23:53Z jlpons $";

    @Override
    public void setRefreshInterval(int n) {
        this.refreshInterval = n;
        if (this.refresher != null) {
            this.refresher.setRefreshInterval(this.refreshInterval);
        }
    }

    @Override
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selectedItem = (IEntity)object;
    }

    @Override
    public void refresh() {
        IEntity iEntity = null;
        long l = System.currentTimeMillis();
        this.trace(4, "AEntityList.refresh()  ", l);
        for (int i = 0; i < this.size(); ++i) {
            IAttribute iAttribute;
            iEntity = (IEntity)this.get(i);
            if (!iEntity.getDevice().doesEvent()) {
                this.trace(4, "AEntityList.refresh() : device is not event compatible; will call refresh for " + iEntity.getName(), l);
                iEntity.refresh();
                continue;
            }
            if (!(iEntity instanceof IAttribute) || (iAttribute = (IAttribute)iEntity).hasEvents()) continue;
            this.trace(4, "AEntityList.refresh() : attribute has not subscribed event; will call refresh for " + iEntity.getName(), l);
            iEntity.refresh();
        }
    }

    @Override
    public boolean isRefresherStarted() {
        return this.refresherStarted;
    }

    @Override
    public void stopRefresher() {
        if (this.refresher != null) {
            this.refresher.stop = true;
            this.refresher.refreshee = null;
        }
        this.refresher = null;
        this.refresherStarted = false;
        this.fireListStateChangeEvent();
    }

    @Override
    public void startRefresher() {
        if (this.isRefresherStarted()) {
            return;
        }
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
            this.refresher.setSynchronizedPeriod(this.synchronizedPeriod);
            this.refresher.setTraceUnexpected(this.traceUnexpected);
        }
        this.refresher.addRefreshee(this).start();
        this.refresherStarted = true;
        this.fireListStateChangeEvent();
    }

    @Override
    public void setRefresher(Refresher refresher) {
        if (refresher != null) {
            this.synchronizedPeriod = refresher.isSynchronizedPeriod();
            this.traceUnexpected = refresher.isTraceUnexpected();
        }
        this.refresher = refresher;
    }

    @Override
    public void setFilter(IEntityFilter iEntityFilter) {
        this.filter = iEntityFilter;
    }

    @Override
    public IEntityFilter getFilter() {
        return this.filter;
    }

    @Override
    public List<IEntity> get(String[] stringArray) {
        Vector<IEntity> vector = new Vector<IEntity>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(this.get(stringArray[i]));
        }
        return vector;
    }

    @Override
    public IEntity get(String string) {
        for (int i = 0; i < this.size(); ++i) {
            IEntity iEntity = (IEntity)this.get(i);
            if (!iEntity.getName().equalsIgnoreCase(string)) continue;
            return iEntity;
        }
        return null;
    }

    @Override
    public void add(String[] stringArray) throws ConnectionException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.add(stringArray[i]);
        }
    }

    @Override
    public void add(IEntity iEntity) {
        int n;
        if (this.contains(iEntity)) {
            return;
        }
        if (!this.filter.keep(iEntity)) {
            return;
        }
        if (this.errorListeners != null) {
            for (n = 0; n < this.errorListeners.size(); ++n) {
                iEntity.addErrorListener(this.errorListeners.get(n));
            }
        }
        if (iEntity instanceof IAttribute && this.setErrorListeners != null) {
            for (n = 0; n < this.setErrorListeners.size(); ++n) {
                ((IAttribute)iEntity).addSetErrorListener(this.setErrorListeners.get(n));
            }
        }
        this.addElement(iEntity);
    }

    @Override
    public IEntity add(String string) throws ConnectionException {
        IEntity iEntity2 = this.get(string);
        if (iEntity2 == null) {
            List<IEntity> list = null;
            try {
                list = this.factory.getEntities(string);
            }
            catch (ConnectionException connectionException) {
                if (AEntityFactory.isWildCard(string)) {
                    string = string.substring(0, string.length() - 2);
                }
                this.fireErrorEvent(connectionException, string);
                throw connectionException;
            }
            for (IEntity iEntity2 : list) {
                int n;
                if (iEntity2 == null || this.contains(iEntity2) || !this.filter.keep(iEntity2)) continue;
                if (this.errorListeners != null) {
                    for (n = 0; n < this.errorListeners.size(); ++n) {
                        iEntity2.addErrorListener(this.errorListeners.get(n));
                    }
                }
                if (iEntity2 instanceof IAttribute && this.setErrorListeners != null) {
                    for (n = 0; n < this.setErrorListeners.size(); ++n) {
                        ((IAttribute)iEntity2).addSetErrorListener(this.setErrorListeners.get(n));
                    }
                }
                this.addElement(iEntity2);
            }
        }
        return iEntity2;
    }

    @Override
    public boolean remove(String string) {
        IEntity iEntity = this.get(string);
        int n = this.indexOf(iEntity);
        return n >= 0 && this.remove(n) != null;
    }

    @Override
    public void addErrorListener(IErrorListener iErrorListener) {
        this.errorListeners.add(iErrorListener);
    }

    @Override
    public void addSetErrorListener(ISetErrorListener iSetErrorListener) {
        this.setErrorListeners.add(iSetErrorListener);
    }

    @Override
    public void removeErrorListener(IErrorListener iErrorListener) {
        IEntity iEntity = null;
        if (iErrorListener == null) {
            return;
        }
        if (this.errorListeners.contains(iErrorListener)) {
            for (int i = 0; i < this.size(); ++i) {
                iEntity = (IEntity)this.get(i);
                iEntity.removeErrorListener(iErrorListener);
            }
            try {
                this.errorListeners.remove(iErrorListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeSetErrorListener(ISetErrorListener iSetErrorListener) {
        IEntity iEntity = null;
        IAttribute iAttribute = null;
        if (iSetErrorListener == null) {
            return;
        }
        if (this.setErrorListeners.contains(iSetErrorListener)) {
            for (int i = 0; i < this.size(); ++i) {
                iEntity = (IEntity)this.get(i);
                if (!(iEntity instanceof IAttribute)) continue;
                iAttribute = (IAttribute)iEntity;
                iAttribute.removeSetErrorListener(iSetErrorListener);
            }
            try {
                this.setErrorListeners.remove(iSetErrorListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addRefresherListener(IRefresherListener iRefresherListener) {
        if (!this.refresherListeners.contains(iRefresherListener)) {
            this.refresherListeners.add(iRefresherListener);
        }
    }

    @Override
    public void removeRefresherListener(IRefresherListener iRefresherListener) {
        if (this.refresherListeners != null) {
            this.refresherListeners.remove(iRefresherListener);
        }
    }

    public void clearRefresherListener() {
        this.refresherListeners.clear();
    }

    protected void fireRefresherStepEvent() {
        int n = this.refresherListeners.size();
        for (int i = 0; i < n; ++i) {
            IRefresherListener iRefresherListener = this.refresherListeners.get(i);
            try {
                iRefresherListener.refreshStep();
                continue;
            }
            catch (Exception exception) {
                System.out.println("AEntityList.fireRefresherStepEvent() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("AEntityList.fireRefresherStepEvent()------------------------------------------------");
            }
        }
    }

    @Override
    public void addListStateListener(IListStateListener iListStateListener) {
        if (!this.listStateListeners.contains(iListStateListener)) {
            this.listStateListeners.add(iListStateListener);
        }
    }

    @Override
    public void removeListStateListener(IListStateListener iListStateListener) {
        if (this.listStateListeners != null) {
            this.listStateListeners.remove(iListStateListener);
        }
    }

    @Override
    public void clearListStateListener() {
        this.listStateListeners.clear();
    }

    protected void fireListStateChangeEvent() {
        int n = this.listStateListeners.size();
        for (int i = 0; i < n; ++i) {
            IListStateListener iListStateListener = this.listStateListeners.get(i);
            try {
                if (this.refresherStarted) {
                    iListStateListener.stateChange(1);
                    continue;
                }
                iListStateListener.stateChange(2);
                continue;
            }
            catch (Exception exception) {
                System.out.println("AEntityList.fireListStateChangeEvent() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("AEntityList.fireListStateChangeEvent()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    private void fireErrorEvent(ConnectionException connectionException, String string) {
        if (this.errorListeners != null) {
            for (int i = 0; i < this.errorListeners.size(); ++i) {
                this.errorListeners.get(i).errorChange(new ErrorEvent(string, connectionException, System.currentTimeMillis()));
            }
        }
    }

    public void finalize() {
        this.stopRefresher();
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void setSynchronizedPeriod(boolean bl) {
        this.synchronizedPeriod = bl;
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
        }
        this.refresher.setSynchronizedPeriod(this.synchronizedPeriod);
        this.refresher.setTraceUnexpected(this.traceUnexpected);
    }

    @Override
    public void setTraceUnexpected(boolean bl) {
        this.traceUnexpected = bl;
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
        }
        this.refresher.setSynchronizedPeriod(this.synchronizedPeriod);
        this.refresher.setTraceUnexpected(this.traceUnexpected);
    }
}

