/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskEventNode
extends TangoNode {
    private Database db;
    private String devName;
    private Vector attEventInfo;

    TaskEventNode(Database database, String string) {
        this.db = database;
        this.devName = string;
        this.attEventInfo = null;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.eventicon;
    }

    @Override
    public String toString() {
        return "Event";
    }

    @Override
    String getTitle() {
        return "Event";
    }

    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    int getAttributeNumber() {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return this.attEventInfo.size();
    }

    String getAttName(int n) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)n)).name;
    }

    String getAbsChange(int n) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)n)).abs_change;
    }

    String getRelChange(int n) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)n)).rel_change;
    }

    String getPeriodic(int n) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)n)).periodic;
    }

    String getArchAbsChange(int n) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)n)).archive_abs_change;
    }

    String getArchRelChange(int n) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)n)).archive_rel_change;
    }

    String getArchPeriod(int n) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)n)).archive_period;
    }

    void setAbsChange(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
                attributeInfoEx.events.ch_event.abs_change = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setRelChange(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
                attributeInfoEx.events.ch_event.rel_change = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setArchAbsChange(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
                attributeInfoEx.events.arch_event.abs_change = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setArchRelChange(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
                attributeInfoEx.events.arch_event.rel_change = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setArchPeriod(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
                attributeInfoEx.events.arch_event.period = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setPeriodic(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
                attributeInfoEx.events.per_event.period = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetChangeEvent(int n) {
        try {
            String[] stringArray = new String[]{"rel_change", "abs_change"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(n), stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLChangeEvent(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.events.ch_event.rel_change = "Not specified";
            attributeInfoEx.events.ch_event.abs_change = "Not specified";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULChangeEvent(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.events.ch_event.rel_change = "";
            attributeInfoEx.events.ch_event.abs_change = "";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULChangeEvent(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.events.ch_event.rel_change = "NaN";
            attributeInfoEx.events.ch_event.abs_change = "NaN";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetArchEvent(int n) {
        try {
            String[] stringArray = new String[]{"archive_rel_change", "archive_abs_change", "archive_period"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(n), stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLArchEvent(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.events.arch_event.abs_change = "Not specified";
            attributeInfoEx.events.arch_event.rel_change = "Not specified";
            attributeInfoEx.events.arch_event.period = "Not specified";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULArchEvent(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.events.arch_event.abs_change = "";
            attributeInfoEx.events.arch_event.rel_change = "";
            attributeInfoEx.events.arch_event.period = "";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULArchEvent(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.events.arch_event.abs_change = "NaN";
            attributeInfoEx.events.arch_event.rel_change = "NaN";
            attributeInfoEx.events.arch_event.period = "NaN";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetPeriodicEvent(int n) {
        try {
            String[] stringArray = new String[]{"event_period"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(n), stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLPeriodicEvent(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.events.per_event.period = "Not specified";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULPeriodicEvent(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.events.per_event.period = "";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULPeriodicEvent(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.events.per_event.period = "NaN";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public void restartDevice() {
        try {
            DbDevImportInfo dbDevImportInfo = this.db.import_device(this.devName);
            DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
            DeviceData deviceData = new DeviceData();
            deviceData.insert(this.devName);
            deviceProxy.command_inout("DevRestart", deviceData);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public boolean isTango8() {
        try {
            DbDevImportInfo dbDevImportInfo = this.db.import_device(this.devName);
            DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
            CommandInfo[] commandInfoArray = deviceProxy.command_list_query();
            boolean bl = false;
            int n = 0;
            while (!bl && n < commandInfoArray.length) {
                bl = commandInfoArray[n].cmd_name.equalsIgnoreCase("ZmqEventSubscriptionChange");
                if (bl) continue;
                ++n;
            }
            return bl;
        }
        catch (DevFailed devFailed) {
            return false;
        }
    }

    void browseEventInfo() {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.attEventInfo = new Vector();
            if (deviceProxy.get_idl_version() >= 3) {
                String[] stringArray = deviceProxy.get_attribute_list();
                JiveUtils.sortList(stringArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(stringArray[i]);
                    if (attributeInfoEx.events == null) continue;
                    EventInfo eventInfo = new EventInfo();
                    eventInfo.name = stringArray[i];
                    eventInfo.abs_change = this.reformat(attributeInfoEx.events.ch_event.abs_change);
                    eventInfo.rel_change = this.reformat(attributeInfoEx.events.ch_event.rel_change);
                    eventInfo.periodic = this.reformat(attributeInfoEx.events.per_event.period);
                    eventInfo.archive_abs_change = this.reformat(attributeInfoEx.events.arch_event.abs_change);
                    eventInfo.archive_rel_change = this.reformat(attributeInfoEx.events.arch_event.rel_change);
                    eventInfo.archive_period = this.reformat(attributeInfoEx.events.arch_event.period);
                    this.attEventInfo.add(eventInfo);
                }
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    private String reformat(String string) {
        if (string.equalsIgnoreCase("Not specified")) {
            return "None";
        }
        return string;
    }

    class EventInfo {
        String name;
        String abs_change;
        String rel_change;
        String periodic;
        String archive_abs_change;
        String archive_rel_change;
        String archive_period;

        EventInfo() {
        }
    }
}

