/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class UIBit {
    protected JMenuItem item;
    protected JButton button;
    protected ImageIcon icon;
    protected String tip;

    public UIBit(String name, String tip, ActionListener listener, Icon icon) {
        this.item = new JMenuItem(name);
        this.button = new JButton();
        this.button.setMargin(new Insets(5, 5, 5, 5));
        if (icon != null) {
            this.item.setIcon(icon);
            this.button.setIcon(icon);
        }
        this.button.setToolTipText(tip);
        this.item.addActionListener(listener);
        this.button.addActionListener(listener);
    }

    public UIBit(String name, ActionListener listener, Icon icon) {
        this(name, name, listener, icon);
    }

    public UIBit(String name, ActionListener listener) {
        this(name, name, listener, null);
    }

    public void setAccelerator(char key) {
        this.item.setAccelerator(KeyStroke.getKeyStroke((int)key, 2));
    }

    public void setAccelerator(String key) {
        this.item.setAccelerator(KeyStroke.getKeyStroke(key));
    }

    public JMenuItem getItem() {
        return this.item;
    }

    public JButton getButton() {
        return this.button;
    }

    public boolean isEnabled() {
        return this.item.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.item.setEnabled(b);
        this.button.setEnabled(b);
    }

    public boolean isVisible() {
        return this.item.isVisible();
    }

    public void setVisible(boolean b) {
        this.item.setVisible(b);
        this.button.setVisible(b);
    }
}

