/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.logviewer.ControlPanel;
import fr.esrf.logviewer.DetailPanel;
import fr.esrf.logviewer.DeviceNode;
import fr.esrf.logviewer.ExitAction;
import fr.esrf.logviewer.HistoryArea;
import fr.esrf.logviewer.LoadXMLAction;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.logviewer.RootNode;
import fr.esrf.logviewer.TangoLoggingReceiver;
import fr.esrf.logviewer.TangoNode;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main
extends JFrame {
    private static final String APP_RELEASE = "1.2.3";
    private static final Logger LOG = Logger.getLogger(Main.class);
    private static TangoLoggingReceiver mTlr = null;
    private JTree devTree;
    private DefaultTreeModel treeModel;
    private JScrollPane treeView;
    private TangoNode root;
    private JPopupMenu mMemberPopup;
    private ButtonGroup mMemberLevelGroup1;
    private ButtonGroup mMemberLevelGroup2;
    private JMenuItem mMemberNameItem;
    private CustomLabel mLabel;
    private HistoryArea mHistoryArea;
    private boolean mPopupTrigger = false;
    private Database db;
    static JFrame self = null;
    static boolean inited = false;
    private boolean closeOnExit = false;

    public Main(JFrame jFrame) {
        this(new String[0], true);
    }

    public Main(String[] stringArray, boolean bl) {
        super("Tango LogViewer (exported as ...)");
        JMenuItem jMenuItem;
        Serializable serializable;
        Main.initLog4J();
        this.closeOnExit = bl;
        self = this;
        String string = null;
        try {
            string = ApiUtil.getTangoHost();
        }
        catch (DevFailed devFailed) {
            System.out.println("TANGO_HOST no defined, exiting...");
            this.exitForm();
        }
        try {
            this.db = ApiUtil.get_db_obj();
        }
        catch (DevFailed devFailed) {
            Main.showTangoError(devFailed);
            this.db = null;
            this.exitForm();
        }
        Splash splash = new Splash();
        splash.setTitle("TANGO LogViewer");
        splash.setCopyright("(c) TANGO Team 2002-2010 / (c) Apache Project 2002");
        splash.setMaxProgress(10);
        splash.setMessage("Setting up UI...");
        int n = 1;
        splash.progress(n++);
        Font font = new Font("terminal", 0, 12);
        UIManager.put("Label.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("Button.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableColumn.font", font);
        UIManager.put("TextArea.font", font);
        MyTableModel myTableModel = new MyTableModel();
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        try {
            serializable = new LoadXMLAction(this, myTableModel);
            jMenuItem = new JMenuItem("Load file...");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener((ActionListener)((Object)serializable));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LOG.info((Object)"Missing classes for XML parser", (Throwable)noClassDefFoundError);
            JOptionPane.showMessageDialog(this, "XML parser not in classpath - unable to load XML events.", "Tango LogViewer", 0);
        }
        catch (Exception exception) {
            LOG.info((Object)"Unable to create the action to load XML files", (Throwable)exception);
            JOptionPane.showMessageDialog(this, "Unable to create a XML parser - unable to load XML events.", "Tango LogViewer", 0);
        }
        serializable = new JMenuItem("Exit");
        jMenu.add((JMenuItem)serializable);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.exitBtnActionPerformed(actionEvent);
            }
        });
        jMenuItem = new JMenu("Actions");
        jMenuBar.add((JMenu)jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Refresh Device Tree");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.mLabel.setText("Refreshing the device tree... ");
                Main.this.refreshTree();
                Main.this.mLabel.setText(" ");
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem2);
        ((JMenu)jMenuItem).add(new JSeparator());
        jMenuItem2 = new JMenuItem("Logging Source List");
        jMenuItem2.addActionListener(new SourceListActionListener());
        ((JMenu)jMenuItem).add(jMenuItem2);
        ((JMenu)jMenuItem).add(new JSeparator());
        jMenuItem2 = new JMenuItem("Remove All Logging Source");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.mLabel.setText("Removing all logging source... ");
                if (mTlr.removeAllSources() != -1) {
                    Main.this.mHistoryArea.write("Removed all sources");
                }
                Main.this.mLabel.setText(" ");
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem2);
        ((JMenu)jMenuItem).add(new JSeparator());
        jMenuItem2 = new JMenuItem("Clear history");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.mHistoryArea.clear();
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem2);
        splash.progress(n++);
        ControlPanel controlPanel = new ControlPanel(myTableModel, this, bl);
        this.getContentPane().add((Component)controlPanel, "North");
        splash.progress(n++);
        JTable jTable = new JTable(myTableModel);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(true);
        jTable.setDragEnabled(true);
        jTable.setSelectionMode(0);
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        LogTableRowRenderer logTableRowRenderer = new LogTableRowRenderer();
        int n2 = 0;
        int[] nArray = new int[]{60, 140, 75, 155, 500};
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setCellRenderer(logTableRowRenderer);
            tableColumn.setPreferredWidth(nArray[n2++]);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Logs"));
        jScrollPane.setMinimumSize(new Dimension(150, 150));
        jScrollPane.setPreferredSize(new Dimension(790, 450));
        splash.progress(n++);
        DetailPanel detailPanel = new DetailPanel(jTable, myTableModel);
        detailPanel.setMinimumSize(new Dimension(0, 0));
        detailPanel.setPreferredSize(new Dimension(790, 0));
        splash.progress(n++);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, detailPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(9);
        this.treeView = new JScrollPane();
        this.treeView.setPreferredSize(new Dimension(170, 0));
        this.initTree();
        splash.progress(n++);
        this.mMemberPopup = new JPopupMenu();
        this.mMemberNameItem = new JMenuItem("dev/name/goes.here");
        this.mMemberNameItem.setEnabled(false);
        this.mMemberPopup.add(this.mMemberNameItem);
        this.mMemberPopup.add(new JSeparator());
        jMenuItem2 = new JMenuItem("Add");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.addLoggingSource();
            }
        });
        this.mMemberPopup.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Add Colocated");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.addColocatedSources();
            }
        });
        this.mMemberPopup.add(jMenuItem2);
        this.mMemberLevelGroup1 = new ButtonGroup();
        this.mMemberPopup.add(new LoggingLevelMenu("Add/Set Logging Level", this.mMemberLevelGroup1, true));
        this.mMemberPopup.add(new JSeparator());
        jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.removeLoggingSource();
            }
        });
        this.mMemberPopup.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Remove Colocated");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.removeColocatedSources();
            }
        });
        this.mMemberPopup.add(jMenuItem2);
        this.mMemberPopup.add(jMenuItem2);
        this.mMemberPopup.add(new JSeparator());
        this.mMemberLevelGroup2 = new ButtonGroup();
        this.mMemberPopup.add(new LoggingLevelMenu("Set Logging Level", this.mMemberLevelGroup2, false));
        this.mMemberPopup.add(new BasicLoggingLevelMenu("Set Logging Level (colocated)"));
        JSplitPane jSplitPane2 = new JSplitPane(1, this.treeView, jSplitPane);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setDividerSize(9);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Main.this.windowClosingPerformed(windowEvent);
            }
        });
        splash.progress(n++);
        jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createTitledBorder("History"));
        this.mHistoryArea = new HistoryArea(jScrollPane);
        this.mHistoryArea.setMinimumSize(new Dimension(0, 0));
        Date date = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        this.mHistoryArea.write("Welcome to the TANGO LogViewer (started on " + dateFormat.format(date) + ")");
        jScrollPane.setViewportView(this.mHistoryArea);
        JSplitPane jSplitPane3 = new JSplitPane(0, jSplitPane2, jScrollPane);
        jSplitPane3.setOneTouchExpandable(true);
        jSplitPane3.setDividerSize(9);
        this.getContentPane().add((Component)jSplitPane3, "Center");
        splash.progress(n++);
        this.mLabel = new CustomLabel();
        this.mLabel.setBorder(new SoftBevelBorder(1));
        this.getContentPane().add((Component)this.mLabel, "South");
        splash.setMessage("Starting up the LogConsumer device...");
        this.setupReceiver(stringArray, myTableModel);
        splash.progress(n++);
        if (mTlr.isRunningInStaticMode()) {
            ((JMenu)jMenuItem).add(new JSeparator());
            jMenu = new JMenu("Logging Sources Property");
            jMenuItem2 = new JMenuItem("Save");
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Main.this.mLabel.setText("Saving logging source list into the TANGO database...");
                    mTlr.setLoggingSourceProperty();
                    Main.this.mLabel.setText(" ");
                }
            });
            jMenu.add(jMenuItem2);
            jMenuItem2 = new JMenuItem("Delete");
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Main.this.mLabel.setText("Deleting logging source list from the TANGO database...");
                    mTlr.deleteLoggingSourceProperty();
                    Main.this.mLabel.setText(" ");
                }
            });
            jMenu.add(jMenuItem2);
            jMenuItem2 = new JMenuItem("Restore");
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Main.this.mLabel.setText("Restoring logging sources from the TANGO database...");
                    mTlr.removeAllSources();
                    mTlr.getLoggingSourceProperty();
                    Main.this.mLabel.setText(" ");
                }
            });
            jMenu.add(jMenuItem2);
            ((JMenu)jMenuItem).add(jMenu);
        }
        String string2 = mTlr.getDeviceName();
        this.setTitle("Tango Log Viewer 1.2.3 [" + string2 + "]");
        this.pack();
        this.setLocationRelativeTo((Component)splash);
        splash.setVisible(false);
        this.setVisible(true);
        splash.toFront();
        splash.setVisible(true);
        this.mLabel.setText(" ");
        splash.progress(n++);
        splash.setVisible(false);
        splash.dispose();
        this.devTree.setVisible(true);
        if (!inited) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Main.cleanup();
                }
            });
            inited = true;
        }
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.exitForm();
    }

    private void windowClosingPerformed(WindowEvent windowEvent) {
        this.exitForm();
    }

    public void exitForm() {
        if (this.closeOnExit) {
            this.setVisible(false);
            if (mTlr != null) {
                mTlr.removeAllSources();
            }
        } else {
            ExitAction.INSTANCE.actionPerformed(null);
        }
    }

    private void setupReceiver(String[] stringArray, MyTableModel myTableModel) {
        try {
            if (mTlr == null) {
                mTlr = new TangoLoggingReceiver(stringArray, myTableModel, this.mHistoryArea);
                mTlr.start();
            } else {
                mTlr.setTableModel(myTableModel);
                mTlr.setHistoryArea(this.mHistoryArea);
            }
        }
        catch (Exception exception) {
            LOG.fatal((Object)"Unable to instanciate the TANGO log consumer device. Quiting", (Throwable)exception);
            JOptionPane.showMessageDialog(this, "Unable to instanciate the TANGO log consumer device. Quiting", "Tango Log Viewer", 0);
            this.exitForm();
        }
    }

    private void addLoggingSource() {
        Object object = this.devTree.getLastSelectedPathComponent();
        if (object == null) {
            return;
        }
        if (object instanceof DeviceNode) {
            String string = ((DeviceNode)object).devName;
            this.mLabel.setText("Contacting " + string + "...");
            if (mTlr.addLoggingSource(string) != -1) {
                this.mHistoryArea.write("Added " + string);
            }
        }
        this.mLabel.reset();
    }

    private void addColocatedSources() {
        Object object = this.devTree.getLastSelectedPathComponent();
        if (object == null) {
            return;
        }
        if (object instanceof DeviceNode) {
            String string = ((DeviceNode)object).devName;
            this.mLabel.setText("Adding  " + string + " and colocated devices...");
            if (mTlr.addColocatedSources(string) != -1) {
                this.mHistoryArea.write("Added  " + string + " and colocated devices");
            }
        }
        this.mLabel.reset();
    }

    private void removeLoggingSource() {
        Object object = this.devTree.getLastSelectedPathComponent();
        if (object == null) {
            return;
        }
        if (object instanceof DeviceNode) {
            String string = ((DeviceNode)object).devName;
            this.mLabel.setText("Contacting " + string + "...");
            if (mTlr.removeLoggingSource(string) != -1) {
                this.mHistoryArea.write("Removed " + string);
            }
        }
        this.mLabel.reset();
    }

    private void removeColocatedSources() {
        Object object = this.devTree.getLastSelectedPathComponent();
        if (object == null) {
            return;
        }
        if (object instanceof DeviceNode) {
            String string = ((DeviceNode)object).devName;
            this.mLabel.setText("Removing  " + string + " and colocated devices...");
            if (mTlr.removeColocatedSources(string) != -1) {
                this.mHistoryArea.write("Removed  " + string + " and colocated devices");
            }
        }
        this.mLabel.reset();
    }

    public void deviceTreeMousePressed(MouseEvent mouseEvent) {
        int n = this.devTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1) {
            this.mPopupTrigger = mouseEvent.isPopupTrigger();
            this.devTree.setSelectionRow(n);
            Object object = this.devTree.getLastSelectedPathComponent();
            if (object == null) {
                return;
            }
            if (object instanceof DeviceNode) {
                LoggingLevelMenuItem loggingLevelMenuItem;
                this.mLabel.setText("Contacting " + ((DeviceNode)object).devName);
                int n2 = mTlr.getDeviceLoggingLevel(((DeviceNode)object).devName);
                this.mLabel.reset();
                if (n2 == -1) {
                    return;
                }
                Enumeration<AbstractButton> enumeration = this.mMemberLevelGroup1.getElements();
                while (enumeration.hasMoreElements()) {
                    loggingLevelMenuItem = (LoggingLevelMenuItem)enumeration.nextElement();
                    if (loggingLevelMenuItem.getLevel() != n2) continue;
                    loggingLevelMenuItem.setSelected(true);
                    break;
                }
                enumeration = this.mMemberLevelGroup2.getElements();
                while (enumeration.hasMoreElements()) {
                    loggingLevelMenuItem = (LoggingLevelMenuItem)enumeration.nextElement();
                    if (loggingLevelMenuItem.getLevel() != n2) continue;
                    loggingLevelMenuItem.setSelected(true);
                    break;
                }
            }
        }
    }

    public void deviceTreeMouseReleased(MouseEvent mouseEvent) {
        int n = this.devTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1 && (mouseEvent.isPopupTrigger() || this.mPopupTrigger)) {
            this.devTree.setSelectionRow(n);
            Object object = this.devTree.getLastSelectedPathComponent();
            if (object == null) {
                return;
            }
            LOG.debug((Object)("n is a " + object.getClass().getName()));
            if (object instanceof DeviceNode) {
                this.mMemberNameItem.setText(((DeviceNode)object).devName);
                this.mMemberPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private void initTree() {
        this.root = new RootNode(this.db);
        this.treeModel = new DefaultTreeModel(this.root);
        this.devTree = new JTree(this.treeModel);
        this.devTree.getSelectionModel().setSelectionMode(1);
        this.devTree.setMinimumSize(new Dimension(0, 0));
        this.devTree.setDragEnabled(true);
        this.devTree.setRootVisible(false);
        this.devTree.setShowsRootHandles(true);
        this.devTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Main.this.deviceTreeMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Main.this.deviceTreeMouseReleased(mouseEvent);
            }
        });
        this.treeView.getViewport().removeAll();
        this.treeView.getViewport().add(this.devTree);
    }

    public TangoNode searchNode(TangoNode tangoNode, String string) {
        int n = this.treeModel.getChildCount(tangoNode);
        int n2 = 0;
        boolean bl = false;
        TangoNode tangoNode2 = null;
        while (n2 < n && !bl) {
            tangoNode2 = (TangoNode)this.treeModel.getChild(tangoNode, n2);
            bl = tangoNode2.toString().compareToIgnoreCase(string) == 0;
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return tangoNode2;
        }
        return null;
    }

    public void refreshTree() {
        this.treeView.getViewport().removeAll();
        TreePath treePath = this.devTree.getSelectionPath();
        if (this.db != null) {
            this.initTree();
        }
        if (treePath != null) {
            TreePath treePath2 = new TreePath(this.root);
            TangoNode tangoNode = this.root;
            boolean bl = true;
            int n = 1;
            while (bl && n < treePath.getPathCount()) {
                String string = treePath.getPathComponent(n).toString();
                if ((tangoNode = this.searchNode(tangoNode, string)) != null) {
                    treePath2 = treePath2.pathByAddingChild(tangoNode);
                    ++n;
                    continue;
                }
                bl = false;
            }
            this.devTree.setSelectionPath(treePath2);
            this.devTree.expandPath(treePath2);
            this.devTree.makeVisible(treePath2);
            this.devTree.scrollPathToVisible(treePath2);
        }
    }

    public void selectDevice(String string) {
        int n = string.indexOf(47);
        int n2 = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1);
        TangoNode tangoNode = this.searchNode(this.root, string2);
        if (tangoNode == null) {
            return;
        }
        TangoNode tangoNode2 = this.searchNode(tangoNode, string3);
        if (tangoNode2 == null) {
            return;
        }
        TangoNode tangoNode3 = this.searchNode(tangoNode2, string4);
        if (tangoNode3 == null) {
            return;
        }
        TreePath treePath = new TreePath(this.root);
        treePath = treePath.pathByAddingChild(tangoNode);
        treePath = treePath.pathByAddingChild(tangoNode2);
        treePath = treePath.pathByAddingChild(tangoNode3);
        this.devTree.setSelectionPath(treePath);
        this.devTree.scrollPathToVisible(treePath);
    }

    public static void showTangoError(DevFailed devFailed) {
        String string = "";
        if (devFailed != null) {
            for (int i = 0; i < devFailed.errors.length; ++i) {
                string = string + "Desc -> " + devFailed.errors[i].desc + "\n";
                string = string + "Reason -> " + devFailed.errors[i].reason + "\n";
                string = string + "Origin -> " + devFailed.errors[i].origin + "\n";
            }
            if (string.length() > 0) {
                JOptionPane.showMessageDialog(self, string, "Tango error", 0);
            }
        }
    }

    private static void initLog4J() {
        Properties properties = new Properties();
        properties.setProperty("log4j.rootCategory", "ERROR, A1");
        properties.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.A1.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void cleanup() {
        if (mTlr != null) {
            mTlr.cleanup();
            mTlr = null;
        }
    }

    public static void main(String[] stringArray) {
        Main main = new Main(stringArray, false);
    }

    public class LogTableRowRenderer
    extends DefaultTableCellRenderer {
        private final Color _scolor = new Color(204, 204, 255);
        private final Color _color = new Color(230, 230, 230);
        private final JCheckBox _true = new JCheckBox("", true);
        private final JCheckBox _false = new JCheckBox("", false);

        LogTableRowRenderer() {
            this.setHorizontalAlignment(0);
            this._true.setHorizontalAlignment(0);
            this._false.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            String string = (String)jTable.getColumnModel().getColumn(n2).getHeaderValue();
            if (bl) {
                this.setBackground(this._scolor);
            } else if (string.equals("Level")) {
                object2 = (Level)object;
                if (object2 == Level.FATAL) {
                    this.setBackground(Color.black);
                    this.setForeground(Color.white);
                } else if (object2 == Level.ERROR) {
                    this.setBackground(Color.red);
                    this.setForeground(Color.black);
                } else if (object2 == Level.WARN) {
                    this.setBackground(Color.orange);
                    this.setForeground(Color.black);
                } else if (object2 == Level.INFO) {
                    this.setBackground(Color.green);
                    this.setForeground(Color.black);
                } else if (object2 == Level.DEBUG) {
                    this.setBackground(Color.cyan);
                    this.setForeground(Color.black);
                }
            } else {
                if (n % 2 == 0) {
                    this.setBackground(this._color);
                } else {
                    this.setBackground(Color.white);
                }
                this.setForeground(Color.black);
            }
            if (string.equals("Trace")) {
                object2 = (Boolean)object == Boolean.TRUE ? this._true : this._false;
                return object2;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class CustomLabel
    extends JLabel {
        public CustomLabel() {
            super.setText(" ");
        }

        public void setText(String string) {
            super.setText(string);
            this.update(this.getGraphics());
        }

        public void reset() {
            this.setText(" ");
        }
    }

    private class LoggingLevelMenu
    extends JMenu {
        public LoggingLevelMenu(String string, ButtonGroup buttonGroup, boolean bl) {
            super(string);
            ButtonGroup buttonGroup2 = buttonGroup != null ? buttonGroup : new ButtonGroup();
            LoggingLevelMenuItem loggingLevelMenuItem = new LoggingLevelMenuItem("OFF", 0);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            loggingLevelMenuItem.setSelected(true);
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("FATAL", 1);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("ERROR", 2);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("WARN", 3);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("INFO", 4);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("DEBUG", 5);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
        }
    }

    private class LoggingLevelMenuItem
    extends JRadioButtonMenuItem {
        private int mLevel;

        public LoggingLevelMenuItem(String string, int n) {
            super(string);
            this.mLevel = n;
        }

        public int getLevel() {
            return this.mLevel;
        }
    }

    private class LevelActionListener
    implements ActionListener {
        private boolean mAddBefore = false;

        public LevelActionListener(boolean bl) {
            this.mAddBefore = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            Object object = Main.this.devTree.getLastSelectedPathComponent();
            if (object == null) {
                return;
            }
            if (object instanceof DeviceNode) {
                int n = ((LoggingLevelMenuItem)actionEvent.getSource()).getLevel();
                String string2 = ((DeviceNode)object).devName;
                Main.this.mLabel.setText("Contacting " + string2 + "...");
                if (mTlr.setDeviceLoggingLevel(string2, n, this.mAddBefore) != -1) {
                    if (this.mAddBefore) {
                        Main.this.mHistoryArea.write("Added " + string2);
                    }
                    Main.this.mHistoryArea.write("Changed " + string2 + " logging level to " + string);
                }
            }
            Main.this.mLabel.reset();
        }
    }

    private class BasicLoggingLevelMenu
    extends JMenu {
        public BasicLoggingLevelMenu(String string) {
            super(string);
            BasicLoggingLevelMenuItem basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("OFF", 0);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("FATAL", 1);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("ERROR", 2);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("WARN", 3);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("INFO", 4);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("DEBUG", 5);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
        }
    }

    private class BasicLoggingLevelMenuItem
    extends JMenuItem {
        private int mLevel;

        public BasicLoggingLevelMenuItem(String string, int n) {
            super(string);
            this.mLevel = n;
        }

        public int getLevel() {
            return this.mLevel;
        }
    }

    private class BasicLevelActionListener
    implements ActionListener {
        private BasicLevelActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            Object object = Main.this.devTree.getLastSelectedPathComponent();
            if (object == null) {
                return;
            }
            if (object instanceof DeviceNode) {
                int n = ((BasicLoggingLevelMenuItem)actionEvent.getSource()).getLevel();
                String string2 = "logging level for colocated devices matching " + ((DeviceNode)object).devName + " to " + string;
                Main.this.mLabel.setText("Changing " + string2);
                if (mTlr.setColocatedDevicesLoggingLevel(((DeviceNode)object).devName, n) != -1) {
                    Main.this.mHistoryArea.write("Changed " + string2);
                }
            }
            Main.this.mLabel.reset();
        }
    }

    private class SourceListActionListener
    implements ActionListener {
        private SourceListActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.this.mHistoryArea.write("Current source list:");
            String[] stringArray = mTlr.getLoggingSources();
            if (stringArray.length == 0) {
                Main.this.mHistoryArea.write("\t- none");
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    Main.this.mHistoryArea.write("\t- " + stringArray[i]);
                }
            }
        }
    }
}

