/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.AttDataReadyHelper;
import fr.esrf.Tango.AttributeConfig_3;
import fr.esrf.Tango.AttributeConfig_3Helper;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.AttributeValue_4Helper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;
import java.util.Iterator;
import org.jacorb.orb.CDRInputStream;
import org.zeromq.ZMQ;

public class ZMQutils {
    public static final int ZMQ_END = 0;
    public static final int ZMQ_CONNECT_HEARTBEAT = 1;
    public static final int ZMQ_DISCONNECT_HEARTBEAT = 2;
    public static final int ZMQ_CONNECT_EVENT = 3;
    public static final int ZMQ_DISCONNECT_EVENT = 4;
    private static final String[] commandNames = new String[]{"ZMQ_END", "ZMQ_CONNECT_HEARTBEAT", "ZMQ_DISCONNECT_HEARTBEAT", "ZMQ_CONNECT_EVENT", "ZMQ_DISCONNECT_EVENT", "ZMQ_CONNECT_MCAST_EVENT"};
    private static ZMQ.Context context = ZMQ.context((int)1);
    private static ZMQutils instance = null;

    static ZMQutils getInstance() {
        if (instance == null) {
            instance = new ZMQutils();
        }
        return instance;
    }

    private ZMQutils() {
    }

    static ZMQ.Context getContext() {
        return context;
    }

    private static byte[] buildTheBuffer(int n, ArrayList<String> arrayList) {
        return ZMQutils.buildTheBuffer(n, arrayList, null);
    }

    private static byte[] buildTheBuffer(int n, ArrayList<String> arrayList, ArrayList<Integer> arrayList2) {
        byte[] byArray;
        int n2 = 1;
        if (arrayList.size() > 0) {
            for (String string : arrayList) {
                n2 += string.length() + 1;
            }
            if (arrayList2 != null && arrayList2.size() > 0) {
                n2 += arrayList2.size() * 4;
            }
        }
        Object object = new byte[n2];
        int n3 = 0;
        object[n3++] = (byte)n;
        for (String string : arrayList) {
            for (byte by : byArray = string.getBytes()) {
                object[n3++] = by;
            }
            object[n3++] = false;
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            Iterator<Object> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                int n4 = (Integer)iterator.next();
                for (byte by : byArray = ZMQutils.codeInteger(n4)) {
                    object[n3++] = by;
                }
            }
        }
        return object;
    }

    private static String getString(byte[] byArray, int n) throws DevFailed {
        int n2;
        int n3 = -1;
        for (n2 = n; n2 < byArray.length && n3 < 0; ++n2) {
            if (byArray[n2] != 0) continue;
            n3 = n2;
        }
        if (n3 < 0) {
            n3 = byArray.length - 1;
        }
        if ((n2 = n3 - n) <= 0) {
            Except.throw_wrong_syntax_exception("API_BadSyntax", "Bad syntax in control buffer (String not found)", "ZMQutils.getString()");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new String(byArray2);
    }

    private static byte[] codeInteger(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(n >> i * 8);
        }
        return byArray;
    }

    private static int decodeInteger(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = byArray[i] << i * 8 & 255 << i * 8;
            n += n2;
        }
        return n;
    }

    private static int getInteger(byte[] byArray, int n) {
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n, byArray2, 0, 4);
        return ZMQutils.decodeInteger(byArray2);
    }

    static void sendToZmqControlSocket(byte[] byArray) throws DevFailed {
        ZMQ.Socket socket = context.socket(3);
        socket.connect("inproc://control");
        socket.send(byArray, 0);
        byte[] byArray2 = socket.recv(0);
        socket.close();
        if (byArray2.length > 0) {
            Except.throw_exception("API_InternalCommunicationError", new String(byArray2), "sendToZmqControlSocket()");
        }
        ApiUtil.printTrace("---> Message sent");
    }

    static String getFullAttributeName(String string, String string2, String string3) throws DevFailed {
        return ("tango://" + ApiUtil.get_db_obj().getFullTangoHost() + "/" + string + "/" + string2 + "." + string3).toLowerCase();
    }

    static String getFullHeartBeatName(String string) throws DevFailed {
        return "tango://" + ApiUtil.get_db_obj().getFullTangoHost() + "/" + string + ".heartbeat";
    }

    static void disConnectEvent(String string, String string2, String string3) throws DevFailed {
        byte[] byArray = ZMQutils.getBufferToDisConnectEvent(string, string2, string3);
        ZMQutils.sendToZmqControlSocket(byArray);
    }

    private static byte[] getBufferToDisConnectEvent(String string, String string2, String string3) throws DevFailed {
        byte[] byArray = new byte[]{};
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(ZMQutils.getFullAttributeName(string, string2, string3));
            byArray = ZMQutils.buildTheBuffer(4, arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Except.throw_exception("API_ConversionFailed", exception.toString(), "ZMQtest.codeBufferToConnectHeartbeat()");
        }
        return byArray;
    }

    static void connectEvent(String string, String string2, DevVarLongStringArray devVarLongStringArray, String string3) throws DevFailed {
        byte[] byArray = ZMQutils.getBufferToConnectEvent(string, string2, devVarLongStringArray, string3);
        ZMQutils.sendToZmqControlSocket(byArray);
    }

    private static byte[] getBufferToConnectEvent(String string, String string2, DevVarLongStringArray devVarLongStringArray, String string3) throws DevFailed {
        byte[] byArray = new byte[]{};
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(devVarLongStringArray.svalue[1]);
            arrayList.add(ZMQutils.getFullAttributeName(string, string2, string3));
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            arrayList2.add(devVarLongStringArray.lvalue[2]);
            arrayList2.add(devVarLongStringArray.lvalue[3]);
            arrayList2.add(devVarLongStringArray.lvalue[4]);
            byArray = ZMQutils.buildTheBuffer(3, arrayList, arrayList2);
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Except.throw_exception("API_ConversionFailed", exception.toString(), "ZMQtest.codeBufferToConnectHeartbeat()");
        }
        return byArray;
    }

    static void connectHeartbeat(String string, DevVarLongStringArray devVarLongStringArray) throws DevFailed {
        byte[] byArray = ZMQutils.getBufferToConnectHeartbeat(string, devVarLongStringArray);
        ZMQutils.sendToZmqControlSocket(byArray);
    }

    private static byte[] getBufferToConnectHeartbeat(String string, DevVarLongStringArray devVarLongStringArray) throws DevFailed {
        byte[] byArray = new byte[]{};
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(devVarLongStringArray.svalue[0]);
            arrayList.add(ZMQutils.getFullHeartBeatName(string));
            byArray = ZMQutils.buildTheBuffer(1, arrayList);
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            Except.throw_exception("API_ConversionFailed", exception.toString(), "ZMQtest.codeBufferToConnectHeartbeat()");
        }
        return byArray;
    }

    private static byte[] getBufferToDisconnectHeartbeat(String string) throws DevFailed {
        byte[] byArray = new byte[]{};
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(ZMQutils.getFullHeartBeatName(string));
            byArray = ZMQutils.buildTheBuffer(2, arrayList);
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            Except.throw_exception("API_ConversionFailed", exception.toString(), "ZMQtest.codeBufferToDisconnectHeartbeat()");
        }
        return byArray;
    }

    static DevVarLongStringArray getEventSubscriptionInfoFromAdmDevice(DeviceProxy deviceProxy, String string, String string2, String string3) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        String[] stringArray = new String[]{string, string2, "subscribe", string3};
        deviceData.insert(stringArray);
        DeviceData deviceData2 = deviceProxy.command_inout("ZmqEventSubscriptionChange", deviceData);
        return deviceData2.extractLongStringArray();
    }

    static AttDataReady deMarshallAttDataReady(byte[] byArray, boolean bl) throws DevFailed {
        try {
            byte[] byArray2 = new byte[byArray.length - 4];
            System.arraycopy(byArray, 4, byArray2, 0, byArray.length - 4);
            CDRInputStream cDRInputStream = new CDRInputStream(null, byArray2, bl);
            return AttDataReadyHelper.read(cDRInputStream);
        }
        catch (Exception exception) {
            Except.throw_exception("Api_ConvertionFailed", "An exception " + exception + " has been catch", "ZMQutils.deMarshallAttDataReady()");
            return null;
        }
    }

    static AttributeInfoEx deMarshallAttributeConfig(byte[] byArray, boolean bl) throws DevFailed {
        try {
            byte[] byArray2 = new byte[byArray.length - 4];
            System.arraycopy(byArray, 4, byArray2, 0, byArray.length - 4);
            CDRInputStream cDRInputStream = new CDRInputStream(null, byArray2, bl);
            AttributeConfig_3 attributeConfig_3 = AttributeConfig_3Helper.read(cDRInputStream);
            return new AttributeInfoEx(attributeConfig_3);
        }
        catch (Exception exception) {
            Except.throw_exception("Api_ConvertionFailed", "An exception " + exception + " has been catch", "ZMQutils.deMarshallAttributeConfig()");
            return null;
        }
    }

    static DeviceAttribute deMarshallAttribute(byte[] byArray, boolean bl) throws DevFailed {
        try {
            byte[] byArray2 = new byte[byArray.length - 4];
            System.arraycopy(byArray, 4, byArray2, 0, byArray.length - 4);
            CDRInputStream cDRInputStream = new CDRInputStream(null, byArray2, bl);
            AttributeValue_4 attributeValue_4 = AttributeValue_4Helper.read(cDRInputStream);
            return new DeviceAttribute(attributeValue_4);
        }
        catch (Exception exception) {
            Except.throw_exception("Api_ConvertionFailed", "An exception " + exception + " has been catch", "ZMQutils.deMarshallAttribute()");
            return null;
        }
    }

    static int getEventType(String string) throws DevFailed {
        int n = -1;
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            String string2 = string.substring(n2 + 1);
            for (int i = 0; n < 0 && i < TangoConst.eventNames.length; ++i) {
                if (!string2.equals(TangoConst.eventNames[i])) continue;
                n = i;
            }
        }
        if (n < 0) {
            Except.throw_exception("Api_BadParameterException", "Cannot find event type for " + string, "ZMQutils.getEventType()");
        }
        return n;
    }

    ControlStructure decodeControlBuffer(byte[] byArray) throws DevFailed {
        ControlStructure controlStructure = new ControlStructure();
        int n = 0;
        controlStructure.commandCode = byArray[n++];
        switch (controlStructure.commandCode) {
            case 0: {
                break;
            }
            case 1: {
                controlStructure.endPoint = ZMQutils.getString(byArray, n++);
                controlStructure.eventName = ZMQutils.getString(byArray, n += controlStructure.endPoint.length());
                break;
            }
            case 2: {
                controlStructure.eventName = ZMQutils.getString(byArray, n);
                break;
            }
            case 3: {
                controlStructure.endPoint = ZMQutils.getString(byArray, n++);
                n += controlStructure.endPoint.length();
                controlStructure.eventName = ZMQutils.getString(byArray, n++);
                controlStructure.hwm = ZMQutils.getInteger(byArray, n += controlStructure.eventName.length());
                controlStructure.rate = ZMQutils.getInteger(byArray, n + 4);
                controlStructure.ivl = ZMQutils.getInteger(byArray, n + 8);
                break;
            }
            case 4: {
                controlStructure.eventName = ZMQutils.getString(byArray, n);
                break;
            }
            default: {
                Except.throw_exception("API_NotImplemented", "Command " + controlStructure.commandCode + "  NOT yet implemented", "ZMQutils.decodeControlBuffer()");
            }
        }
        return controlStructure;
    }

    public static void trace(DevVarLongStringArray devVarLongStringArray) {
        System.out.println("Svalue");
        for (String string : devVarLongStringArray.svalue) {
            System.out.println("\t" + string);
        }
        System.out.println("Lvalue");
        for (int n : devVarLongStringArray.lvalue) {
            System.out.println("\t" + n);
        }
    }

    public static void dump(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            String string = String.format("%02x", 0xFF & byArray[i]);
            System.out.print("0x" + string + " ");
            if ((i + 1) % 16 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    class ControlStructure {
        int commandCode = -1;
        String endPoint;
        String eventName;
        int hwm = 0;
        int rate = 0;
        int ivl = 0;

        ControlStructure() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Command: ").append(commandNames[this.commandCode]).append("\n");
            if (this.endPoint != null) {
                stringBuffer.append("endPoint: ").append(this.endPoint).append("\n");
            }
            if (this.eventName != null) {
                stringBuffer.append("eventName: ").append(this.eventName).append("\n");
            }
            stringBuffer.append("int: ").append(this.hwm).append("  ").append(this.rate).append("  ").append(this.ivl).append("\n");
            return stringBuffer.toString();
        }
    }
}

