/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;

class KeepAliveThread
extends TimerTask
implements TangoConst {
    private static final long EVENT_RESUBSCRIBE_PERIOD = 600000L;
    private static final long EVENT_HEARTBEAT_PERIOD = 10000L;

    public void run() {
        long l = 15000L;
        if (System.currentTimeMillis() - this.scheduledExecutionTime() >= l) {
            return;
        }
        EventConsumer.subscribe_if_not_done();
        this.resubscribe_if_needed();
    }

    static boolean heartbeatHasBeenSkipped(EventChannelStruct eventChannelStruct) {
        long l = System.currentTimeMillis();
        return l - eventChannelStruct.last_heartbeat > 10000L;
    }

    static long getEventHeartbeatPeriod() {
        return 10000L;
    }

    private void resubscribe_if_needed() {
        Enumeration<String> enumeration = EventConsumer.getChannelMap().keys();
        long l = System.currentTimeMillis();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            EventChannelStruct eventChannelStruct = EventConsumer.getChannelMap().get(string);
            if (l - eventChannelStruct.last_subscribed > 200000L) {
                this.reSubscribeByName(eventChannelStruct, string);
            }
            eventChannelStruct.consumer.checkIfHeartbeatSkipped(string, eventChannelStruct);
        }
    }

    private void reSubscribeByName(EventChannelStruct eventChannelStruct, String string) {
        Hashtable<String, EventCallBackStruct> hashtable = EventConsumer.getEventCallbackMap();
        EventCallBackStruct eventCallBackStruct = null;
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct2 = hashtable.get(string2);
            if (!eventCallBackStruct2.channel_name.equals(string)) continue;
            eventCallBackStruct = eventCallBackStruct2;
        }
        if (eventCallBackStruct != null) {
            eventCallBackStruct.consumer.reSubscribeByName(eventChannelStruct, string);
        }
    }
}

