/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HostInfo {
    private static String name = null;
    private static String address = null;
    private static Vector<String> addresses = new Vector();

    private HostInfo() throws DevFailed {
        try {
            Enumeration<NetworkInterface> enet = NetworkInterface.getNetworkInterfaces();
            block2: while (enet.hasMoreElements() && name == null) {
                NetworkInterface net = enet.nextElement();
                Enumeration<InetAddress> eaddr = net.getInetAddresses();
                while (eaddr.hasMoreElements()) {
                    InetAddress inet = eaddr.nextElement();
                    if (inet.getCanonicalHostName().startsWith("local") || inet.getCanonicalHostName().equalsIgnoreCase(inet.getHostAddress())) continue;
                    addresses.add(inet.getHostAddress());
                    if (!this.isIPV4adress(inet.getHostAddress())) continue;
                    name = inet.getCanonicalHostName();
                    address = inet.getHostAddress();
                    continue block2;
                }
            }
        }
        catch (SocketException e) {
            Except.throw_exception("TangoApi_SockectException", e.toString(), "HostInfo.HostInfo()");
        }
    }

    private boolean isIPV4adress(String address) {
        StringTokenizer st = new StringTokenizer(address, ".");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.size() == 4;
    }

    static String getName() throws DevFailed {
        if (name == null) {
            new HostInfo();
        }
        return name;
    }

    static String getAddress() throws DevFailed {
        if (address == null) {
            new HostInfo();
        }
        return address;
    }

    static Vector<String> getAddresses() throws DevFailed {
        if (address == null) {
            new HostInfo();
        }
        return addresses;
    }

    private static String toStaticString() {
        String str = "";
        try {
            if (name == null) {
                new HostInfo();
            }
            str = str + "name:          " + name + "\n";
            str = str + "address:       " + address + "\n";
        }
        catch (DevFailed e) {
            str = e.errors[0].desc;
        }
        return str;
    }

    public static void main(String[] args) {
        System.out.println(HostInfo.toStaticString());
    }
}

