/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangoUrl;
import java.util.Hashtable;

public class DeviceProxyFactory {
    private static Hashtable proxy_table = new Hashtable();
    private static DeviceProxyFactory instance = null;

    private DeviceProxyFactory() {
    }

    public static DeviceProxyFactory get_instance() {
        if (instance == null) {
            instance = new DeviceProxyFactory();
        }
        return instance;
    }

    public static DeviceProxy get(String devname) throws DevFailed {
        String full_devname = new TangoUrl(devname).toString().toLowerCase();
        DeviceProxy dev = (DeviceProxy)proxy_table.get(full_devname);
        if (dev == null) {
            dev = new DeviceProxy(devname);
            proxy_table.put(full_devname, dev);
        }
        return dev;
    }

    public static boolean exists(String devname) throws DevFailed {
        String full_devname = new TangoUrl(devname).toString();
        DeviceProxy dev = (DeviceProxy)proxy_table.get(full_devname);
        return dev != null;
    }

    public static void remove(String devname) {
        try {
            String full_devname = new TangoUrl(devname).toString();
            if (proxy_table.containsKey(full_devname)) {
                proxy_table.remove(full_devname);
            }
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
    }

    public static void remove(DeviceProxy dev) {
        String full_devname = dev.url.toString();
        if (proxy_table.containsKey(full_devname)) {
            proxy_table.remove(full_devname);
        }
    }

    static void add(DeviceProxy dev) {
        String full_devname = dev.url.toString();
        DeviceProxy tmp_dev = (DeviceProxy)proxy_table.get(full_devname);
        if (tmp_dev == null) {
            proxy_table.put(full_devname, dev);
        }
    }
}

