/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import pogo.class2www.Family;
import pogo.class2www.FamilyList;
import pogo.class2www.Module;
import pogo.class2www.Repository;
import pogo.gene.PogoUtil;

public class EsrfRepository
extends Repository {
    private static final String cvs_path = "esrf";

    public EsrfRepository(String backup_home, boolean check_svn) throws DevFailed {
        super(backup_home + "/" + cvs_path);
        this.name = "ESRF";
        this.remote = false;
        this.url = "http://ww.esrf.eu/";
        this.home = "./" + this.name;
        this.default_family = "Measures";
        this.families = new FamilyList(cvs_path);
        this.check_svn = check_svn;
    }

    public void parseCvsModule() {
        String[] lines = PogoUtil.string2array(this.str_module, "\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!line.startsWith("#M")) continue;
            String[] tmp = PogoUtil.string2array(line);
            String module_name = tmp[1];
            String f_name = tmp.length > 2 && tmp[2].indexOf(58) > 0 ? tmp[2].substring(0, tmp[2].indexOf(58)) : "Miscellaneous";
            tmp = PogoUtil.string2array(lines[i + 1]);
            String path = tmp[1];
            if (path.indexOf("server/") <= 0) continue;
            Family family = this.families.getFamily(f_name);
            if (family == null) {
                family = new Family(f_name);
                this.families.add(family);
            }
            Module module = new Module(module_name, path, this, family, 0);
            family.add(module);
        }
    }

    public static void main(String[] args) {
        try {
            EsrfRepository esrf = new EsrfRepository("/segfs/tango/backup/", false);
            esrf.parseCvsModule();
            System.out.println(esrf);
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
    }
}

