/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.PogoConst;

public class Utils {
    private static Utils instance = null;
    private static ImageIcon tango_icon = null;
    public ImageIcon root_icon = this.getIcon("TangoSplash.jpg", 0.2);
    public ImageIcon class_icon = this.getIcon("TangoClass.gif", 0.4);
    public ImageIcon collec_icon = this.getIcon("tools.gif");
    public ImageIcon classprop_icon = this.getIcon("class.gif");
    public ImageIcon cmd_icon = this.getIcon("command.gif");
    public ImageIcon cmd_exp_icon = this.getIcon("command_expert.gif");
    public ImageIcon scalar_icon = this.getIcon("scalar.gif");
    public ImageIcon scalar_exp_icon = this.getIcon("scalar_expert.gif");
    public ImageIcon spectrum_icon = this.getIcon("spectrum.gif");
    public ImageIcon spectrum_exp_icon = this.getIcon("spectrum_expert.gif");
    public ImageIcon image_icon = this.getIcon("image.gif", 0.25);
    public ImageIcon image_exp_icon = this.getIcon("image_expert.gif", 0.25);
    public ImageIcon devprop_icon = this.getIcon("device.gif");
    public ImageIcon state_icon = this.getIcon("state.gif");
    public ImageIcon inherite_icon = this.getIcon("inherite.gif", 0.5);
    public ImageIcon remove_icon = this.getIcon("remove.gif");
    public ImageIcon abstract_icon = this.getIcon("abstract.gif");
    public ImageIcon inherited_icon = this.getIcon("inherited.gif");
    public ImageIcon overloaded_icon = this.getIcon("concrete.gif");
    public ImageIcon unknown_icon = this.getIcon("greyball.gif");
    public ImageIcon reload_icon = this.getIcon("reload_icon.gif", 0.8);
    public ImageIcon new_icon = this.getIcon("new_icon.gif", 1.0);
    public ImageIcon open_icon = this.getIcon("open_icon.gif", 1.0);
    public ImageIcon save_icon = this.getIcon("save_icon.gif", 1.0);
    private static final String tooltipHeader = "<html><BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFD0\">";
    private static Splash splash = null;
    private static boolean splashOn;
    private SplashRefresher splash_refresher;
    private static boolean useDisplay;
    private boolean splashInit = false;

    static {
        useDisplay = true;
    }

    private Utils() {
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public ImageIcon getIcon(String filename, double ratio) {
        ImageIcon icon = this.getIcon(filename);
        return this.getIcon(icon, ratio);
    }

    public ImageIcon getIcon(ImageIcon icon, double ratio) {
        if (icon != null) {
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            width = (int)(ratio * (double)width);
            height = (int)(ratio * (double)height);
            icon = new ImageIcon(icon.getImage().getScaledInstance(width, height, 4));
        }
        return icon;
    }

    public URL getImageUrl(String filename) {
        return this.getClass().getResource("/org/tango/pogo/pogo_gui/img/" + filename);
    }

    public ImageIcon getIcon(String filename) {
        URL url = this.getImageUrl(filename);
        if (url == null) {
            System.err.println("Icon file  " + filename + "  not found");
            return null;
        }
        return new ImageIcon(url);
    }

    public static String getRelativeFilename(String absFilename) {
        String relativeFilename = absFilename;
        int pos = absFilename.lastIndexOf(System.getProperty("file.separator"));
        if (pos > 0) {
            relativeFilename = absFilename.substring(pos + 1);
        }
        return relativeFilename;
    }

    public static String getPath(String filename) {
        String separator = System.getProperty("file.separator");
        int pos = filename.lastIndexOf(separator);
        String path = "./";
        if (pos > 0) {
            path = filename.substring(0, pos);
        }
        return path;
    }

    public static int getLanguage(String lang) {
        int i = 0;
        while (i < PogoConst.strLang.length) {
            if (lang.toLowerCase().equals(PogoConst.strLang[i].toLowerCase())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getLanguage(int lang) {
        return PogoConst.strLang[lang];
    }

    public static String getFileExtension(String lang) {
        return PogoConst.fileExtention[Utils.getLanguage(lang)];
    }

    public static String buildExcecMethodName(String cmdname) {
        if (cmdname.equals("State")) {
            return "dev_state";
        }
        if (cmdname.equals("Status")) {
            return "dev_status";
        }
        String str = "";
        int i = 0;
        while (i < cmdname.length()) {
            if (cmdname.charAt(i) >= 'A' && cmdname.charAt(i) <= 'Z') {
                if (i > 0 && (cmdname.charAt(i - 1) < 'A' || cmdname.charAt(i - 1) > 'Z')) {
                    str = String.valueOf(str) + '_';
                }
                str = String.valueOf(str) + (char)(cmdname.charAt(i) + 32);
            } else {
                str = String.valueOf(str) + cmdname.charAt(i);
            }
            ++i;
        }
        return str;
    }

    public static String spaceTabulation(int nb) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < nb) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public static int getCommandIndex(EList<Command> list, Command cmd) {
        int idx = -1;
        int i = 0;
        for (Command c2 : list) {
            if (c2 == cmd) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static int getAttributeIndex(EList<Attribute> list, Attribute attribute) {
        int idx = -1;
        int i = 0;
        for (Attribute att : list) {
            if (att == attribute) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static int getStateIndex(EList<State> list, State state) {
        int idx = -1;
        int i = 0;
        for (State st : list) {
            if (st == state) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static int getPropertyIndex(EList<Property> list, Property prop) {
        int idx = -1;
        int i = 0;
        for (Property p : list) {
            if (p == prop) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static String strReplaceSpecialCharToCode(String text) {
        if (text == null) {
            return null;
        }
        text = Utils.strReplace(text, "\"", "``").trim();
        text = Utils.strReplace(text, "'", "`").trim();
        return text;
    }

    public static String strReplaceSpecialCharToDisplay(String text) {
        if (text == null) {
            return null;
        }
        text = Utils.strReplace(text, "\\\"", "\"").trim();
        text = Utils.strReplace(text, "\\'", "'").trim();
        return text;
    }

    public static String strReplace(String text, String old_str, String new_str) {
        if (text == null) {
            return "";
        }
        int pos = 0;
        while ((pos = text.indexOf(old_str, pos)) >= 0) {
            text = String.valueOf(text.substring(0, pos)) + new_str + text.substring(pos + old_str.length());
            pos += new_str.length();
        }
        return text;
    }

    public static String checkNameSyntax(String name, boolean isStateStatus) throws DevFailed {
        if (name == null || name.length() == 0) {
            Except.throw_exception("BAD_PARM", "Name not valid !", "Utils.checkNameSyntax()");
        }
        StringTokenizer stk = new StringTokenizer(name);
        ArrayList<String> vs = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            vs.add(stk.nextToken());
        }
        name = "";
        for (String s : vs) {
            name = String.valueOf(name) + s;
        }
        int i = 0;
        while (i < name.length()) {
            char c2 = name.charAt(i);
            if ((c2 < '0' || c2 > '9' && c2 < 'A' || c2 > 'Z' && c2 < 'a' || c2 > 'z') && c2 != '_') {
                Except.throw_exception("SyntaxError", "Syntax error in name: Do not use '" + c2 + "' char.", "Utils.checkNameSyntax()");
            }
            ++i;
        }
        String first = name.substring(0, 1).toUpperCase();
        char c3 = (name = String.valueOf(first) + name.substring(1)).charAt(0);
        if (c3 < 'A' || c3 > 'Z') {
            Except.throw_exception("SyntaxError", String.valueOf(name) + ":\nSyntax error in name: The first char must be a letter", "Utils.checkNameSyntax()");
        }
        if (!isStateStatus && (name.equals("State") || name.equals("Status"))) {
            Except.throw_exception("SyntaxError", String.valueOf(name) + "  is reserved", "Utils.checkNameSyntax()");
        }
        return name;
    }

    public static String strBoolean(boolean b2) {
        return b2 ? "true" : "false";
    }

    public static String strBoolean(String str) {
        return Utils.isTrue(str) ? "true" : "false";
    }

    public static boolean isTrue(String str) {
        return str != null && str.equals("true");
    }

    public static boolean isFalse(String str) {
        return !Utils.isTrue(str);
    }

    public static boolean isSet(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEquals(String str1, String str2) {
        return str1 != null && str2 != null && str1.equals(str2);
    }

    public static boolean isExpert(Command cmd) {
        return Utils.isEquals(cmd.getDisplayLevel(), PogoConst.strLevel[1]);
    }

    public static boolean isExpert(Attribute att) {
        return Utils.isEquals(att.getDisplayLevel(), PogoConst.strLevel[1]);
    }

    public static void popupError(Component component, String message) {
        try {
            throw new Exception(message);
        }
        catch (Exception e) {
            Utils.getInstance().stopSplashRefresher();
            ErrorPane.showErrorMessage(component, null, e);
            return;
        }
    }

    public ArrayList<String> getFileList(String dirName) {
        ArrayList<String> v = new ArrayList<String>();
        File dir = new File(dirName);
        String[] fileNames = dir.list();
        if (fileNames == null) {
            return v;
        }
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String filename = String.valueOf(dirName) + "/" + name;
            File f = new File(filename);
            if (!f.isDirectory()) {
                v.add(name);
            }
            ++n2;
        }
        Collections.sort(v, new StringCompare());
        return v;
    }

    public static String searchFileFromDirectory(String searched, String dirname) {
        File d = new File(dirname);
        String[] filenames = d.list();
        if (filenames == null) {
            return null;
        }
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String filename = String.valueOf(dirname) + "/" + name;
            File f = new File(filename);
            if (f.isDirectory()) {
                String found = Utils.searchFileFromDirectory(searched, f.toString());
                if (found != null) {
                    return found;
                }
            } else if (name.equals(searched)) {
                return filename;
            }
            ++n2;
        }
        return null;
    }

    public static boolean osIsUnix() {
        String os = System.getProperty("os.name");
        return !os.toLowerCase().startsWith("windows");
    }

    public static void showInHtmBrowser(String url) {
        String browser = System.getProperty("BROWSER");
        if (browser == null) {
            browser = Utils.osIsUnix() ? "firefox - turbo" : "explorer";
        }
        String cmd = String.valueOf(browser) + " " + url;
        try {
            Utils.executeShellCmdAndReturn(cmd);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, e);
        }
    }

    public static void executeShellCmdAndReturn(String cmd) throws IOException {
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        new BufferedReader(new InputStreamReader(istr));
    }

    public static String getExcludeFilesAndDir(String rootDir) {
        String[] geneFiles = new String[]{".cpp", ".h", ".py", "Makefile", "Makefile.multi", ".sln", ".vcproj"};
        String[] geneDirs = new String[]{"", "vc8_proj", "vc9_proj", "vc10_proj"};
        ArrayList<String> excluded = new ArrayList<String>();
        String[] stringArray = geneDirs;
        int n = geneDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File d;
            String[] fileNames;
            String dir = stringArray[n2];
            String dirName = rootDir;
            if (dir.length() > 0) {
                dirName = String.valueOf(dirName) + "/" + dir;
            }
            if ((fileNames = (d = new File(dirName)).list()) != null) {
                String[] stringArray2 = fileNames;
                int n3 = fileNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    System.out.println(fileName);
                    boolean generates = Utils.couldBeGenerated(fileName, geneFiles);
                    if (!generates) {
                        excluded.add(fileName);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        for (String fileName : excluded) {
            sb.append(fileName).append(", ");
        }
        String str = sb.toString();
        int pos = str.lastIndexOf(44);
        if (pos > 0) {
            str = str.substring(0, pos);
        }
        return str;
    }

    private static boolean couldBeGenerated(String fileName, String[] generated) {
        if (fileName.startsWith(".") || fileName.startsWith("#") || fileName.startsWith("~")) {
            return false;
        }
        boolean generates = false;
        String[] stringArray = generated;
        int n = generated.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (fileName.endsWith(s)) {
                generates = true;
            }
            ++n2;
        }
        return generates;
    }

    public static String getXmiFile() {
        String[] fileList;
        File f = new File(".");
        String[] stringArray = fileList = f.list();
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.endsWith(".xmi") && new File(fileName).isFile()) {
                return fileName;
            }
            ++n2;
        }
        return null;
    }

    public static String buildToolTip(String text) {
        return Utils.buildToolTip(null, text);
    }

    public static String buildToolTip(String title, String text) {
        StringBuilder sb = new StringBuilder(tooltipHeader);
        if (title != null && title.length() > 0) {
            sb.append("<b><Center>").append(Utils.strReplace(title, "\n", "<br>\n")).append("</center></b><HR WIDTH=\"100%\">");
        }
        if (text != null && text.length() > 0) {
            sb.append(Utils.strReplace(text, "\n", "<br>\n"));
        }
        return sb.toString();
    }

    private void createSplash() {
        try {
            if (tango_icon == null) {
                tango_icon = this.getIcon("TangoSplash.gif");
            }
            JSmoothProgressBar myBar = new JSmoothProgressBar();
            myBar.setStringPainted(true);
            myBar.setBackground(Color.lightGray);
            myBar.setProgressBarColors(Color.gray, Color.lightGray, Color.darkGray);
            splash = new Splash(tango_icon, Color.black, myBar);
            splash.setMessage("POGO: Tango code generator");
            splash.setMaxProgress(100);
            splash.setTitle("POGO");
            splash.setCopyright("Release 8.0.7  -  Fri Jun 29 15:04:39 CEST 2012");
        }
        catch (Exception e) {
            useDisplay = false;
            System.err.println("Cannot create Splah: " + e);
        }
    }

    public void stopSplashRefresher() {
        if (splash != null && useDisplay) {
            this.splash_refresher.setSplashOn(false, "");
        }
    }

    public void startSplashRefresher(String message) {
        String env;
        if (!this.splashInit && (env = System.getenv("Classes2www")) != null && env.equals("true")) {
            useDisplay = false;
        }
        this.splashInit = true;
        if (splash == null && useDisplay) {
            this.createSplash();
        }
        if (!useDisplay) {
            splash = null;
        }
        if (useDisplay) {
            splashOn = true;
            this.splash_refresher = new SplashRefresher();
            this.splash_refresher.start();
            this.splash_refresher.setSplashOn(true, message);
        }
    }

    private class SplashRefresher
    extends Thread {
        private SplashRefresher() {
        }

        private synchronized void setSplashOn(boolean b2, String message) {
            if (useDisplay) {
                splashOn = b2;
                splash.setMessage(message);
            }
        }

        @Override
        public void run() {
            int idx = 1;
            splash.initProgress();
            splash.setVisible(true);
            splash.repaint();
            while (splashOn) {
                splash.progress(idx);
                if (idx++ > 98) {
                    idx = 10;
                }
                this.doSleep(100L);
            }
            splash.progress(100);
            splash.setVisible(false);
        }

        private synchronized void doSleep(long millis) {
            try {
                this.wait(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class StringCompare
    implements Comparator<String> {
        StringCompare() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }
}

