/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.tango.pogo.pogo_gui.tools.ParserTool;

public class PopupHtml
extends JDialog
implements TangoConst {
    protected JFrame parent;
    protected JEditorPane pane;
    private String urlFile;
    private static final String header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> title </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n";
    private static final String footer = "</Body>\n</Html>\n";

    public PopupHtml(JFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.parent = parent;
        this.pack();
        if (parent != null && parent.isVisible() && parent.getWidth() > 0) {
            Point p = parent.getLocationOnScreen();
            p.x += 10;
            p.y += 10;
            this.setLocation(p);
        }
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JButton cancelBtn = new JButton();
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PopupHtml.this.closeDialog(evt);
            }
        });
        jPanel1.setLayout(new FlowLayout(2, 5, 5));
        jLabel1.setText("                     ");
        jPanel1.add(jLabel1);
        cancelBtn.setText("Dismiss");
        cancelBtn.setHorizontalAlignment(2);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupHtml.this.dismissBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
    }

    protected synchronized void setPage(URL url) {
        try {
            this.pane.setCursor(new Cursor(3));
            this.pane.setPage(url);
        }
        catch (IOException e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, e);
        }
        this.pane.setCursor(new Cursor(0));
    }

    private String buildTmpFile(String code) {
        String urlstr = null;
        try {
            int random_value = new Random().nextInt(30000);
            String tmpdir = System.getProperty("java.io.tmpdir");
            this.urlFile = String.valueOf(tmpdir) + "/html." + random_value;
            ParserTool.writeFile(this.urlFile, header + code + footer);
            urlstr = "file:" + this.urlFile;
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, e);
            e.printStackTrace();
        }
        return urlstr;
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void doClose() {
        try {
            if (!new File(this.urlFile).delete()) {
                System.err.println("Cannot delete " + this.urlFile);
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, e);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void show(String code) {
        this.show(code, 700, 750);
    }

    public void show(String code, int width, int height) {
        try {
            this.pane = new JEditorPane();
            this.pane.setEditable(false);
            this.pane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                }
            });
            this.getContentPane().add((Component)new JScrollPane(this.pane), "Center");
            this.setSize(width, height);
            URL url = new URL(this.buildTmpFile(code));
            this.setPage(url);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return;
        }
        this.setVisible(true);
    }

    public static void main(String[] args) {
    }
}

