/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoProperty {
    private static final String packname = "org.tango.pogo";
    private static final String defPropFilename = "/Pogo.default_properties";
    private static final String sitePropFilename = "/Pogo.site_properties";
    private static PogoProperty instance = null;
    public static ArrayList<String> classFamilies = new ArrayList();
    public static ArrayList<String> platformNames = new ArrayList();
    public static ArrayList<String> busNames = new ArrayList();
    private static final String docHomeProp = "doc_home";
    private static final String makefileHomeProp = "makefile_home";
    private static final String installHomeProp = "install_home";
    private static final String classFamiliesProp = "class_families";
    private static final String platformNamesProp = "platform_names";
    private static final String busNamesProp = "bus_names";
    private static final String siteNameProp = "site.name";
    private static final String siteClassFamiliesProp = "site.class_families";
    public static String siteName = null;
    public static String docHome = "./doc_html";
    public static String makefileHome = "$(TANGO_HOME)";
    public static String installHome = "$(TANGO_HOME)";
    public static ArrayList<String> siteClassFamilies = new ArrayList();
    private static final int ownHistoSize = 20;
    private static final String ownInheritanceHome = "hinerit_home";
    private static final String ownContactAddress = "contact_address";
    private static final String ownLoadPrevious = "load_previous";
    private static final String ownProjectHistory = "project_history";
    private static final String multiProjectHistory = "multi_class_project_history";
    public static String inheritHome = null;
    public static String contactAddress = "";
    public static boolean loadPrevious = true;
    public static ArrayList<String> projectHistory = new ArrayList();
    public static ArrayList<String> multiClassProjectHistory = new ArrayList();

    public static PogoProperty getInstance() {
        return instance;
    }

    public static PogoProperty init() throws DevFailed {
        if (instance == null) {
            instance = new PogoProperty();
        }
        return instance;
    }

    private PogoProperty() throws DevFailed {
        this.loadDefaultProperties();
        this.loadSiteProperties();
        this.loadPogoRcProperties();
    }

    private void loadDefaultProperties() throws DevFailed {
        try {
            ArrayList<String> vs = this.loadProperties(defPropFilename);
            classFamilies = this.getStringListProperty(classFamiliesProp, vs);
            platformNames = this.getStringListProperty(platformNamesProp, vs);
            busNames = this.getStringListProperty(busNamesProp, vs);
            installHome = this.checkOverwritingPropertyString(installHomeProp, installHome, vs);
            classFamilies.add(0, "");
            busNames.add(0, "");
        }
        catch (Exception e) {
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            Except.throw_exception("LOAD_PROPERTY_FAILED", e.toString(), "PogoProperty.loadProperties()");
        }
    }

    private void loadSiteProperties() {
        try {
            ArrayList<String> vs = this.loadProperties(sitePropFilename);
            siteName = this.getStringProperty(siteNameProp, vs);
            docHome = this.checkOverwritingPropertyString(docHomeProp, docHome, vs);
            makefileHome = this.checkOverwritingPropertyString(makefileHomeProp, makefileHome, vs);
            siteClassFamilies = this.getStringListProperty(siteClassFamiliesProp, vs);
        }
        catch (Exception e) {
            System.err.println("\nWARNING:\tNo site specific properties file found !\n");
        }
    }

    private void loadPogoRcProperties() {
        try {
            String rc_file = PogoProperty.getPogoRCname();
            if (rc_file != null) {
                System.out.println(rc_file);
                ArrayList<String> vs = this.loadPropertiesRC(rc_file);
                projectHistory = this.getStringListProperty(ownProjectHistory, vs);
                multiClassProjectHistory = this.getStringListProperty(multiProjectHistory, vs);
                inheritHome = this.getStringProperty(ownInheritanceHome, vs);
                contactAddress = this.getStringProperty(ownContactAddress, vs);
                String tmp = this.getStringProperty(ownLoadPrevious, vs);
                loadPrevious = Utils.isTrue(tmp);
                if (projectHistory.size() > 0 && projectHistory.get(0).length() == 0) {
                    projectHistory.remove(0);
                }
                if (multiClassProjectHistory.size() > 0 && multiClassProjectHistory.get(0).length() == 0) {
                    multiClassProjectHistory.remove(0);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof DevFailed) {
                System.err.println("\nWARNING:\t" + ((DevFailed)e).errors[0].desc);
            }
            System.err.println("\nWARNING:\t" + e);
        }
    }

    private String checkOverwritingPropertyString(String propname, String propvalue, ArrayList<String> vs) {
        String tmp = this.getStringProperty(propname, vs);
        if (tmp != null) {
            propvalue = tmp;
        }
        return propvalue;
    }

    private static String getPogoRCname() {
        String env = System.getenv("HOME");
        if (env == null) {
            env = System.getenv("TANGO_ROOT");
        }
        if (env == null) {
            return null;
        }
        return String.valueOf(env) + "/.pogorc";
    }

    private ArrayList<String> loadProperties(String filename) throws DevFailed, IOException {
        String str;
        URL url = this.getClass().getResource(filename);
        if (url == null) {
            Except.throw_exception("LOAD_PROPERTY_FAILED", "URL for property file (" + filename + ") is null !", "PogoProperty.loadProperties()");
            return null;
        }
        InputStream is = url.openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> vs = new ArrayList<String>();
        while ((str = br.readLine()) != null) {
            if ((str = str.trim()).startsWith("#") || str.length() <= 0) continue;
            vs.add(str);
        }
        br.close();
        return vs;
    }

    private ArrayList<String> loadPropertiesRC(String filename) throws DevFailed, IOException {
        ArrayList<String> vs = new ArrayList<String>();
        String code = ParserTool.readFile(filename);
        StringTokenizer stk = new StringTokenizer(code, "\n");
        while (stk.hasMoreTokens()) {
            vs.add(stk.nextToken());
        }
        return vs;
    }

    private ArrayList<String> getStringListProperty(String propname, ArrayList<String> vs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean found = false;
        for (String line : vs) {
            if (line.trim().startsWith("#")) continue;
            if (!found) {
                int pos;
                if (!line.startsWith("org.tango.pogo." + propname) || (pos = line.indexOf(58)) <= 0) continue;
                found = true;
                result.add(line.substring(pos + 1).trim());
                continue;
            }
            if (line.trim().indexOf(58) > 2) {
                found = false;
                continue;
            }
            result.add(line.trim());
        }
        return result;
    }

    private String getStringProperty(String propname, ArrayList<String> vs) {
        for (String s : vs) {
            int pos;
            if (!s.startsWith("org.tango.pogo." + propname) || (pos = s.indexOf(58)) <= 0) continue;
            String str = s.substring(pos + 1).trim();
            if (str.length() > 0) {
                return str;
            }
            return null;
        }
        return null;
    }

    public void displayProperties() {
        String debug = System.getProperty("DEBUG_PROP");
        if (debug != null && debug.equals("true")) {
            this.displayProperty(classFamiliesProp, classFamilies);
            this.displayProperty(platformNamesProp, platformNames);
            this.displayProperty(busNamesProp, busNames);
        }
        this.displayProperty(docHomeProp, docHome);
        this.displayProperty(makefileHomeProp, makefileHome);
        this.displayProperty(installHomeProp, installHome);
        this.displayProperty(siteNameProp, siteName);
        if (debug != null && debug.equals("true")) {
            this.displayProperty(siteClassFamiliesProp, siteClassFamilies);
        }
    }

    private void displayProperty(String name, String value) {
        System.out.println(String.valueOf(name) + ":\t" + value);
    }

    private void displayProperty(String name, ArrayList<String> values) {
        System.out.print(String.valueOf(name) + ":");
        for (String s : values) {
            System.out.println("\t" + s);
        }
        System.out.println();
    }

    public static void addProject(String projname, int type) {
        if (type == 0) {
            int i = 0;
            while (i < projectHistory.size()) {
                if (projectHistory.get(i).equals(projname)) {
                    projectHistory.remove(i);
                }
                ++i;
            }
            projectHistory.add(0, projname);
            while (projectHistory.size() > 20) {
                projectHistory.remove(19);
            }
        } else {
            int i = 0;
            while (i < multiClassProjectHistory.size()) {
                if (multiClassProjectHistory.get(i).equals(projname)) {
                    multiClassProjectHistory.remove(i);
                }
                ++i;
            }
            multiClassProjectHistory.add(0, projname);
            while (multiClassProjectHistory.size() > 20) {
                multiClassProjectHistory.remove(19);
            }
        }
        PogoProperty.updatePogoRC();
    }

    private static String buildPropertyLine(String propname) {
        StringBuilder sb = new StringBuilder();
        sb.append(packname).append('.').append(propname).append(":\t");
        return sb.toString();
    }

    public static void updatePogoRC() {
        StringBuilder sb = new StringBuilder();
        sb.append("#\n");
        sb.append("#       This is the Pogo user preferences file\n");
        sb.append("#\n\n");
        sb.append(PogoProperty.buildPropertyLine(ownInheritanceHome)).append(inheritHome);
        sb.append("\n");
        sb.append(PogoProperty.buildPropertyLine(ownContactAddress)).append(contactAddress);
        sb.append("\n");
        sb.append(PogoProperty.buildPropertyLine(ownLoadPrevious)).append(loadPrevious);
        sb.append("\n\n");
        sb.append(PogoProperty.buildPropertyLine(ownProjectHistory)).append('\n');
        for (String project : projectHistory) {
            sb.append('\t').append(project).append('\n');
        }
        sb.append("\n\n");
        sb.append(PogoProperty.buildPropertyLine(multiProjectHistory)).append('\n');
        for (String project : multiClassProjectHistory) {
            sb.append('\t').append(project).append('\n');
        }
        String rc_file = PogoProperty.getPogoRCname();
        String code = "";
        try {
            code = ParserTool.readFile(rc_file);
        }
        catch (Exception e) {
            if (e instanceof DevFailed) {
                System.err.println("\nWARNING:\t" + ((DevFailed)e).errors[0].desc);
            }
            System.err.println("\nWARNING:\t" + e);
        }
        try {
            if (!code.equals(sb.toString())) {
                ParserTool.writeFile(rc_file, sb.toString());
                System.out.println(String.valueOf(rc_file) + " updated");
            }
        }
        catch (Exception e) {
            if (e instanceof DevFailed) {
                System.err.println("\nWARNING:\t" + ((DevFailed)e).errors[0].desc);
            }
            System.err.println("\nWARNING:\t" + e);
        }
    }

    public void updateSitePropertyFile() throws DevFailed {
        URL url = this.getClass().getResource(sitePropFilename);
        if (url == null) {
            Except.throw_exception("LOAD_PROPERTY_FAILED", "URL for property file (/Pogo.site_properties) is null !", "PogoProperty.loadProperties()");
            return;
        }
        String filename = url.toString();
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
        }
        String code = ParserTool.readFile(filename);
        boolean writeIt = false;
        int start = code.indexOf(siteNameProp);
        if (start > 0) {
            start = code.indexOf(58, start) + 1;
            int end = code.indexOf(10, start);
            code = String.valueOf(code.substring(0, start)) + "  " + (siteName == null ? "" : siteName) + code.substring(end);
            writeIt = true;
        }
        if ((start = code.indexOf(siteClassFamiliesProp)) > 0) {
            StringBuilder indent = new StringBuilder();
            int i = 0;
            while (i < siteClassFamiliesProp.length() + packname.length() + 3) {
                indent.append(' ');
                ++i;
            }
            StringBuilder sb = new StringBuilder("  ");
            for (String family : siteClassFamilies) {
                sb.append(family).append('\n').append((CharSequence)indent);
            }
            String property = "  " + sb.toString().trim() + '\n';
            start = code.indexOf(58, start) + 1;
            int end = code.indexOf(35, start);
            code = String.valueOf(code.substring(0, start)) + property + code.substring(end);
            writeIt = true;
        }
        if (writeIt) {
            System.out.println("writing  " + filename);
            ParserTool.writeFile(filename, code);
        }
    }

    public static void main(String[] args) {
        try {
            PogoProperty.init().displayProperties();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

