/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.Tango.DevFailed;
import java.util.StringTokenizer;
import org.tango.pogo.pogo_gui.tools.ParserTool;

public class PogoParser {
    private String fileCode;
    private String filename;
    static final String start_protected = "PROTECTED REGION ID(";
    static final String start_protected_enabled = "ENABLED START";
    static final String end_protected = "PROTECTED REGION END";

    public PogoParser(String filename) throws DevFailed {
        this.filename = filename;
        this.fileCode = ParserTool.readFile(filename);
    }

    public void write() throws DevFailed {
        ParserTool.writeFile(this.filename, this.fileCode);
    }

    public boolean codeExists(String code) {
        return this.fileCode.indexOf(code) >= 0;
    }

    public void insertInProtectedZone(String classname, String method, String code) {
        int[] indexes;
        if (code == null || code.length() == 0) {
            return;
        }
        String this_protected = start_protected;
        if (classname != null && classname.length() > 0) {
            this_protected = String.valueOf(this_protected) + classname + "::";
        }
        if ((indexes = this.indexesOfProtectedZone(this_protected = String.valueOf(this_protected) + method + ") " + start_protected_enabled)) != null) {
            StringBuffer sb = new StringBuffer(this.fileCode.substring(0, indexes[1]).trim());
            sb.append('\n');
            sb.append(code);
            sb.append('\n');
            sb.append(this.fileCode.substring(indexes[1]));
            this.fileCode = sb.toString();
        } else {
            System.err.println(String.valueOf(this_protected) + " not found");
        }
    }

    public void insertInProtectedZoneAtEnd(String classname, String method, String code) {
        if (code == null || code.length() == 0) {
            return;
        }
        String this_protected = start_protected + classname + "::" + method + ") " + start_protected_enabled;
        int[] indexes = this.indexesOfProtectedZone(this_protected);
        if (indexes != null) {
            int pos = indexes[1];
            if (pos > 0) {
                StringBuffer sb = new StringBuffer(this.fileCode.substring(0, pos));
                sb.append('\n');
                sb.append(code);
                sb.append('\n');
                sb.append(this.fileCode.substring(indexes[1]));
                this.fileCode = sb.toString();
            }
        } else {
            System.err.println(String.valueOf(this_protected) + " not found");
        }
    }

    public void removeProtectedZone(String classname, String method) {
        String this_protected = start_protected + classname + "::" + method + ") " + start_protected_enabled;
        int[] indexes = this.indexesOfProtectedZone(this_protected);
        if (indexes != null) {
            StringBuffer sb = new StringBuffer(this.fileCode.substring(0, indexes[0]));
            sb.append(this.fileCode.substring(indexes[1]));
            this.fileCode = sb.toString();
        } else {
            System.err.println(String.valueOf(this_protected) + " not found");
        }
    }

    public void removeProtectedZoneAtEnd(String classname, String method, String start_rem) {
        String this_protected = start_protected + classname + "::" + method + ") " + start_protected_enabled;
        int[] indexes = this.indexesOfProtectedZone(this_protected);
        if (indexes != null) {
            int pos = this.fileCode.indexOf(start_rem, indexes[0]);
            if (pos > 0) {
                StringBuffer sb = new StringBuffer(this.fileCode.substring(0, pos));
                sb.append(this.fileCode.substring(indexes[1]));
                this.fileCode = sb.toString();
            }
        } else {
            System.err.println(String.valueOf(this_protected) + " not found");
        }
    }

    public void insertIncludeFiles(String code) {
        int start = this.fileCode.indexOf("#include");
        int end = this.fileCode.indexOf(end_protected, start);
        end = this.fileCode.lastIndexOf(10, end);
        StringBuffer sb = new StringBuffer(this.fileCode.substring(0, start));
        sb.append(code);
        sb.append(this.fileCode.substring(end));
        this.fileCode = sb.toString();
    }

    public void insertAdditionalMethodPrototypes(String classname, String code) {
        this.insertInProtectedZone(classname, "Additional Method prototypes", code);
    }

    public void insertAdditionalClasses(String classname, String code) {
        this.insertInProtectedZone(classname, "Additional Classes Definitions", code);
    }

    public void insertAdditionalClassDefs(String classname, String code) {
        this.insertInProtectedZone(classname, "Additional Class Declarations", code);
    }

    public void addObjFiles(String objFiles) throws DevFailed {
        if (this.fileCode.indexOf(objFiles) > 0) {
            return;
        }
        int start = this.fileCode.indexOf("SHLIB_OBJS =");
        if (start < 0) {
            return;
        }
        start = this.fileCode.substring(0, start).trim().length();
        this.fileCode = String.valueOf(this.fileCode.substring(0, start)) + objFiles + this.fileCode.substring(start);
        this.write();
    }

    private int[] indexesOfProtectedZone(String this_protected) {
        int start = this.fileCode.indexOf(this_protected);
        if (start < 0) {
            System.err.println(String.valueOf(this_protected) + " not found !");
            return null;
        }
        int end = this.fileCode.indexOf(end_protected, start = this.fileCode.indexOf(10, start) + 1);
        if (end < 0) {
            System.err.println("No end of protected zone for " + this_protected + " not found !");
            return null;
        }
        end = this.fileCode.lastIndexOf(10, end);
        return new int[]{start, end};
    }

    public String getProtectedCode(String key) {
        String this_protected = start_protected + key + ") " + start_protected_enabled;
        int[] indexes = this.indexesOfProtectedZone(this_protected);
        if (indexes == null) {
            return "";
        }
        String code = this.fileCode.substring(indexes[0], indexes[1]);
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(code, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.length() > 0) {
                sb.append(line);
            }
            if (!st.hasMoreTokens()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getDeletedObjectsCode(String comment) {
        int start = this.fileCode.lastIndexOf(comment);
        if (start > 0) {
            start = this.fileCode.lastIndexOf("/**", start);
            start = this.fileCode.lastIndexOf("//", start);
            int end = this.fileCode.indexOf(end_protected, start);
            end = this.fileCode.indexOf("}", end);
            end = this.fileCode.indexOf("\n", end) + 1;
            return this.commentCode(this.fileCode.substring(start, end));
        }
        System.out.println(String.valueOf(comment) + "\tNOT FOUND !!!");
        return null;
    }

    private String commentCode(String code) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(code, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.indexOf(start_protected) >= 0 || line.indexOf(end_protected) >= 0) continue;
            sb.append("// ").append(line).append("\n");
        }
        return sb.toString();
    }

    public void insertDeletedObjectsCode(String code) {
        int pos = this.fileCode.lastIndexOf(end_protected);
        pos = this.fileCode.lastIndexOf("\n", pos);
        this.fileCode = String.valueOf(this.fileCode.substring(0, pos)) + code + this.fileCode.substring(pos);
    }

    public String toString() {
        return this.fileCode;
    }
}

