/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoEditor {
    private static PogoEditor instance = null;
    private static String editor = null;
    private static final String[] exeFiles = new String[]{"nedit-client", "nedit-nc", "nc"};

    public static PogoEditor getInstance() {
        if (instance == null) {
            instance = new PogoEditor();
        }
        return instance;
    }

    private PogoEditor() {
        String os = System.getProperty("os.name");
        System.out.println("Running under " + os);
        if (!os.toLowerCase().startsWith("windows")) {
            String path = System.getenv("PATH");
            StringTokenizer stk = new StringTokenizer(path, ":");
            ArrayList<String> lines = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                lines.add(stk.nextToken());
            }
            String[] stringArray = exeFiles;
            int n = exeFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String exeFile = stringArray[n2];
                editor = this.getEditorExeFile(exeFile, lines);
                if (editor != null) break;
                ++n2;
            }
            if (editor != null) {
                System.out.println("using " + editor + " editor");
            } else {
                System.out.println("no editor available.");
            }
        }
    }

    private String getEditorExeFile(String exeFile, ArrayList<String> lines) {
        for (String line : lines) {
            String filename = String.valueOf(line) + "/" + exeFile;
            if (!new File(filename).exists()) continue;
            return filename;
        }
        return null;
    }

    public boolean isAvailable() {
        return editor != null;
    }

    private int getLineNumber(String filename, String signature) {
        int end;
        String code = "";
        try {
            code = ParserTool.readFile(filename);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, e);
        }
        int start = 0;
        int idx = 0;
        while ((end = code.indexOf(10, start)) > 0) {
            String line = code.substring(start, end);
            if (line.contains(signature)) {
                return idx + 1;
            }
            start = end + 1;
            ++idx;
        }
        System.out.println(String.valueOf(signature) + " not found !");
        return -1;
    }

    private int getLineNumber(String filename, String classname, int lang, Property prop, boolean is_dev) {
        String signature = null;
        switch (lang) {
            case 1: {
                signature = "void " + classname;
                if (!is_dev) {
                    signature = String.valueOf(signature) + "Class";
                }
                signature = String.valueOf(signature) + "::get_";
                signature = is_dev ? String.valueOf(signature) + "device" : String.valueOf(signature) + "class";
                signature = String.valueOf(signature) + "_property(";
            }
        }
        if (signature == null) {
            return -1;
        }
        return this.getLineNumber(filename, signature);
    }

    private int getLineNumber(String filename, String classname, int lang, Command cmd) {
        String signature = null;
        switch (lang) {
            case 1: {
                signature = String.valueOf(classname) + "::" + cmd.getExecMethod() + "(";
            }
        }
        if (signature == null) {
            return -1;
        }
        return this.getLineNumber(filename, signature);
    }

    private int getLineNumber(String filename, String classname, int lang, Attribute attribute) {
        String signature = null;
        switch (lang) {
            case 1: {
                signature = String.valueOf(classname) + "::read_" + attribute.getName() + "(Tango::Attribute &attr)";
            }
        }
        if (signature == null) {
            return -1;
        }
        return this.getLineNumber(filename, signature);
    }

    private int getLineNumber(String filename, String classname, int lang) {
        String signature = null;
        switch (lang) {
            case 1: {
                signature = "namespace " + classname + "_ns";
            }
        }
        if (signature == null) {
            return -1;
        }
        return this.getLineNumber(filename, signature);
    }

    public void editFile(String[] data, Property prop, boolean is_dev) throws IOException {
        if (editor == null) {
            System.err.println("no editor available.");
            return;
        }
        String classname = data[0];
        String path = data[1];
        int lang = Utils.getLanguage(data[2]);
        String filename = null;
        switch (lang) {
            case 1: {
                filename = is_dev ? String.valueOf(path) + "/" + classname + ".cpp" : String.valueOf(path) + "/" + classname + "Class.cpp";
            }
        }
        if (filename != null) {
            int linenum = this.getLineNumber(filename, classname, lang, prop, is_dev);
            this.startEditor(filename, linenum);
        }
    }

    public void editFile(String[] data, Attribute attribute) throws IOException {
        if (editor == null) {
            System.err.println("no editor available.");
            return;
        }
        String classname = data[0];
        String path = data[1];
        int lang = Utils.getLanguage(data[2]);
        String filename = null;
        switch (lang) {
            case 1: {
                filename = String.valueOf(path) + "/" + classname + ".cpp";
            }
        }
        if (filename != null) {
            int linenum = this.getLineNumber(filename, classname, lang, attribute);
            this.startEditor(filename, linenum);
        }
    }

    public void editFile(String[] data, Command cmd) throws IOException {
        if (editor == null) {
            System.err.println("no editor available.");
            return;
        }
        String classname = data[0];
        String path = data[1];
        int lang = Utils.getLanguage(data[2]);
        String filename = null;
        switch (lang) {
            case 1: {
                filename = String.valueOf(path) + "/" + classname + ".cpp";
            }
        }
        if (filename != null) {
            int linenum = this.getLineNumber(filename, classname, lang, cmd);
            this.startEditor(filename, linenum);
        }
    }

    public void editFile(String[] data, State state) throws IOException {
        if (editor == null) {
            System.err.println("no editor available.");
            return;
        }
        String classname = data[0];
        String path = data[1];
        int lang = Utils.getLanguage(data[2]);
        String filename = null;
        switch (lang) {
            case 1: {
                filename = String.valueOf(path) + "/" + classname + "StateMachine.cpp";
            }
        }
        if (filename != null) {
            int linenum = this.getLineNumber(filename, classname, lang);
            this.startEditor(filename, linenum);
        }
    }

    private void startEditor(String filename, int linenum) throws IOException {
        if (linenum >= 0) {
            String shell_cmd = String.valueOf(editor) + " -noask -line " + linenum + " " + filename;
            Utils.executeShellCmdAndReturn(shell_cmd);
        }
    }
}

