/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoConfiguration
extends JDialog {
    private int retVal = 2;
    private ArrayList<String> families;
    private JList familyList;
    private JTextField siteLabel;
    private JLabel titleLabel;

    public PogoConfiguration(JFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.titleLabel.setToolTipText(Utils.buildToolTip("Class Families", "If you use your own repository with specific class families\nAdd your  institute name on right fields\n&nbsp; &nbsp; and the specific family names below.\nIt will ne used for Class Identification Window."));
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.siteLabel = new JTextField();
        JLabel jLabel1 = new JLabel();
        JButton helpBtn = new JButton();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel rightPanel = new JPanel();
        JButton addBtn = new JButton();
        JButton removeBtn = new JButton();
        JScrollPane familyScrollPane = new JScrollPane();
        this.familyList = new JList();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PogoConfiguration.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 14));
        this.titleLabel.setText("Specific Class Family Names for  ");
        topPanel.add(this.titleLabel);
        this.siteLabel.setColumns(10);
        this.siteLabel.setFont(new Font("Dialog", 1, 14));
        topPanel.add(this.siteLabel);
        jLabel1.setText("        ");
        topPanel.add(jLabel1);
        helpBtn.setText("?");
        helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.helpBtnActionPerformed(evt);
            }
        });
        topPanel.add(helpBtn);
        this.getContentPane().add((Component)topPanel, "North");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        rightPanel.setLayout(new GridBagLayout());
        addBtn.setText("Add");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.addBtnActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(60, 0, 5, 0);
        rightPanel.add((Component)addBtn, gridBagConstraints);
        removeBtn.setText("Remove");
        removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.removeBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        rightPanel.add((Component)removeBtn, gridBagConstraints);
        this.getContentPane().add((Component)rightPanel, "After");
        familyScrollPane.setPreferredSize(new Dimension(300, 360));
        familyScrollPane.setViewportView(this.familyList);
        this.getContentPane().add((Component)familyScrollPane, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            PogoProperty.siteName = this.siteLabel.getText();
            PogoProperty.getInstance().updateSitePropertyFile();
            this.retVal = 0;
            this.doClose();
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        String new_family = "";
        boolean ok = false;
        while (!ok) {
            if ((new_family = (String)JOptionPane.showInputDialog(this, "Family Name ", "Input Dialog", 1, null, null, new_family)) == null || new_family.length() == 0) {
                return;
            }
            boolean found = false;
            for (String family : this.families) {
                if (!family.toLowerCase().equals(new_family.toLowerCase())) continue;
                found = true;
            }
            if (found) {
                Utils.popupError(this, String.valueOf(new_family) + " family  already exists");
                continue;
            }
            ok = true;
        }
        this.families.add(new_family);
        MyCompare compare = new MyCompare();
        Collections.sort(this.families, compare);
        this.setFamilyList();
    }

    private void setFamilyList() {
        Vector<String> vs = new Vector<String>();
        for (String family : this.families) {
            vs.add(family);
        }
        this.familyList.setListData(vs);
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        Object[] selections = this.familyList.getSelectedValues();
        if (selections.length > 0) {
            Object[] objectArray = selections;
            int n = selections.length;
            int n2 = 0;
            while (n2 < n) {
                Object selection = objectArray[n2];
                String name = (String)selection;
                for (String family : this.families) {
                    if (!family.equals(name)) continue;
                    this.families.remove(family);
                    break;
                }
                ++n2;
            }
            this.setFamilyList();
        } else {
            JOptionPane.showMessageDialog(this, "Nothing selected to be removed !", "Error Window", 0);
        }
    }

    private void helpBtnActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(new JFrame(), "If you use your own repository with specific class families,\nentre your site name and use the list to add or remove your \nspecific families.", "Help Window", 1);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void manageFamilyList() throws DevFailed {
        this.siteLabel.setText(PogoProperty.siteName);
        this.families = PogoProperty.siteClassFamilies;
        this.setFamilyList();
        this.pack();
    }

    public int showDialog() {
        try {
            this.manageFamilyList();
            this.setVisible(true);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, e);
        }
        return this.retVal;
    }

    public static void main(String[] args) {
        try {
            new PogoConfiguration(new JFrame()).showDialog();
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, e);
            System.exit(0);
        }
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                String s1 = o1.toString().toLowerCase();
                String s2 = o2.toString().toLowerCase();
                if (s1.equals("miscellaneous")) {
                    return 0;
                }
                if (s2.equals("miscellaneous")) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

