/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.tango.pogo.pogo_gui.tools.Utils;

public class ParserTool {
    public static String readFile(String filename) throws DevFailed {
        String str = "";
        try {
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            nb = fid.read(inStr);
            fid.close();
            if (nb > 0) {
                str = ParserTool.takeOffWindowsChar(inStr);
            }
        }
        catch (Exception e) {
            Except.throw_exception("READ_FAILED", e.toString(), "ParserTool.readFile()");
        }
        return str;
    }

    private static String takeOffWindowsChar(byte[] b_in) {
        int nb = 0;
        byte[] byArray = b_in;
        int n = b_in.length;
        int n2 = 0;
        while (n2 < n) {
            byte b2 = byArray[n2];
            if (b2 != 13) {
                ++nb;
            }
            ++n2;
        }
        byte[] b_out = new byte[nb];
        int i = 0;
        int j = 0;
        while (i < b_in.length) {
            if (b_in[i] != 13) {
                b_out[j++] = b_in[i];
            }
            ++i;
        }
        return new String(b_out);
    }

    private static String checkOsFormat(String code) {
        if (!Utils.osIsUnix()) {
            return ParserTool.setWindowsFileFormat(code);
        }
        return code;
    }

    public static String setWindowsFileFormat(String code) {
        byte[] b2 = new byte[]{13, 10};
        String lsp = new String(b2);
        code = code.replaceAll("\n", lsp);
        return code;
    }

    public static void writeFile(String filename, String code) throws DevFailed {
        try {
            code = ParserTool.checkOsFormat(code);
            FileOutputStream fidout = new FileOutputStream(filename);
            fidout.write(code.getBytes());
            fidout.close();
        }
        catch (Exception e) {
            Except.throw_exception("WRITE_FAILED", e.toString(), "ParserTool.readFile()");
        }
    }

    public static void modifyProtectedAreaID(String path, String fileName, String oldID, String newID) throws DevFailed {
        String code;
        oldID = "PROTECTED REGION ID(" + oldID + ") ENABLED START";
        newID = "PROTECTED REGION ID(" + newID + ") ENABLED START";
        try {
            code = ParserTool.readFile(String.valueOf(path) + '/' + fileName);
        }
        catch (DevFailed e) {
            return;
        }
        int start = code.indexOf(oldID);
        if (start < 0) {
            return;
        }
        int end = start + oldID.length();
        String newCode = String.valueOf(code.substring(0, start)) + newID + code.substring(end);
        ParserTool.writeFile(String.valueOf(path) + '/' + fileName, newCode);
    }

    public static void convertHTML(String filename) throws DevFailed {
        try {
            int end;
            String code = ParserTool.readFile(filename);
            StringBuffer sb = new StringBuffer();
            int start = 0;
            while ((end = code.indexOf("\"", start + 1)) > 0) {
                sb.append(code.substring(start, end)).append("\\");
                start = end;
            }
            sb.append(code.substring(start));
            code = sb.toString();
            sb = new StringBuffer("\"");
            start = 0;
            while ((end = code.indexOf("\n", start)) > 0) {
                sb.append(code.substring(start, end)).append("\\n\" + \n\"");
                start = end + 1;
            }
            sb.append(code.substring(start)).append("\\n\"");
            code = sb.toString();
            System.out.println(code);
        }
        catch (Exception e) {
            Except.throw_exception("READ_FAILED", e.toString(), "ParserTool.readFile()");
        }
    }

    public static void displaySyntax() {
        System.out.println("ParserTool <option> <filename>");
        System.out.println("    option: -html  convert html file to java String");
        System.exit(0);
    }

    public static void removeXmiKey(String key, String fileName) throws DevFailed {
        boolean modified = false;
        key = " " + key + "=\"";
        String code = ParserTool.readFile(fileName);
        StringTokenizer stk = new StringTokenizer(code, "\n");
        ArrayList<String> v = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            int start = line.indexOf(key);
            if (start > 0) {
                int end = line.indexOf("\"", start + key.length());
                if (end < 0) {
                    System.err.println("XMI syntax error !!!");
                    return;
                }
                line = String.valueOf(line.substring(0, start)) + line.substring(end + 1);
                modified = true;
            }
            v.add(line);
        }
        if (modified) {
            StringBuilder sb = new StringBuilder();
            for (String s : v) {
                sb.append(s).append("\n");
            }
            code = sb.toString();
            code = code.substring(0, code.length() - 1);
            ParserTool.writeFile(fileName, code);
        }
    }

    public static void renameXmiKey(String srcKey, String newKey, String fileName) throws DevFailed {
        boolean modified = false;
        srcKey = " " + srcKey + "=";
        String code = ParserTool.readFile(fileName);
        StringTokenizer stk = new StringTokenizer(code, "\n");
        ArrayList<String> v = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            int start = line.indexOf(srcKey);
            if (start > 0) {
                int end = start + srcKey.length();
                if (end < 0) {
                    System.err.println("XMI syntax error !!!");
                    return;
                }
                line = String.valueOf(line.substring(0, ++start)) + newKey + line.substring(--end);
                modified = true;
            }
            v.add(line);
        }
        if (modified) {
            StringBuilder sb = new StringBuilder();
            for (String s : v) {
                sb.append(s).append("\n");
            }
            code = sb.toString();
            code = code.substring(0, code.length() - 1);
            ParserTool.writeFile(fileName, code);
        }
    }

    public static void convertProtectedAreaKey(String srcKey, String newKey, String fileName) throws DevFailed {
        int endLine;
        boolean modified = false;
        String code = ParserTool.readFile(fileName);
        ArrayList<String> lines = new ArrayList<String>();
        int startLine = 0;
        while ((endLine = code.indexOf(10, startLine)) > 0) {
            int start;
            String line = code.substring(startLine, endLine);
            if (line.contains(" PROTECTED REGION ") && (start = line.indexOf(srcKey)) > 0) {
                int end = start + srcKey.length();
                line = String.valueOf(line.substring(0, start)) + newKey + line.substring(end);
                modified = true;
            }
            lines.add(line);
            startLine = endLine + 1;
        }
        lines.add(code.substring(startLine));
        if (modified) {
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            ParserTool.writeFile(fileName, sb.toString().trim());
            System.out.println("Replaced \"" + srcKey + "\"  by  \"" + newKey + "\" \t in " + fileName);
        }
    }

    public static void convertProtectedAreaKeyForStateMachine(ArrayList<String> attributeNames, String fileName) throws DevFailed {
        int endLine;
        boolean modified = false;
        String code = ParserTool.readFile(fileName);
        ArrayList<String> lines = new ArrayList<String>();
        int startLine = 0;
        while ((endLine = code.indexOf(10, startLine)) > 0) {
            String line = code.substring(startLine, endLine);
            if (line.contains(" PROTECTED REGION ")) {
                for (String attributeName : attributeNames) {
                    String srcKey = "read_" + attributeName + "StateAllowed";
                    int start = line.indexOf(srcKey);
                    if (start <= 0) continue;
                    int end = start + srcKey.length();
                    String newKey = String.valueOf(attributeName) + "StateAllowed";
                    line = String.valueOf(line.substring(0, start)) + newKey + line.substring(end);
                    modified = true;
                }
            }
            lines.add(line);
            startLine = endLine + 1;
        }
        lines.add(code.substring(startLine));
        if (modified) {
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            ParserTool.writeFile(fileName, sb.toString().trim());
            System.out.println("Replaced protected region keys in " + fileName);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length >= 2) {
                if (args[0].equals("-html")) {
                    ParserTool.convertHTML(args[1]);
                } else {
                    args[0].equals("-xmi-clean");
                }
            } else if (args.length == 1) {
                if (args[0].equals("-pr")) {
                    String fileName = "/segfs/tango/tools/pogo/test/cpp/test_oaw-1/starter/StarterClass.cpp";
                    String srcKey = "Starter::Class::";
                    String newKey = "StarterClass::";
                    ParserTool.convertProtectedAreaKey(srcKey, newKey, fileName);
                    fileName = "/segfs/tango/tools/pogo/test/cpp/test_oaw-1/starter/StarterClass.h";
                    srcKey = "Starter::";
                    newKey = "StarterClass::";
                    ParserTool.convertProtectedAreaKey(srcKey, newKey, fileName);
                }
            } else {
                ParserTool.displaySyntax();
            }
        }
        catch (DevFailed e) {
            Except.print_exception_stack(e);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

