/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.IOException;
import java.util.ArrayList;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoException;

public class OldModelParser {
    private String fileCode;
    private PogoClass pogo_class;
    private ArrayList<String> methods = new ArrayList();
    private ArrayList<String> signatures = new ArrayList();
    private static final String[] cpp_constructors = new String[]{"(Tango::DeviceClass *cl,string &s)", "(Tango::DeviceClass *cl,const char *s)", "(Tango::DeviceClass *cl,const char *s,const char *d)"};
    private static final String[] cpp_expected_sig = new String[]{"void ::delete_device()", "void ::init_device()", "void ::get_device_property()", "void ::always_executed_hook()", "void ::read_attr_hardware(vector<long> &attr_list)"};

    public OldModelParser(String filename) throws SecurityException, IOException, DevFailed {
        try {
            this.pogo_class = new PogoClass(filename);
        }
        catch (PogoException e) {
            Except.throw_exception("PogoException", e.toString(), "OldModelParser::OldModelParser");
        }
        this.initialize(filename);
    }

    public OldModelParser(String filename, PogoClass pogo_class) throws SecurityException, IOException, DevFailed {
        this.pogo_class = pogo_class;
        this.initialize(filename);
    }

    private void initialize(String filename) throws SecurityException, IOException, DevFailed {
        this.fileCode = ParserTool.readFile(filename);
        int start = this.fileCode.indexOf("namespace ");
        if (filename.endsWith("main.cpp") || filename.endsWith(".html")) {
            return;
        }
        if (start < 0) {
            Except.throw_exception("BAD_SYNTAX", "namespace not found in " + filename, "OldModelParser::OldModelParser");
        }
        if ((start = this.fileCode.indexOf("{", start) + 2) < 0) {
            Except.throw_exception("BAD_SYNTAX", "Namespace not found", "OldModelParser::OldModelParser");
        }
        this.parseMethodCode(start);
    }

    public String getCode() {
        return this.fileCode;
    }

    private void parseMethodCode(int start) {
        int pos;
        while ((pos = this.fileCode.indexOf("{", start)) > 0) {
            ++pos;
            int cnt = 1;
            while (cnt > 0) {
                if (this.fileCode.charAt(pos) == '{') {
                    ++cnt;
                } else if (this.fileCode.charAt(pos) == '}') {
                    --cnt;
                }
                ++pos;
            }
            String method = this.fileCode.substring(start, pos).trim();
            this.methods.add(method);
            String sig = this.getMethodSignature(method);
            this.signatures.add(sig);
            start = pos;
        }
    }

    private String getMethodSignature(String method) {
        int pos;
        int end = method.indexOf("{");
        String signature = method.substring(0, end);
        int start = 0;
        int previous = -1;
        while ((pos = signature.indexOf("//", start)) >= 0 && start > previous) {
            previous = start;
            start = signature.indexOf("\n", pos) + 1;
        }
        signature = signature.substring(start);
        start = 0;
        while ((pos = signature.indexOf("/*", start)) >= 0) {
            start = signature.indexOf("*/", pos) + 2;
        }
        signature = signature.substring(start);
        return signature.trim();
    }

    private String getCode(int methnum) {
        String method = this.methods.get(methnum);
        int start = method.indexOf("{") + 1;
        int end = method.lastIndexOf("}");
        return method.substring(start, end).trim();
    }

    public ArrayList<String> getMethodSignatures() {
        return this.signatures;
    }

    public String getMethodCode(String in_signature) {
        int i = 0;
        while (i < this.signatures.size()) {
            String signature = this.signatures.get(i);
            if (signature.equals(in_signature.trim())) {
                return this.getCode(i);
            }
            ++i;
        }
        return null;
    }

    public String getMethod(String in_signature) {
        int i = 0;
        while (i < this.signatures.size()) {
            String signature = this.signatures.get(i);
            if (signature.equals(in_signature.trim())) {
                System.out.println("inserting code for " + in_signature);
                return this.methods.get(i);
            }
            ++i;
        }
        return null;
    }

    private String getExpectedSig(int i) {
        int pos = cpp_expected_sig[i].indexOf("::");
        return String.valueOf(cpp_expected_sig[i].substring(0, pos)) + this.pogo_class.class_name + cpp_expected_sig[i].substring(pos);
    }

    private boolean isCommandMethod(String signature) {
        int i = 0;
        while (i < this.pogo_class.commands.size()) {
            Cmd cmd = this.pogo_class.commands.cmdAt(i);
            String meth_sig = cmd.buildCppExecCmdMethodSignature(this.pogo_class.class_name);
            if (meth_sig.equals(signature)) {
                return true;
            }
            int pos = meth_sig.indexOf("argin");
            if (pos > 0 && signature.startsWith(meth_sig = meth_sig.substring(0, pos))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAttributeMethod(String signature) {
        boolean expected = false;
        int i = 0;
        while (i < this.pogo_class.attributes.size()) {
            Attrib att = this.pogo_class.attributes.attributeAt(i);
            String meth_sig = "void " + this.pogo_class.class_name + "::" + "read_" + att.name + "(Tango::Attribute &attr)";
            if (meth_sig.equals(signature)) {
                expected = true;
            } else {
                meth_sig = "void " + this.pogo_class.class_name + "::" + "write_" + att.name + "(Tango::WAttribute &attr)";
                if (meth_sig.equals(signature)) {
                    expected = true;
                }
            }
            ++i;
        }
        return expected;
    }

    private boolean isExpected(String signature) {
        boolean expected = false;
        int i = 0;
        while (i < cpp_expected_sig.length) {
            String exp_sig = this.getExpectedSig(i);
            if (exp_sig.equals(signature)) {
                expected = true;
            }
            ++i;
        }
        if (!expected) {
            if (this.isCommandMethod(signature)) {
                expected = true;
            } else if (this.isAttributeMethod(signature)) {
                expected = true;
            }
        }
        return expected;
    }

    private boolean isConstructor(String meth_sig) {
        String header = String.valueOf(this.pogo_class.class_name) + "::" + this.pogo_class.class_name;
        String[] stringArray = cpp_constructors;
        int n = cpp_constructors.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (meth_sig.startsWith(String.valueOf(header) + str)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getUnexpectedMethods() {
        StringBuffer sb = new StringBuffer();
        for (String sig : this.signatures) {
            if (this.isConstructor(sig) || this.isExpected(sig)) continue;
            sb.append(this.getMethod(sig)).append("\n");
        }
        return sb.toString();
    }

    public String getIncludeFiles() {
        int start;
        int end = 0;
        StringBuffer sb = new StringBuffer();
        while ((start = this.fileCode.indexOf("#include", end)) > 0) {
            end = this.fileCode.indexOf(10, start) + 1;
            int start0 = this.fileCode.lastIndexOf(10, start - 1);
            if (this.fileCode.substring(start0 = this.fileCode.lastIndexOf(10, start0 - 1) + 1).startsWith("#ifdef")) {
                start = start0;
            }
            if (this.fileCode.substring(end).startsWith("#endif")) {
                end = this.fileCode.indexOf(10, end) + 1;
            }
            sb.append(this.fileCode.substring(start, end));
        }
        return sb.toString();
    }

    public String getDefinitions() {
        int start = this.fileCode.indexOf("Add your own constant");
        if (start < 0) {
            return null;
        }
        start = this.fileCode.indexOf(10, start) + 1;
        start = this.fileCode.indexOf(10, start) + 1;
        int end = this.fileCode.indexOf("namespace", start);
        return this.fileCode.substring(start, end);
    }

    public String getDataMembers() {
        int start = this.fileCode.indexOf("Add your own data members here");
        if (start < 0) {
            return null;
        }
        start = this.fileCode.indexOf(10, start) + 1;
        start = this.fileCode.indexOf(10, start) + 1;
        int end = this.fileCode.indexOf("Here is the Start of the automatic code generation part", start);
        end = this.fileCode.lastIndexOf(10, end);
        return this.fileCode.substring(start, end);
    }

    public String getAdditionalMethodPrototypes() {
        int start = this.fileCode.indexOf("Here is the end of the automatic code generation part");
        if (start < 0) {
            return null;
        }
        start = this.fileCode.indexOf(10, start) + 1;
        start = this.fileCode.indexOf(10, start) + 1;
        int end = this.fileCode.indexOf("};", start);
        String code = this.fileCode.substring(start, end);
        if ((start = code.indexOf("Add your own data members here")) > 0) {
            start = code.lastIndexOf(10, start) + 1;
            StringBuffer sb = new StringBuffer(code.substring(0, start));
            start = code.indexOf(10, start) + 1;
            start = code.indexOf(10, start) + 1;
            sb.append(code.substring(start));
            code = sb.toString();
        }
        return code.trim();
    }

    public String getAdditionalClassDeclarations() {
        int start = this.fileCode.indexOf("namespace " + this.pogo_class.class_name + "_ns");
        if (start < 0) {
            return null;
        }
        start = this.fileCode.indexOf("{", start) + 2;
        int end = this.fileCode.indexOf("class " + this.pogo_class.class_name + ":");
        String code = this.fileCode.substring(start, end);
        if ((start = code.indexOf("Class Description")) > 0) {
            start = code.lastIndexOf("/*", start);
            end = code.indexOf("*/", start);
            end = code.indexOf("\n", end) + 1;
            code = String.valueOf(code.substring(0, start)) + code.substring(end);
        }
        if ((start = code.indexOf("States Description")) > 0) {
            start = code.lastIndexOf("/*", start);
            end = code.indexOf("*/", start);
            end = code.indexOf("\n", end) + 1;
            code = String.valueOf(code.substring(0, start)) + code.substring(end);
        }
        return code.trim();
    }

    public String getAdditionalClasses() {
        int end;
        int start = this.fileCode.indexOf("Here is the end of the automatic code generation part");
        if (start < 0) {
            return null;
        }
        boolean found = false;
        while (!found && (end = this.fileCode.indexOf("\n", start)) > 0) {
            String line = this.fileCode.substring(start, end);
            if (line.trim().equals("};")) {
                start += line.length() + 1;
                found = true;
                continue;
            }
            start = end + 1;
        }
        if (!found) {
            return null;
        }
        end = this.fileCode.indexOf("namespace", start);
        end = this.fileCode.lastIndexOf("\n", end) + 1;
        String code = this.fileCode.substring(start, end);
        return code.trim();
    }

    public String manageWriteValue(String code, String attName) {
        if (code != null) {
            int end;
            String oldVar = "attr_" + attName + "_write";
            String newVar = "w_val";
            int start = code.indexOf("attr.get_write_value(" + oldVar);
            if (start >= 0) {
                end = code.indexOf(10, start);
                if ((start = code.lastIndexOf(10, start)) < 0) {
                    start = 0;
                }
                code = String.valueOf(code.substring(0, start)) + code.substring(end + 1);
            }
            while ((start = code.indexOf(oldVar)) > 0) {
                end = start + oldVar.length();
                code = String.valueOf(code.substring(0, start)) + newVar + code.substring(end);
            }
        }
        return code;
    }

    public String getCppMethodCode(String signature) {
        String code = null;
        int i = 0;
        while (i < this.signatures.size()) {
            int start = signature.indexOf("argin");
            if (start > 0) {
                signature = signature.substring(0, start);
            }
            if (this.signatures.get(i).startsWith(signature)) {
                int end;
                code = this.methods.get(i);
                start = code.indexOf(signature);
                if ((code = code.substring(start = code.indexOf("{", start) + 1, end = code.lastIndexOf("}")).trim()).startsWith("DEBUG_STREAM") || code.startsWith("INFO_STREAM")) {
                    start = code.indexOf(10);
                    if (start < 0) {
                        return null;
                    }
                    code = code.substring(start).trim();
                }
                code = "\t" + code;
            }
            ++i;
        }
        return code;
    }

    public String getCppStaticInit(String classname) {
        String namespace = "namespace " + classname + "_ns";
        int start = this.fileCode.indexOf(namespace);
        if (start < 0) {
            return null;
        }
        start = this.fileCode.indexOf(123, start) + 1;
        int end = this.fileCode.indexOf(String.valueOf(classname) + "::" + classname + "(", start);
        if (end < 0) {
            return null;
        }
        end = this.fileCode.lastIndexOf("//", end);
        end = this.fileCode.lastIndexOf("//", end - 1);
        end = this.fileCode.lastIndexOf("//", end - 1);
        return this.fileCode.substring(start, end).trim();
    }

    public String getCppMethodArginDef(String signature) {
        String code = null;
        int i = 0;
        while (i < this.signatures.size()) {
            int start = signature.indexOf("argin");
            if (start > 0) {
                signature = signature.substring(0, start);
            }
            if (this.signatures.get(i).startsWith(signature)) {
                code = this.methods.get(i);
                start = code.indexOf(signature);
                start = code.indexOf(40, start);
                int end = code.indexOf(41, start);
                code = code.substring(start + 1, end).trim();
            }
            ++i;
        }
        return code;
    }

    public String getHtmlDescripion() {
        int start = this.fileCode.indexOf("Device Description");
        int end = start < 0 ? this.fileCode.toLowerCase().indexOf("</center>\n") : this.fileCode.toLowerCase().indexOf("</center>\n", start);
        if (end < 0) {
            return "";
        }
        start = end + "</center>\n".length();
        end = this.fileCode.toLowerCase().indexOf("</body>\n");
        String code = end < 0 ? this.fileCode.substring(start) : this.fileCode.substring(start, end);
        start = code.indexOf(this.pogo_class.class_desc);
        if (start > 0) {
            code = code.substring(start, this.pogo_class.class_desc.length());
        }
        return code;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.signatures) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    public static void displaySyntax() {
        System.out.println("OldModelParser <filename>");
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            OldModelParser.displaySyntax();
        }
        try {
            OldModelParser parser = new OldModelParser(args[0]);
            String code = parser.getUnexpectedMethods();
            System.out.println(code);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

