/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Comments;
import fr.esrf.tango.pogo.pogoDsl.EventCriteria;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoDslFactory;
import fr.esrf.tango.pogo.pogoDsl.PogoDslPackage;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tango.pogo.pogoDsl.PogoSystem;
import fr.esrf.tango.pogo.pogoDsl.Preferences;
import fr.esrf.tango.pogo.pogoDsl.PropType;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tango.pogo.pogoDsl.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe.core.WorkflowEngine;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PropertyDialog;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class OAWutils {
    private static OAWutils instance = null;
    private static final String backend = "fr/esrf/tango/pogo/backend.mwe";
    public static PogoDslPackage dp = PogoDslPackage.eINSTANCE;
    public static PogoDslFactory factory = PogoDslFactory.eINSTANCE;

    private OAWutils() {
        System.setProperty("file.encoding", "ISO-8859-1");
    }

    public static OAWutils getInstance() {
        if (instance == null) {
            instance = new OAWutils();
        }
        return instance;
    }

    public PogoMultiClasses loadMultiClassesModel(String xmiFile) throws DevFailed {
        Object pogoObj = this.loadTheModel(xmiFile);
        if (!(pogoObj instanceof PogoMultiClasses)) {
            Except.throw_exception("BAD_FILE", "This is not a Pogo Multi Classes file !", "OAWutils.loadModel()");
        }
        PogoMultiClasses pmc = (PogoMultiClasses)pogoObj;
        this.reverseClassOrder(pmc);
        return pmc;
    }

    public PogoDeviceClass loadDeviceClassModel(String xmiFile) throws DevFailed {
        ParserTool.removeXmiKey("htmlInheritance", xmiFile);
        Object pogoObj = this.loadTheModel(xmiFile);
        if (!(pogoObj instanceof PogoDeviceClass)) {
            Except.throw_exception("BAD_FILE", "This is not a Pogo Device Class file !", "OAWutils.loadModel()");
        }
        return (PogoDeviceClass)pogoObj;
    }

    private Object loadTheModel(String xmi) throws DevFailed {
        System.out.println("Loading " + xmi);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createFileURI(new File(xmi).getAbsolutePath());
        Resource resource = new ResourceSetImpl().createResource(fileURI);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            Except.throw_exception("IOException", e.toString(), "DeviceClass.loadModel()");
        }
        PogoSystem sys = (PogoSystem)resource.getContents().get(0);
        if (sys.getMultiClasses().size() > 0) {
            return sys.getMultiClasses().get(0);
        }
        return sys.getClasses().get(0);
    }

    public void generate(PogoDeviceClass pogo_class) throws DevFailed {
        PogoSystem sys = this.buildPogoSystem(pogo_class);
        String prExcludes = pogo_class.getDescription().getLanguage().equals(PogoConst.strLang[0]) ? "org.tango." + pogo_class.getName().toLowerCase() : Utils.getExcludeFilesAndDir(pogo_class.getDescription().getSourcePath());
        String gene = pogo_class.getDescription().getFilestogenerate().toLowerCase();
        String xmiFileName = String.valueOf(pogo_class.getDescription().getSourcePath()) + "/" + pogo_class.getName() + ".xmi";
        int pos = gene.indexOf("xmi");
        if (pos >= 0) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            URI fileURI = URI.createFileURI(new File(xmiFileName).getAbsolutePath());
            Resource resource = resourceSet.createResource(fileURI);
            resource.getContents().add(sys);
            try {
                resource.save(Collections.EMPTY_MAP);
                System.out.println(String.valueOf(xmiFileName) + " generated");
            }
            catch (IOException e) {
                Except.throw_exception("IOException", e.toString(), "DeviceClass.generate()");
            }
            pos = gene.indexOf(",");
            gene = pos < 0 ? "" : gene.substring(pos + 1);
        }
        if (gene.length() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("targetDir", pogo_class.getDescription().getSourcePath());
            params.put("targetLanguage", pogo_class.getDescription().getLanguage());
            params.put("theModel", sys);
            params.put("prExcludes", prExcludes);
            this.runWorkflow(params);
        }
    }

    public void generate(PogoMultiClasses multiClasses) throws DevFailed {
        PogoSystem sys = factory.createPogoSystem();
        String prExcludes = Utils.getExcludeFilesAndDir(multiClasses.getSourcePath());
        this.reverseClassOrder(multiClasses);
        sys.getMultiClasses().add(multiClasses);
        String xmiFileName = String.valueOf(multiClasses.getSourcePath()) + "/" + multiClasses.getName() + ".multi.xmi";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createFileURI(new File(xmiFileName).getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add(sys);
        try {
            resource.save(Collections.EMPTY_MAP);
            System.out.println(String.valueOf(xmiFileName) + " generated");
        }
        catch (IOException e) {
            Except.throw_exception("IOException", e.toString(), "DeviceClass.generate()");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("targetDir", multiClasses.getSourcePath());
        params.put("targetLanguage", "MultiCpp");
        params.put("theModel", sys);
        params.put("prExcludes", prExcludes);
        this.runWorkflow(params);
    }

    private String buildSubDirMessage(String strerror) {
        StringTokenizer st = new StringTokenizer(strerror);
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        if (v.size() == 11) {
            return "XPand cannot generate code !\nDuplicate file Problem:\n\nSame tag      ----- PROTECTED REGION ID(" + (String)v.get(1) + ") -----\n" + "       has been found in:\n" + (String)v.get(5) + "\n" + "       and\n" + (String)v.get(7) + "\n\n" + "Hint: (re)move any duplicate file(s).";
        }
        return "Sub-directory Problem:";
    }

    private void runWorkflow(Map params) throws DevFailed {
        WorkflowEngine runner = new WorkflowEngine();
        boolean configOK = runner.prepare(backend, null, params);
        if (configOK) {
            int lastIdx;
            IssuesImpl issues = new IssuesImpl();
            runner.executeWorkflow(params, issues);
            if (issues.hasWarnings()) {
                MWEDiagnostic[] warn = issues.getWarnings();
                lastIdx = warn.length - 1;
                System.err.println("----------> Message: " + warn[lastIdx].getMessage());
                System.err.println("----------> Element: " + warn[lastIdx].getElement());
            }
            if (issues.hasErrors()) {
                MWEDiagnostic[] errors = issues.getErrors();
                String message = errors[lastIdx = errors.length - 1].getMessage().trim();
                if (message.endsWith("is not unique")) {
                    message = this.buildSubDirMessage(message);
                }
                Except.throw_exception("Running WorkFlow Error", message, "DeviceClass.runWorkFlow() -> " + errors[lastIdx].getElement());
            }
        }
    }

    private void doPreProcessing(PogoDeviceClass pogo_class) throws DevFailed {
        String institute = System.getenv("INSTITUTE");
        if (institute == null) {
            institute = System.getProperty("INSTITUTE");
        }
        if (institute != null) {
            pogo_class.setInstitute(institute.toUpperCase());
        }
        Preferences pref = factory.createPreferences();
        pref.setMakefileHome(PogoProperty.makefileHome);
        pref.setDocHome(PogoProperty.docHome);
        pogo_class.setPreferences(pref);
        String env = System.getenv("Classes2www");
        if (env != null && env.equals("true")) {
            pref.setHtmlVersion("true");
        }
        Comments comments = factory.createComments();
        comments.setCommandsTable(OAWutils.buildCommandsTable(pogo_class));
        pogo_class.getDescription().setComments(comments);
        if (pogo_class.getDescription().getFilestogenerate().toLowerCase().indexOf("code") > 0 && pogo_class.getDescription().getLanguage().toLowerCase().equals("cpp")) {
            ParserTool.modifyProtectedAreaID(pogo_class.getDescription().getSourcePath(), "ClassFactory.cpp", "ClassFactory.cpp", String.valueOf(pogo_class.getName()) + "::ClassFactory.cpp");
        }
        if (pogo_class.getDescription().getFilestogenerate().contains("html")) {
            String filename = String.valueOf(pogo_class.getDescription().getSourcePath()) + "/" + pogo_class.getPreferences().getDocHome() + "/Description.html";
            pogo_class.getDescription().setDescriptionHtmlExists(Utils.strBoolean(new File(filename).exists()));
        }
        EList<Property> properties = pogo_class.getDeviceProperties();
        boolean hasMandatory = false;
        boolean hasConcrete = false;
        for (Property property : properties) {
            if (Utils.isTrue(property.getMandatory())) {
                hasMandatory = true;
            }
            if (!Utils.isFalse(property.getStatus().getInherited())) continue;
            hasConcrete = true;
        }
        pogo_class.getDescription().setHasMandatoryProperty(Utils.strBoolean(hasMandatory));
        pogo_class.getDescription().setHasConcreteProperty(Utils.strBoolean(hasConcrete));
    }

    public static Command[] createStateStatusCommand() {
        Command[] commands = new Command[2];
        int i = 0;
        while (i < 2) {
            String argout_desc;
            String argout_str;
            String desc;
            String name;
            if (i == 0) {
                name = "State";
                desc = "This command gets the device state (stored in its device_state data member) and returns it to the caller.";
                argout_str = "State";
                argout_desc = "Device state";
            } else {
                name = "Status";
                desc = "This command gets the device status (stored in its device_status data member) and returns it to the caller.";
                argout_str = "ConstDevString";
                argout_desc = "Device status";
            }
            Command cmd = factory.createCommand();
            cmd.setName(name);
            cmd.setExecMethod(Utils.buildExcecMethodName(name));
            cmd.setDescription(desc);
            Argument argin = factory.createArgument();
            Argument argout = factory.createArgument();
            Type arginType = OAWutils.tango2pogoType("DevVoid");
            Type argoutType = OAWutils.tango2pogoType(argout_str);
            argin.setType(arginType);
            argout.setType(argoutType);
            argin.setDescription("none");
            argout.setDescription(argout_desc);
            cmd.setArgin(argin);
            cmd.setArgout(argout);
            InheritanceStatus status = factory.createInheritanceStatus();
            status.setAbstract("true");
            status.setInherited("true");
            status.setConcrete("true");
            cmd.setStatus(status);
            commands[i] = cmd;
            ++i;
        }
        return commands;
    }

    public static Type createType(Type type) {
        return OAWutils.tango2pogoType(OAWutils.pogo2tangoType(type.toString()));
    }

    public static Type tango2pogoType(String tangoType) {
        if (tangoType.startsWith("Tango::")) {
            tangoType = tangoType.substring("Tango::".length());
        }
        if (tangoType.equals("void")) {
            tangoType = "DevVoid";
        }
        if (tangoType.equals("DevVoid")) {
            return factory.createVoidType();
        }
        if (tangoType.equals("DevBoolean")) {
            return factory.createBooleanType();
        }
        if (tangoType.equals("DevShort")) {
            return factory.createShortType();
        }
        if (tangoType.equals("DevLong")) {
            return factory.createIntType();
        }
        if (tangoType.equals("DevFloat")) {
            return factory.createFloatType();
        }
        if (tangoType.equals("DevDouble")) {
            return factory.createDoubleType();
        }
        if (tangoType.equals("DevUShort")) {
            return factory.createUShortType();
        }
        if (tangoType.equals("DevULong")) {
            return factory.createUIntType();
        }
        if (tangoType.equals("DevString")) {
            return factory.createStringType();
        }
        if (tangoType.equals("DevVarCharArray")) {
            return factory.createCharArrayType();
        }
        if (tangoType.equals("DevVarShortArray")) {
            return factory.createShortArrayType();
        }
        if (tangoType.equals("DevVarLongArray") || tangoType.equals("DevVarIntArray")) {
            return factory.createIntArrayType();
        }
        if (tangoType.equals("DevVarFloatArray")) {
            return factory.createFloatArrayType();
        }
        if (tangoType.equals("DevVarDoubleArray")) {
            return factory.createDoubleArrayType();
        }
        if (tangoType.equals("DevVarUShortArray")) {
            return factory.createUShortArrayType();
        }
        if (tangoType.equals("DevVarULongArray") || tangoType.equals("DevVarUIntArray")) {
            return factory.createUIntArrayType();
        }
        if (tangoType.equals("DevVarStringArray")) {
            return factory.createStringArrayType();
        }
        if (tangoType.equals("DevVarLongStringArray")) {
            return factory.createLongStringArrayType();
        }
        if (tangoType.equals("DevVarDoubleStringArray")) {
            return factory.createDoubleStringArrayType();
        }
        if (tangoType.equals("DevState") || tangoType.equals("State")) {
            return factory.createStateType();
        }
        if (tangoType.equals("ConstDevString")) {
            return factory.createConstStringType();
        }
        if (tangoType.equals("DevVarBooleanArray")) {
            return factory.createBooleanArrayType();
        }
        if (tangoType.equals("DevUChar")) {
            return factory.createUCharType();
        }
        if (tangoType.equals("DevLong64")) {
            return factory.createLongType();
        }
        if (tangoType.equals("DevULong64")) {
            return factory.createULongType();
        }
        if (tangoType.equals("DevVarLong64Array")) {
            return factory.createLongArrayType();
        }
        if (tangoType.equals("DevVarULong64Array")) {
            return factory.createULongArrayType();
        }
        if (tangoType.equals("DevInt")) {
            return factory.createIntType();
        }
        if (tangoType.equals("DevEncoded")) {
            return factory.createEncodedType();
        }
        System.out.println(String.valueOf(tangoType) + " NOT FOUND !!!");
        return null;
    }

    public static String pogo2tangoType(String strPogoType) {
        String header = "fr.esrf.tango.pogo.pogoDsl.impl.";
        String footer = "TypeImpl";
        if (strPogoType.startsWith(header)) {
            String tangoType = strPogoType.substring(header.length());
            int pos = tangoType.indexOf(footer);
            if (pos > 0) {
                tangoType = tangoType.substring(0, pos);
            }
            if (tangoType.indexOf("Array") > 0) {
                if (tangoType.contains("LongString")) {
                    return "DevVarLongStringArray";
                }
                if (tangoType.contains("DoubleString")) {
                    return "DevVarDoubleStringArray";
                }
                if (tangoType.contains("ULong")) {
                    return "DevVarULong64Array";
                }
                if (tangoType.contains("Long")) {
                    return "DevVarLong64Array";
                }
                if (tangoType.contains("UInt")) {
                    return "DevVarULongArray";
                }
                if (tangoType.contains("Int")) {
                    return "DevVarLongArray";
                }
                return "DevVar" + tangoType;
            }
            if (tangoType.startsWith("Const")) {
                return TangoConst.Tango_CmdArgTypeName[20];
            }
            if (tangoType.equals("State")) {
                return tangoType;
            }
            if (tangoType.equals("Long")) {
                return "DevLong64";
            }
            if (tangoType.equals("ULong")) {
                return "DevULong64";
            }
            if (tangoType.equals("Int")) {
                return "DevLong";
            }
            if (tangoType.equals("UInt")) {
                return "DevULong";
            }
            return "Dev" + tangoType;
        }
        return "Not a Pogo Type";
    }

    private static String buildCommandsTable(PogoDeviceClass pogo_class) {
        EList<Command> commands = pogo_class.getCommands();
        StringBuilder sb = new StringBuilder();
        String cmd_name = "Command name";
        int max_len = cmd_name.length();
        for (Command cmd : commands) {
            if (cmd.getName().length() <= max_len) continue;
            max_len = cmd.getName().length();
        }
        int nb = (max_len += 2) - cmd_name.length();
        sb.append("//================================================================\n");
        sb.append("//\n");
        sb.append("//  The following table gives the correspondence\n");
        sb.append("//  between command and method names.\n");
        sb.append("//\n");
        sb.append("//  ").append(cmd_name).append(Utils.spaceTabulation(nb)).append("|  Method name\n");
        sb.append("//----------------------------------------------------------------\n");
        for (Command cmd : commands) {
            nb = max_len - cmd.getName().length();
            sb.append("//  ").append(cmd.getName()).append(Utils.spaceTabulation(nb));
            sb.append('|').append("  ");
            InheritanceStatus status = cmd.getStatus();
            if (!Utils.isTrue(status.getConcreteHere())) {
                sb.append("Inherited (no method)\n");
                continue;
            }
            sb.append(cmd.getExecMethod()).append('\n');
        }
        sb.append("//================================================================");
        return sb.toString();
    }

    private PogoSystem buildPogoSystem(PogoDeviceClass pogoClass) throws DevFailed {
        PogoSystem sys = factory.createPogoSystem();
        this.doPreProcessing(pogoClass);
        sys.getClasses().add(pogoClass);
        return sys;
    }

    private void reverseClassOrder(PogoMultiClasses pmc) {
        EList<OneClassSimpleDef> classes = pmc.getClasses();
        ArrayList<OneClassSimpleDef> v = new ArrayList<OneClassSimpleDef>();
        for (OneClassSimpleDef _class : classes) {
            v.add(0, _class);
        }
        classes.clear();
        for (OneClassSimpleDef _class : v) {
            classes.add(_class);
        }
    }

    public static ClassIdentification cloneClassIdentification(ClassIdentification id) {
        ClassIdentification new_id = factory.createClassIdentification();
        new_id.setBus(id.getBus());
        new_id.setClassFamily(id.getClassFamily());
        new_id.setContact(id.getContact());
        new_id.setAuthor(id.getAuthor());
        new_id.setEmailDomain(id.getEmailDomain());
        new_id.setManufacturer(id.getManufacturer());
        new_id.setPlatform(id.getPlatform());
        new_id.setReference(id.getReference());
        new_id.setSiteSpecific(id.getSiteSpecific());
        return new_id;
    }

    public static Type cloneType(Type src) {
        String strType = OAWutils.pogo2tangoType(src.toString());
        return OAWutils.tango2pogoType(strType);
    }

    public static PropType cloneType(PropType src) {
        String strType = PropertyDialog.pogo2tangoType(src);
        return PropertyDialog.tango2pogoType(strType);
    }

    public static Command cloneCommand(Command src) {
        Command cmd = factory.createCommand();
        String name = src.getName();
        cmd.setName(name);
        cmd.setExecMethod(Utils.buildExcecMethodName(name));
        cmd.setDescription(src.getDescription());
        Argument argin = factory.createArgument();
        argin.setType(OAWutils.cloneType(src.getArgin().getType()));
        argin.setDescription(src.getArgin().getDescription());
        cmd.setArgin(argin);
        Argument argout = factory.createArgument();
        argout.setType(OAWutils.cloneType(src.getArgout().getType()));
        argout.setDescription(src.getArgout().getDescription());
        cmd.setArgout(argout);
        if (src.getDisplayLevel() == null) {
            cmd.setDisplayLevel("OPERATOR");
        } else {
            cmd.setDisplayLevel(src.getDisplayLevel());
        }
        InheritanceStatus status = factory.createInheritanceStatus();
        InheritanceStatus src_st = src.getStatus();
        status.setAbstract(src_st.getAbstract());
        status.setInherited(src_st.getInherited());
        status.setConcrete(src_st.getConcrete());
        status.setConcreteHere(src_st.getConcreteHere());
        cmd.setStatus(status);
        EList<String> src_excluded = src.getExcludedStates();
        EList<String> new_excuded = cmd.getExcludedStates();
        for (String s : src_excluded) {
            new_excuded.add(s);
        }
        cmd.setPolledPeriod(src.getPolledPeriod());
        return cmd;
    }

    public static Attribute cloneAttribute(Attribute src) {
        EventCriteria archiveEventCriteria;
        Attribute attr = factory.createAttribute();
        attr.setName(src.getName());
        attr.setIsDynamic(src.getIsDynamic());
        attr.setAttType(src.getAttType());
        attr.setRwType(src.getRwType());
        if (src.getAssociatedAttr() != null && src.getAssociatedAttr().length() > 0) {
            attr.setAssociatedAttr(src.getAssociatedAttr());
        }
        attr.setDataType(OAWutils.cloneType(src.getDataType()));
        attr.setMaxX(src.getMaxX());
        attr.setMaxY(src.getMaxY());
        AttrProperties prop = factory.createAttrProperties();
        AttrProperties src_prop = src.getProperties();
        prop.setDescription(src_prop.getDescription());
        prop.setLabel(src_prop.getLabel());
        prop.setUnit(src_prop.getUnit());
        prop.setStandardUnit(src_prop.getStandardUnit());
        prop.setDisplayUnit(src_prop.getDisplayUnit());
        prop.setFormat(src_prop.getFormat());
        prop.setMaxValue(src_prop.getMaxValue());
        prop.setMinValue(src_prop.getMinValue());
        prop.setMaxAlarm(src_prop.getMaxAlarm());
        prop.setMinAlarm(src_prop.getMinAlarm());
        prop.setMaxWarning(src_prop.getMaxWarning());
        prop.setMinWarning(src_prop.getMinWarning());
        prop.setDeltaTime(src_prop.getDeltaTime());
        prop.setDeltaValue(src_prop.getDeltaValue());
        attr.setProperties(prop);
        attr.setPolledPeriod(src.getPolledPeriod());
        if (src.getDisplayLevel() == null) {
            attr.setDisplayLevel("OPERATOR");
        } else {
            attr.setDisplayLevel(src.getDisplayLevel());
        }
        attr.setMemorized(src.getMemorized());
        attr.setMemorizedAtInit(src.getMemorizedAtInit());
        InheritanceStatus status = factory.createInheritanceStatus();
        InheritanceStatus src_st = src.getStatus();
        status.setAbstract(src_st.getAbstract());
        status.setInherited(src_st.getInherited());
        status.setConcrete(src_st.getConcrete());
        status.setConcreteHere(src_st.getConcreteHere());
        EList<String> src_excluded = src.getReadExcludedStates();
        EList<String> new_excuded = attr.getReadExcludedStates();
        for (String s : src_excluded) {
            new_excuded.add(s);
        }
        src_excluded = src.getWriteExcludedStates();
        new_excuded = attr.getWriteExcludedStates();
        for (String s : src_excluded) {
            new_excuded.add(s);
        }
        attr.setStatus(status);
        attr.setAllocReadMember(src.getAllocReadMember());
        EventCriteria eventCriteria = src.getEventCriteria();
        if (OAWutils.eventCriteriaIsSet(eventCriteria)) {
            EventCriteria newEventCriteria = factory.createEventCriteria();
            newEventCriteria.setPeriod(eventCriteria.getPeriod());
            newEventCriteria.setRelChange(eventCriteria.getRelChange());
            newEventCriteria.setAbsChange(eventCriteria.getAbsChange());
            attr.setEventCriteria(newEventCriteria);
        }
        if (OAWutils.eventCriteriaIsSet(archiveEventCriteria = src.getEvArchiveCriteria())) {
            EventCriteria newEventCriteria = factory.createEventCriteria();
            newEventCriteria.setPeriod(archiveEventCriteria.getPeriod());
            newEventCriteria.setRelChange(archiveEventCriteria.getRelChange());
            newEventCriteria.setAbsChange(archiveEventCriteria.getAbsChange());
            attr.setEvArchiveCriteria(newEventCriteria);
        }
        if (src.getChangeEvent() != null) {
            FireEvents changeEvents = factory.createFireEvents();
            changeEvents.setFire(src.getChangeEvent().getFire());
            changeEvents.setLibCheckCriteria(src.getChangeEvent().getLibCheckCriteria());
            attr.setChangeEvent(changeEvents);
        }
        if (src.getArchiveEvent() != null) {
            FireEvents archiveEvents = factory.createFireEvents();
            archiveEvents.setFire(src.getArchiveEvent().getFire());
            archiveEvents.setLibCheckCriteria(src.getArchiveEvent().getLibCheckCriteria());
            attr.setArchiveEvent(archiveEvents);
        }
        if (src.getDataReadyEvent() != null) {
            FireEvents dataReadyEvents = factory.createFireEvents();
            dataReadyEvents.setFire(src.getDataReadyEvent().getFire());
            dataReadyEvents.setLibCheckCriteria(src.getDataReadyEvent().getLibCheckCriteria());
            attr.setDataReadyEvent(dataReadyEvents);
        }
        return attr;
    }

    private static boolean eventCriteriaIsSet(EventCriteria eventCriteria) {
        return eventCriteria != null && (eventCriteria.getPeriod().length() > 0 || eventCriteria.getRelChange().length() > 0 || eventCriteria.getAbsChange().length() > 0);
    }

    public static Property cloneProperty(Property src) {
        Property property = factory.createProperty();
        property.setName(src.getName());
        property.setDescription(src.getDescription());
        property.setType(OAWutils.cloneType(src.getType()));
        EList<String> list = property.getDefaultPropValue();
        EList<String> src_list = src.getDefaultPropValue();
        for (String s : src_list) {
            list.add(s);
        }
        InheritanceStatus status = factory.createInheritanceStatus();
        InheritanceStatus src_st = src.getStatus();
        status.setAbstract(src_st.getAbstract());
        status.setInherited(src_st.getInherited());
        status.setConcrete(src_st.getConcrete());
        status.setConcreteHere(src_st.getConcreteHere());
        property.setStatus(status);
        if (Utils.isTrue(src.getMandatory())) {
            property.setMandatory("true");
        }
        return property;
    }

    public static State cloneState(State src) {
        State state = factory.createState();
        state.setName(src.getName());
        state.setDescription(src.getDescription());
        InheritanceStatus status = factory.createInheritanceStatus();
        InheritanceStatus src_st = src.getStatus();
        status.setAbstract(src_st.getAbstract());
        status.setInherited(src_st.getInherited());
        status.setConcrete(src_st.getConcrete());
        status.setConcreteHere(src_st.getConcreteHere());
        state.setStatus(status);
        return state;
    }

    public static AdditionalFile cloneAdditionalFile(AdditionalFile src) {
        AdditionalFile file = factory.createAdditionalFile();
        file.setName(src.getName());
        file.setPath(src.getPath());
        return file;
    }
}

