/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.PogoConst;

public class StateMachineDialog
extends JDialog
implements PogoConst {
    private PogoDeviceClass pogo_class;
    private int retVal = 0;
    private Buttons buttons = new Buttons();
    private static final int COMMAND = 0;
    private static final int READ_ATTRIBUTE = 1;
    private static final int WRITE_ATTRIBUTE = 2;
    private JPanel mainPanel;
    private JLabel titleLabel;

    public StateMachineDialog(JFrame parent, PogoDeviceClass pogo_class) {
        super((Frame)parent, true);
        this.pogo_class = pogo_class;
        this.initComponents();
        this.createOwnComponents();
        this.titleLabel.setText(String.valueOf(pogo_class.getName()) + " State Machine");
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void addColumnHeader(int y, String str1, String str2, EList<State> states) {
        Font font = new Font("Dialog", 1, 16);
        int x = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        JLabel lbl = new JLabel(str1);
        lbl.setFont(font);
        gbc.insets = new Insets(15, 20, 0, 20);
        gbc.gridx = x;
        gbc.gridy = y++;
        this.mainPanel.add((Component)lbl, gbc);
        lbl = new JLabel(str2);
        lbl.setFont(font);
        gbc.insets = new Insets(0, 20, 0, 20);
        gbc.gridx = x++;
        gbc.gridy = y;
        this.mainPanel.add((Component)lbl, gbc);
        if (states != null) {
            for (State state : states) {
                lbl = new JLabel(state.getName());
                lbl.setFont(font);
                gbc.insets = new Insets(0, 20, 0, 20);
                gbc.gridx = x++;
                gbc.gridy = y;
                this.mainPanel.add((Component)lbl, gbc);
            }
        }
    }

    private void addLineHeader(int y, String str) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        JLabel lbl = new JLabel(str);
        lbl.setFont(new Font("Dialog", 0, 12));
        gbc.insets = new Insets(0, 20, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = y;
        this.mainPanel.add((Component)lbl, gbc);
    }

    private AllowedBtn addAllowedButton(int x, int y, State state, EList<String> excludedStates) {
        GridBagConstraints gbc = new GridBagConstraints();
        AllowedBtn btn = new AllowedBtn("", state.getName());
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.insets = new Insets(0, 5, 0, 5);
        btn.setSelected(true);
        btn.setFont(new Font("Dialog", 0, 10));
        this.mainPanel.add((Component)btn, gbc);
        for (String excluded : excludedStates) {
            if (!state.getName().equals(excluded)) continue;
            btn.setSelected(false);
        }
        return btn;
    }

    private void createOwnComponents() {
        EList<State> states = this.pogo_class.getStates();
        int y = 0;
        this.addColumnHeader(y, "Select Allowed", "Commands", states);
        y += 2;
        EList<Command> commands = this.pogo_class.getCommands();
        for (Command command : commands) {
            if (command.getName().equals("State") || command.getName().equals("Status")) continue;
            this.addCommandLine(y++, command, states);
        }
        this.addColumnHeader(y, "Select Allowed", "Attributes", states);
        y += 2;
        EList<Attribute> attributes = this.pogo_class.getAttributes();
        for (Attribute attribute : attributes) {
            this.addAttributeLine(y++, attribute, 1, states);
            if (attribute.getRwType().equals(AttrRWtypeArray[0])) continue;
            this.addAttributeLine(y++, attribute, 2, states);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(20, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = y;
        this.mainPanel.add((Component)new JLabel("  "), gbc);
    }

    private void addCommandLine(int y, Command cmd, EList<State> states) {
        this.addLineHeader(y, "  " + cmd.getName());
        BtnLine line = new BtnLine(cmd.getName(), 0);
        EList<String> excludedStates = cmd.getExcludedStates();
        int x = 1;
        for (State state : states) {
            line.add(this.addAllowedButton(x++, y, state, excludedStates));
        }
        this.buttons.add(line);
    }

    private void addAttributeLine(int y, Attribute att, int attType, EList<State> states) {
        EList<String> excludedStates;
        String rwStr;
        if (attType == 1) {
            rwStr = " (Read)";
            excludedStates = att.getReadExcludedStates();
        } else {
            rwStr = " (Write)";
            excludedStates = att.getWriteExcludedStates();
        }
        this.addLineHeader(y, "  " + att.getName() + rwStr);
        BtnLine line = new BtnLine(att.getName(), attType);
        int x = 1;
        for (State state : states) {
            line.add(this.addAllowedButton(x++, y, state, excludedStates));
        }
        this.buttons.add(line);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StateMachineDialog.this.closeDialog(evt);
            }
        });
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StateMachineDialog.this.okBtnActionPerformed(evt);
            }
        });
        jPanel1.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StateMachineDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("State Machine");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.mainPanel.setLayout(new GridBagLayout());
        jScrollPane1.setViewportView(this.mainPanel);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public PogoDeviceClass getPogoClass() {
        EList<Command> commands = this.pogo_class.getCommands();
        for (Command command : commands) {
            BtnLine line = this.buttons.getLine(command.getName(), 0);
            if (line == null) continue;
            EList<String> excluded = command.getExcludedStates();
            excluded.clear();
            for (AllowedBtn btn : line) {
                if (btn.getSelectedObjects() != null) continue;
                excluded.add(btn.name);
            }
        }
        EList<Attribute> attributes = this.pogo_class.getAttributes();
        for (Attribute attribute : attributes) {
            BtnLine line = this.buttons.getLine(attribute.getName(), 1);
            if (line != null) {
                EList<String> read_excluded = attribute.getReadExcludedStates();
                read_excluded.clear();
                for (AllowedBtn btn : line) {
                    if (btn.getSelectedObjects() != null) continue;
                    read_excluded.add(btn.name);
                }
            }
            if (attribute.getRwType().equals(AttrRWtypeArray[0]) || (line = this.buttons.getLine(attribute.getName(), 2)) == null) continue;
            EList<String> write_excluded = attribute.getWriteExcludedStates();
            write_excluded.clear();
            for (AllowedBtn btn : line) {
                if (btn.getSelectedObjects() != null) continue;
                write_excluded.add(btn.name);
            }
        }
        return this.pogo_class;
    }

    private class AllowedBtn
    extends JRadioButton {
        String name;

        private AllowedBtn(String txt, String name) {
            this.setText(txt);
            this.name = name;
        }
    }

    private class BtnLine
    extends ArrayList<AllowedBtn> {
        String name;
        int type;

        private BtnLine(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }

    private class Buttons
    extends ArrayList<BtnLine> {
        private Buttons() {
        }

        private BtnLine getLine(String name, int type) {
            for (BtnLine line : this) {
                if (!line.name.equals(name) || line.type != type) continue;
                return line;
            }
            return null;
        }
    }
}

