/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PopupTable;
import org.tango.pogo.pogo_gui.tools.Utils;

public class StateDialog
extends JDialog {
    private JTextArea descText;
    private JComboBox typeComboBox;
    private PogoGUI pogo_gui;
    private InheritanceStatus orig_status;
    private int retVal = 0;
    private static int[] columnSize = new int[]{140, 40, 400};
    private static String[] columnTitle = new String[]{"Name", "Inherited", "Description"};

    public StateDialog(PogoGUI parent, State state) {
        super((Frame)parent, true);
        this.pogo_gui = parent;
        this.initComponents();
        String[] stringArray = TangoConst.Tango_DevStateName;
        int n = TangoConst.Tango_DevStateName.length;
        int n2 = 0;
        while (n2 < n) {
            String stateName = stringArray[n2];
            this.typeComboBox.addItem(stateName);
            ++n2;
        }
        this.setState(state);
        this.manageInheritanceStatus(state);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void manageInheritanceStatus(State state) {
        if (state != null) {
            this.orig_status = state.getStatus();
            if (Utils.isTrue(this.orig_status.getInherited())) {
                this.setEditable(false);
            } else {
                this.setEditable(true);
            }
        } else {
            this.orig_status = OAWutils.factory.createInheritanceStatus();
            this.orig_status.setAbstract("false");
            this.orig_status.setInherited("false");
            this.orig_status.setConcrete("true");
            this.orig_status.setConcreteHere("true");
        }
    }

    private void setNotEditable(JComboBox jcb) {
        String name = (String)jcb.getSelectedItem();
        if (name != null) {
            jcb.removeAllItems();
            jcb.addItem(name);
        }
    }

    private void setEditable(boolean b2) {
        if (!b2) {
            this.setNotEditable(this.typeComboBox);
        }
    }

    private void initComponents() {
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("Edit State Window");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StateDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel1 = new JPanel();
        jPanel1.setLayout(new FlowLayout(2, 5, 5));
        JButton okBtn = new JButton();
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StateDialog.this.okBtnActionPerformed(evt);
            }
        });
        jPanel1.add(okBtn);
        JButton cancelBtn = new JButton();
        cancelBtn.setText("Cancel");
        cancelBtn.setActionCommand("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StateDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        JLabel nameLbl = new JLabel();
        nameLbl.setText("State Name:    ");
        nameLbl.setForeground(Color.black);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        centerPanel.add((Component)nameLbl, gbc);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(" ");
        jLabel5.setForeground(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        centerPanel.add((Component)jLabel5, gbc);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("State Description:  ");
        jLabel6.setForeground(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        centerPanel.add((Component)jLabel6, gbc);
        this.descText = new JTextArea();
        this.descText.setColumns(80);
        this.descText.setPreferredSize(new Dimension(1000, 400));
        this.descText.setMinimumSize(new Dimension(0, 100));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(500, 150));
        scrollPane.setViewportView(this.descText);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 9;
        gbc.gridwidth = 2;
        gbc.gridheight = 5;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        centerPanel.add((Component)scrollPane, gbc);
        this.typeComboBox = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        centerPanel.add((Component)this.typeComboBox, gbc);
        this.getContentPane().add((Component)centerPanel, "Center");
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(2);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            String name = this.typeComboBox.getSelectedItem().toString();
            if (this.pogo_gui.itemAlreadyExists(name, 6)) {
                Except.throw_exception("StateExists", "State \"" + name + "\" Already Exists !", "StateDialog.okBtnActionPerformed()");
            }
            this.doClose(0);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(2);
    }

    private void doClose(int retVal) {
        this.retVal = retVal;
        this.setVisible(false);
        this.dispose();
    }

    private void setState(State state) {
        if (state != null) {
            String[] stringArray = TangoConst.Tango_DevStateName;
            int n = TangoConst.Tango_DevStateName.length;
            int n2 = 0;
            while (n2 < n) {
                String stateName = stringArray[n2];
                if (stateName.equals(state.getName())) {
                    this.typeComboBox.setSelectedItem(stateName);
                }
                ++n2;
            }
            this.descText.setText(state.getDescription());
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public State getState() {
        State state = OAWutils.factory.createState();
        state.setName(this.typeComboBox.getSelectedItem().toString());
        state.setDescription(this.descText.getText());
        state.setStatus(this.orig_status);
        return state;
    }

    public static State cloneState(State srcState) {
        State newState = OAWutils.cloneState(srcState);
        InheritanceStatus inher_status = newState.getStatus();
        if (!Utils.isTrue(inher_status.getAbstract())) {
            inher_status.setAbstract("false");
            inher_status.setInherited("false");
            inher_status.setConcrete("true");
            inher_status.setConcreteHere("true");
        }
        if (Utils.isTrue(inher_status.getInherited())) {
            inher_status.setAbstract("false");
            inher_status.setInherited("false");
            inher_status.setConcrete("true");
            inher_status.setConcreteHere("true");
        }
        newState.setStatus(inher_status);
        return newState;
    }

    public static void popupSummary(JFrame parent, ArrayList<State> vs) {
        ArrayList<ArrayList<String>> summary = StateDialog.buildSummary(vs);
        String title = String.valueOf(Integer.toString(vs.size())) + "  States";
        PopupTable ppt = new PopupTable(parent, title, columnTitle, summary);
        ppt.setPreferredSize(columnSize, vs.size());
        ppt.setVisible(true);
    }

    private static ArrayList<ArrayList<String>> buildSummary(ArrayList<State> vs) {
        ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
        for (State state : vs) {
            ArrayList<String> line = new ArrayList<String>();
            line.add(state.getName());
            InheritanceStatus status = state.getStatus();
            line.add(Utils.strBoolean(status.getInherited()));
            line.add(Utils.strReplace(state.getDescription(), "\\n", "\n"));
            result.add(line);
        }
        return result;
    }
}

