/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.TangoDs.Except;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.PogoDslFactory;
import fr.esrf.tango.pogo.pogoDsl.PropType;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.EditDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PopupTable;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PropertyDialog
extends JDialog {
    private static final String[] propertyTypeNames = new String[]{"DevBoolean", "DevShort", "DevLong", "DevFloat", "DevDouble", "String", "DevUShort", "DevULong", "Array of DevShort", "Array of DevLong", "Array of DevFloat", "Array of DevDouble", "Array of String"};
    private static final int booleanProp = 0;
    private static final int shortProp = 1;
    private static final int intProp = 2;
    private static final int floatProp = 3;
    private static final int doubleProp = 4;
    private static final int stringProp = 5;
    private static final int ushortProp = 6;
    private static final int uintProp = 7;
    private static final int shortVector = 8;
    private static final int intVector = 9;
    private static final int floatVector = 10;
    private static final int doubleVector = 11;
    private static final int stringVector = 12;
    private static final String defaultDataType = propertyTypeNames[5];
    private InheritanceStatus orig_status;
    private int retVal = 0;
    private JButton descBtn;
    private JTextArea descTxt;
    private JRadioButton mandatoryBtn;
    private JTextField nameTxt;
    private JLabel titleLbl;
    private JComboBox typeComboBox;
    private JButton valueBtn;
    private JTextArea valueTxt;
    private static int[] columnSize = new int[]{140, 130, 40, 400};
    private static String[] columnTitle = new String[]{"name", "type", "Inherited", "Description"};

    public PropertyDialog(JFrame parent, Property property, boolean is_dev) {
        super((Frame)parent, true);
        this.initComponents();
        this.setProperty(property);
        this.manageInheritanceStatus(property);
        this.titleLbl.setText(String.valueOf(is_dev ? "Device" : "Class") + "  Property");
        if (is_dev) {
            this.mandatoryBtn.setToolTipText(Utils.buildToolTip("Mandatoty Device Property", "The property value must be specified in Tango database.\nOtherwise all commands and read/write attribute will throw an exception."));
        } else {
            this.mandatoryBtn.setVisible(false);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void manageInheritanceStatus(Property prop) {
        if (prop != null) {
            this.orig_status = prop.getStatus();
            if (Utils.isTrue(this.orig_status.getInherited())) {
                this.setEditable(false);
            } else {
                this.setEditable(true);
            }
        } else {
            this.orig_status = OAWutils.factory.createInheritanceStatus();
            this.orig_status.setAbstract("false");
            this.orig_status.setInherited("false");
            this.orig_status.setConcrete("true");
            this.orig_status.setConcreteHere("true");
        }
    }

    private void setNotEditable(JComboBox jcb) {
        String name = (String)jcb.getSelectedItem();
        if (name != null) {
            jcb.removeAllItems();
            jcb.addItem(name);
        }
    }

    private void setEditable(boolean b2) {
        this.nameTxt.setEditable(b2);
        if (!b2) {
            this.setNotEditable(this.typeComboBox);
        }
    }

    private void setProperty(Property property) {
        String[] stringArray = propertyTypeNames;
        int n = propertyTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.typeComboBox.addItem(type);
            ++n2;
        }
        if (property != null) {
            this.nameTxt.setText(property.getName());
            String desc = Utils.strReplaceSpecialCharToDisplay(property.getDescription());
            this.descTxt.setText(desc);
            EList<String> values = property.getDefaultPropValue();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < values.size()) {
                sb.append((String)values.get(i));
                if (i < values.size() - 1) {
                    sb.append("\n");
                }
                ++i;
            }
            this.valueTxt.setText(sb.toString().trim());
            this.mandatoryBtn.setSelected(Utils.isTrue(property.getMandatory()));
            String strType = PropertyDialog.pogo2tangoType(property.getType());
            String[] stringArray2 = propertyTypeNames;
            int n3 = propertyTypeNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String type = stringArray2[n4];
                if (type.equals(strType)) {
                    this.typeComboBox.setSelectedItem(type);
                }
                ++n4;
            }
        } else {
            this.typeComboBox.setSelectedItem(defaultDataType);
        }
    }

    private void initComponents() {
        JPanel titlePanel = new JPanel();
        this.titleLbl = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel centerPanel = new JPanel();
        JLabel nameLbl = new JLabel();
        this.nameTxt = new JTextField();
        JLabel descLbl = new JLabel();
        JScrollPane scrollPane = new JScrollPane();
        this.descTxt = new JTextArea();
        JLabel arginLbl = new JLabel();
        JLabel valueLbl = new JLabel();
        this.typeComboBox = new JComboBox();
        this.descBtn = new JButton();
        this.valueBtn = new JButton();
        this.mandatoryBtn = new JRadioButton();
        JScrollPane scrollPane2 = new JScrollPane();
        this.valueTxt = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PropertyDialog.this.closeDialog(evt);
            }
        });
        this.titleLbl.setFont(new Font("Dialog", 1, 18));
        this.titleLbl.setText("Dialog Title");
        titlePanel.add(this.titleLbl);
        this.getContentPane().add((Component)titlePanel, "First");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        centerPanel.setLayout(new GridBagLayout());
        nameLbl.setText("Property Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        centerPanel.add((Component)nameLbl, gridBagConstraints);
        this.nameTxt.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        centerPanel.add((Component)this.nameTxt, gridBagConstraints);
        descLbl.setText("Property description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        centerPanel.add((Component)descLbl, gridBagConstraints);
        scrollPane.setPreferredSize(new Dimension(200, 100));
        this.descTxt.setColumns(20);
        this.descTxt.setRows(5);
        scrollPane.setViewportView(this.descTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        centerPanel.add((Component)scrollPane, gridBagConstraints);
        arginLbl.setText("Propery Type :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(25, 20, 0, 10);
        centerPanel.add((Component)arginLbl, gridBagConstraints);
        valueLbl.setText("Default Value :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        centerPanel.add((Component)valueLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        centerPanel.add((Component)this.typeComboBox, gridBagConstraints);
        this.descBtn.setText("...");
        this.descBtn.setBorder(new SoftBevelBorder(0));
        this.descBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.descBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        centerPanel.add((Component)this.descBtn, gridBagConstraints);
        this.valueBtn.setText("...");
        this.valueBtn.setBorder(new SoftBevelBorder(0));
        this.valueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.descBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        centerPanel.add((Component)this.valueBtn, gridBagConstraints);
        this.mandatoryBtn.setText("Mandatory in Database");
        this.mandatoryBtn.setHorizontalTextPosition(2);
        this.mandatoryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.mandatoryBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(30, 20, 0, 0);
        centerPanel.add((Component)this.mandatoryBtn, gridBagConstraints);
        scrollPane2.setPreferredSize(new Dimension(166, 60));
        this.valueTxt.setColumns(20);
        this.valueTxt.setRows(5);
        scrollPane2.setViewportView(this.valueTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        centerPanel.add((Component)scrollPane2, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            String name = this.nameTxt.getText();
            if (name.length() == 0) {
                Except.throw_exception("Property name ?", "Property name ?", "PropertyDialog.okBtnActionPerformed()");
            }
            name = Utils.checkNameSyntax(name, true);
            this.nameTxt.setText(name);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void descBtnActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        String text = "";
        if (btn == this.valueBtn) {
            text = this.valueTxt.getText();
        } else if (btn == this.descBtn) {
            text = this.descTxt.getText();
        }
        EditDialog dlg = new EditDialog(this, text.trim());
        if (dlg.showDialog() == 0) {
            if (btn == this.valueBtn) {
                this.valueTxt.setText(dlg.getText().trim());
            } else if (btn == this.descBtn) {
                this.descTxt.setText(dlg.getText().trim());
            }
        }
    }

    private void mandatoryBtnActionPerformed(ActionEvent evt) {
        boolean mandatory = this.mandatoryBtn.getSelectedObjects() != null;
        this.valueTxt.setEnabled(!mandatory);
        this.valueBtn.setEnabled(!mandatory);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    Property getProperty() {
        boolean mandatory;
        String name = this.nameTxt.getText();
        Property property = OAWutils.factory.createProperty();
        property.setName(name);
        String desc = this.descTxt.getText();
        desc = Utils.strReplaceSpecialCharToCode(desc);
        property.setDescription(desc);
        String strType = (String)this.typeComboBox.getSelectedItem();
        PropType type = PropertyDialog.tango2pogoType(strType);
        property.setType(type);
        boolean bl = mandatory = this.mandatoryBtn.getSelectedObjects() != null;
        if (mandatory) {
            property.setMandatory("true");
        } else {
            String strVal = Utils.strReplace(this.valueTxt.getText(), "\\n", "\n").trim();
            EList<String> list = property.getDefaultPropValue();
            StringTokenizer st = new StringTokenizer(strVal, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken().trim();
                if (line.length() <= 0) continue;
                list.add(line);
            }
        }
        property.setStatus(this.orig_status);
        return property;
    }

    public static Property cloneProperty(Property srcProperty) {
        Property newProperty = OAWutils.cloneProperty(srcProperty);
        InheritanceStatus inher_status = newProperty.getStatus();
        if (!Utils.isTrue(inher_status.getAbstract())) {
            inher_status.setAbstract("false");
            inher_status.setInherited("false");
            inher_status.setConcrete("true");
            inher_status.setConcreteHere("true");
        }
        if (Utils.isTrue(inher_status.getInherited())) {
            inher_status.setAbstract("false");
            inher_status.setInherited("false");
            inher_status.setConcrete("true");
            inher_status.setConcreteHere("true");
        }
        newProperty.setStatus(inher_status);
        return newProperty;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static PropType createType(PropType type) {
        return PropertyDialog.tango2pogoType(PropertyDialog.pogo2tangoType(type));
    }

    public static PropType tango2pogoType(String tangoType) {
        if (tangoType.startsWith("Tango::")) {
            tangoType = tangoType.substring("Tango::".length());
        }
        if (tangoType.equals("void")) {
            tangoType = "DevVoid";
        }
        PogoDslFactory factory = OAWutils.factory;
        if (tangoType.equals(propertyTypeNames[0])) {
            return factory.createBooleanType();
        }
        if (tangoType.equals(propertyTypeNames[1])) {
            return factory.createShortType();
        }
        if (tangoType.equals(propertyTypeNames[2]) || tangoType.equals("DevInt")) {
            return factory.createIntType();
        }
        if (tangoType.equals(propertyTypeNames[3])) {
            return factory.createFloatType();
        }
        if (tangoType.equals(propertyTypeNames[4])) {
            return factory.createDoubleType();
        }
        if (tangoType.equals(propertyTypeNames[6])) {
            return factory.createUShortType();
        }
        if (tangoType.equals(propertyTypeNames[7])) {
            return factory.createUIntType();
        }
        if (tangoType.equals(propertyTypeNames[5]) || tangoType.equals("DevString") || tangoType.equals("string")) {
            return factory.createStringType();
        }
        if (tangoType.equals(propertyTypeNames[8]) || tangoType.equals("vector<short>") || tangoType.equals("DevVarShortArray")) {
            return factory.createShortVectorType();
        }
        if (tangoType.equals(propertyTypeNames[9]) || tangoType.equals("vector<long>") || tangoType.equals("DevVarLongArray")) {
            return factory.createIntVectorType();
        }
        if (tangoType.equals(propertyTypeNames[10]) || tangoType.equals("vector<float>") || tangoType.equals("DevVarFloatArray")) {
            return factory.createFloatVectorType();
        }
        if (tangoType.equals(propertyTypeNames[11]) || tangoType.equals("vector<double>") || tangoType.equals("DevVarDoubleArray")) {
            return factory.createDoubleVectorType();
        }
        if (tangoType.equals(propertyTypeNames[12]) || tangoType.toLowerCase().equals("vector<string>") || tangoType.equals("DevStringVector") || tangoType.equals("DevVarStringArray")) {
            return factory.createStringVectorType();
        }
        System.err.println("============================================");
        System.err.println(String.valueOf(tangoType) + " NOT FOUND for property !!!");
        System.err.println("============================================");
        return null;
    }

    public static String pogo2tangoType(PropType type) {
        String header = "fr.esrf.tango.pogo.pogoDsl.impl.";
        String prop_tag = "Vector";
        String footer = "TypeImpl";
        String strPogoType = type.toString();
        if (strPogoType.startsWith(header)) {
            String tangoType = strPogoType.substring(header.length());
            int pos = tangoType.indexOf(footer);
            if (pos > 0) {
                tangoType = tangoType.substring(0, pos);
            }
            if (tangoType.indexOf(prop_tag) > 0) {
                if (tangoType.contains("ShortVector")) {
                    return propertyTypeNames[8];
                }
                if (tangoType.contains("IntVector")) {
                    return propertyTypeNames[9];
                }
                if (tangoType.contains("FloatVector")) {
                    return propertyTypeNames[10];
                }
                if (tangoType.contains("DoubleVector")) {
                    return propertyTypeNames[11];
                }
                if (tangoType.contains("StringVector")) {
                    return propertyTypeNames[12];
                }
            }
            if (tangoType.startsWith("Boolean")) {
                return propertyTypeNames[0];
            }
            if (tangoType.startsWith("Short")) {
                return propertyTypeNames[1];
            }
            if (tangoType.startsWith("Int")) {
                return propertyTypeNames[2];
            }
            if (tangoType.startsWith("Float")) {
                return propertyTypeNames[3];
            }
            if (tangoType.startsWith("Double")) {
                return propertyTypeNames[4];
            }
            if (tangoType.startsWith("String")) {
                return propertyTypeNames[5];
            }
            if (tangoType.startsWith("UShort")) {
                return propertyTypeNames[6];
            }
            if (tangoType.startsWith("UInt")) {
                return propertyTypeNames[7];
            }
        } else {
            System.err.println(String.valueOf(strPogoType) + " not found !  (" + header + ")");
        }
        return "Not a Pogo Type";
    }

    public static void popupSummary(JFrame parent, ArrayList<Property> vp, boolean is_dev) {
        ArrayList<ArrayList<String>> summary = PropertyDialog.buildSummary(vp);
        String title = String.valueOf(Integer.toString(vp.size())) + (is_dev ? "  Device" : "  Class") + " Properties";
        PopupTable ppt = new PopupTable(parent, title, columnTitle, summary);
        int nb = vp.size();
        if (nb > 35) {
            nb = 35;
        }
        ppt.setPreferredSize(columnSize, nb);
        ppt.setVisible(true);
    }

    public static ArrayList<ArrayList<String>> buildSummary(ArrayList<Property> vp) {
        ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
        for (Property prop : vp) {
            ArrayList<String> line = new ArrayList<String>();
            line.add(prop.getName());
            line.add(PropertyDialog.pogo2tangoType(prop.getType()));
            InheritanceStatus status = prop.getStatus();
            line.add(Utils.strBoolean(status.getInherited()));
            line.add(Utils.strReplace(prop.getDescription(), "\\n", "\n"));
            result.add(line);
        }
        return result;
    }
}

