/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;

public class PreferencesDialog
extends JDialog {
    private JTextField inheritanceTxt;
    private JTextField mailTxt;
    private JRadioButton reloadBtn;

    public PreferencesDialog(JFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.reloadBtn.setSelected(PogoProperty.loadPrevious);
        if (PogoProperty.contactAddress != null) {
            this.mailTxt.setText(PogoProperty.contactAddress);
        }
        if (PogoProperty.inheritHome != null) {
            this.inheritanceTxt.setText(PogoProperty.inheritHome);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        JPanel centerPanel = new JPanel();
        JLabel inheritanceLbl = new JLabel();
        this.inheritanceTxt = new JTextField();
        JButton inheritanceBtn = new JButton();
        this.reloadBtn = new JRadioButton();
        JLabel mailLbl = new JLabel();
        this.mailTxt = new JTextField();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PreferencesDialog.this.closeDialog(evt);
            }
        });
        titleLabel.setFont(new Font("Dialog", 1, 18));
        titleLabel.setText("Pogo Preferences");
        topPanel.add(titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        centerPanel.setLayout(new GridBagLayout());
        inheritanceLbl.setFont(new Font("Dialog", 1, 12));
        inheritanceLbl.setText("Inheritance root directory :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        centerPanel.add((Component)inheritanceLbl, gridBagConstraints);
        this.inheritanceTxt.setColumns(50);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        centerPanel.add((Component)this.inheritanceTxt, gridBagConstraints);
        inheritanceBtn.setText("...");
        inheritanceBtn.setBorder(new SoftBevelBorder(0));
        inheritanceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.inheritanceBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        centerPanel.add((Component)inheritanceBtn, gridBagConstraints);
        this.reloadBtn.setFont(new Font("Dialog", 1, 12));
        this.reloadBtn.setText("Reload project at startup");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        centerPanel.add((Component)this.reloadBtn, gridBagConstraints);
        mailLbl.setFont(new Font("Dialog", 1, 12));
        mailLbl.setText("Default contact email :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        centerPanel.add((Component)mailLbl, gridBagConstraints);
        this.mailTxt.setColumns(30);
        this.mailTxt.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        centerPanel.add((Component)this.mailTxt, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        PogoProperty.inheritHome = this.inheritanceTxt.getText();
        PogoProperty.contactAddress = this.mailTxt.getText();
        PogoProperty.loadPrevious = this.reloadBtn.getSelectedObjects() != null;
        PogoProperty.updatePogoRC();
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void inheritanceBtnActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser chooser = new JFileChooser(this.inheritanceTxt.getText());
        chooser.addChoosableFileFilter(new PogoFileFilter("", "Directory"));
        chooser.setFileSelectionMode(1);
        int retval = chooser.showDialog(this, "Target Dir.");
        if (retval == 0 && (file = chooser.getSelectedFile()) != null && file.isDirectory()) {
            this.inheritanceTxt.setText(file.getAbsolutePath());
        }
        this.inheritanceTxt.requestFocus();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

