/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tango.pogo.pogo_gui.ClassDialog;
import org.tango.pogo.pogo_gui.ClassPanel;
import org.tango.pogo.pogo_gui.ClassTree;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.DeviceIdDialog;
import org.tango.pogo.pogo_gui.GenerateDialog;
import org.tango.pogo.pogo_gui.InheritancePanel;
import org.tango.pogo.pogo_gui.InheritanceUtils;
import org.tango.pogo.pogo_gui.MultiClassesPanel;
import org.tango.pogo.pogo_gui.OldPogoModel;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PreferencesDialog;
import org.tango.pogo.pogo_gui.tools.PogoConfiguration;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.PopupColorCode;
import org.tango.pogo.pogo_gui.tools.PopupHtml;
import org.tango.pogo.pogo_gui.tools.Utils;
import pogo.appli.PogoAppli;

public class PogoGUI
extends JFrame {
    public static boolean useDisplay = false;
    private static ArrayList<JFrame> runningApplis = new ArrayList();
    private static JFileChooser chooser = null;
    static final PogoFileFilter pogoFilter = new PogoFileFilter("xmi", "Tango Classes");
    static final PogoFileFilter pogo6Filter = new PogoFileFilter(new String[]{"h", "java", "py"}, "Pogo-6 Tango Classes");
    static String homeDir;
    private static boolean startup;
    private ArrayList<JButton> topButtons = new ArrayList();
    private static final int TOP_RELOAD = 0;
    private static final int TOP_NEW = 1;
    private static final int TOP_OPEN = 2;
    private static final int TOP_GENE = 3;
    private ClassPanels class_panels;
    public static boolean dbg_java;
    public static boolean dbg_python;
    public static MultiClassesPanel multiClassesPanel;
    private boolean reBuildTabbedPane = false;
    private JMenuItem aboutItem;
    private JMenuItem colorItem;
    private JMenuItem deleteItem;
    private JMenu editMenu;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JMenuItem generateItem;
    private JMenu helpMenu;
    private JPanel inherPanel;
    private JMenuItem moveDownItem;
    private JMenuItem moveUpItem;
    private JMenuItem multiItem;
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem preferencesItem;
    private JMenu recentMenu;
    private JMenuItem stateMachineItem;
    private JTabbedPane tabbedPane;
    private JMenu toolsMenu;
    private JPanel topPanel;

    static {
        startup = true;
        dbg_java = false;
        dbg_python = false;
        multiClassesPanel = null;
    }

    public PogoGUI(String filename) throws DevFailed {
        this();
        this.checkLoadAtStartup(filename);
    }

    public PogoGUI(DeviceClass devclass, boolean forceModified) throws DevFailed {
        this();
        this.class_panels.addPanels(devclass);
        this.reBuildTabbedPane = false;
        this.setTitle("TANGO Code Generator - " + devclass.toString());
        ((ClassPanel)this.class_panels.get(0)).getTree().setModified(forceModified);
    }

    public PogoGUI() throws DevFailed {
        useDisplay = true;
        this.initComponents();
        PogoProperty.init();
        this.initOwnComponents();
        this.customizeMenus();
        this.class_panels = new ClassPanels(this);
        ClassPanel cp = new ClassPanel(this);
        this.class_panels.add(cp);
        this.tabbedPane.add(cp);
        this.setTitle("TANGO Code Generator - Release 8.0.7  -  Fri Jun 29 15:04:39 CEST 2012");
        this.pack();
        this.setScreenPosition(this);
        this.setVisible(true);
        runningApplis.add(this);
        String env = System.getenv("DBG_JAVA");
        if (env != null && env.toLowerCase().equals("true")) {
            dbg_java = true;
        }
        if ((env = System.getenv("DBG_PYTHON")) != null && env.toLowerCase().equals("true")) {
            dbg_python = true;
        }
    }

    private void checkLoadAtStartup(String filename) {
        if (filename != null && filename.length() > 0) {
            this.loadDeviceClassFromFile(filename);
        } else {
            String xmiFile = Utils.getXmiFile();
            if (xmiFile != null) {
                this.openItemActionPerformed(null);
            } else if (PogoProperty.loadPrevious && PogoProperty.projectHistory.size() > 0) {
                this.loadDeviceClassFromFile(PogoProperty.projectHistory.get(0));
            }
        }
        startup = false;
    }

    public void setScreenPosition(JFrame frame) {
        Point p = new Point();
        int i = runningApplis.size() - 1;
        while (i >= 0) {
            JFrame parent = runningApplis.get(i);
            if (parent.isVisible()) {
                p = parent.getLocation();
                p.x += 20;
                p.y += 20;
                frame.setLocation(p);
                return;
            }
            --i;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = frame.getSize();
        p.x = (scrsize.width - appsize.width) / 2;
        p.y = (scrsize.height - appsize.height) / 2;
        frame.setLocation(p);
    }

    private void startOldPogo(String filename) {
        Vector<JFrame> v = new Vector<JFrame>();
        for (JFrame frame : runningApplis) {
            v.add(frame);
        }
        PogoAppli oldPogo = new PogoAppli(filename, v);
        this.setScreenPosition(oldPogo);
        oldPogo.setVisible(true);
        runningApplis.add(oldPogo);
    }

    private void customizeMenus() throws DevFailed {
        this.fileMenu.setMnemonic('F');
        this.newItem.setMnemonic('N');
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openItem.setMnemonic('O');
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.generateItem.setMnemonic('G');
        this.generateItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.exitItem.setMnemonic('E');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.editMenu.setMnemonic('E');
        this.stateMachineItem.setMnemonic('M');
        this.stateMachineItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.deleteItem.setMnemonic('D');
        this.deleteItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.moveUpItem.setMnemonic('U');
        this.moveUpItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.moveDownItem.setMnemonic('D');
        this.moveDownItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.preferencesItem.setMnemonic('P');
        this.preferencesItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.toolsMenu.setMnemonic('T');
        if (!Utils.osIsUnix()) {
            this.toolsMenu.setVisible(false);
        }
        this.multiItem.setMnemonic('M');
        this.multiItem.setAccelerator(KeyStroke.getKeyStroke(77, 3));
        this.helpMenu.setMnemonic('H');
        this.colorItem.setMnemonic('C');
        this.aboutItem.setMnemonic('A');
        this.manageRecentMenu(null);
    }

    private void manageRecentMenu(String new_proj) {
        try {
            if (new_proj == null && PogoProperty.projectHistory.size() == 0) {
                return;
            }
            if (this.tabbedPane.getSelectedIndex() > 0) {
                return;
            }
            if (new_proj != null) {
                PogoProperty.addProject(new_proj, 0);
            }
            this.recentMenu.removeAll();
            for (String project : PogoProperty.projectHistory) {
                JMenuItem item = new JMenuItem(project);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PogoGUI.this.recentItemActionPerformed(evt);
                    }
                });
                this.recentMenu.add(item);
            }
        }
        catch (Exception e) {
            System.err.println("\nWARNING:\t" + e);
        }
    }

    private void initOwnComponents() {
        Utils utils = Utils.getInstance();
        this.addTopPanelButton(utils.reload_icon, "Reload Class", false);
        this.addTopPanelButton(utils.new_icon, "New Class", false);
        this.addTopPanelButton(utils.open_icon, "Open Class", false);
        this.addTopPanelButton(utils.save_icon, "Generate Class", false);
        JLabel lbl = new JLabel("      Palette:");
        lbl.setFont(new Font("Dialog", 1, 12));
        this.topPanel.add(lbl);
        this.addTopPanelButton(utils.classprop_icon, "Add Class Property", true);
        this.addTopPanelButton(utils.devprop_icon, "Add Device Property", true);
        this.addTopPanelButton(utils.cmd_icon, "Add Command", true);
        this.addTopPanelButton(utils.scalar_icon, "Add ScalarAttribute", true);
        this.addTopPanelButton(utils.spectrum_icon, "Add Spectrum Attribute", true);
        this.addTopPanelButton(utils.image_icon, "Add ImageAttribute", true);
        this.addTopPanelButton(utils.state_icon, "Add State", true);
        homeDir = System.getenv("SOURCE_PATH");
        if (homeDir == null && (homeDir = System.getProperty("SOURCE_PATH")) == null) {
            homeDir = new File("").getAbsolutePath();
        }
        chooser = new JFileChooser(new File(homeDir).getAbsolutePath());
        chooser.setFileFilter(pogo6Filter);
        chooser.setFileFilter(pogoFilter);
    }

    private void addTopPanelButton(ImageIcon icon, String tip, final boolean isPalette) {
        JButton btn = new JButton(icon);
        btn.setToolTipText(Utils.buildToolTip(tip));
        btn.setBorder(new SoftBevelBorder(0));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (isPalette) {
                    PogoGUI.this.paletteActionPerformed(evt);
                } else {
                    PogoGUI.this.topButtonActionPerformed(evt);
                }
            }
        });
        this.topPanel.add(btn);
        this.topButtons.add(btn);
    }

    private void initComponents() {
        this.inherPanel = new JPanel();
        this.topPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        JMenuBar jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newItem = new JMenuItem();
        this.openItem = new JMenuItem();
        this.recentMenu = new JMenu();
        JMenuItem dummyItem = new JMenuItem();
        this.generateItem = new JMenuItem();
        JMenuItem reLoadItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.stateMachineItem = new JMenuItem();
        JSeparator jSeparator1 = new JSeparator();
        this.deleteItem = new JMenuItem();
        this.moveUpItem = new JMenuItem();
        this.moveDownItem = new JMenuItem();
        this.preferencesItem = new JMenuItem();
        JMenuItem sitePreferencesItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.multiItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.colorItem = new JMenuItem();
        JMenuItem releaseItem = new JMenuItem();
        this.aboutItem = new JMenuItem();
        JSeparator jSeparator2 = new JSeparator();
        JMenuItem tangoItem = new JMenuItem();
        JMenuItem pogoItem = new JMenuItem();
        JMenuItem kernelItem = new JMenuItem();
        JMenuItem classItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PogoGUI.this.exitForm(evt);
            }
        });
        this.inherPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.inherPanel, "East");
        this.topPanel.setLayout(new FlowLayout(0));
        this.getContentPane().add((Component)this.topPanel, "First");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PogoGUI.this.tabbedPaneStateChanged(evt);
            }
        });
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.fileMenu.setText("File");
        this.newItem.setText("New");
        this.newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.newItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newItem);
        this.openItem.setText("Open");
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.openItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openItem);
        this.recentMenu.setText("Open Recent");
        dummyItem.setText("...");
        this.recentMenu.add(dummyItem);
        this.fileMenu.add(this.recentMenu);
        this.generateItem.setText("Generate");
        this.generateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.generateItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.generateItem);
        reLoadItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        reLoadItem.setText("Re-Load project");
        reLoadItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.reLoadItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(reLoadItem);
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.exitItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitItem);
        jMenuBar1.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PogoGUI.this.editMenuStateChanged(evt);
            }
        });
        this.stateMachineItem.setText("State Machine");
        this.stateMachineItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.stateMachineItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.stateMachineItem);
        this.editMenu.add(jSeparator1);
        this.deleteItem.setText("Delete Selection");
        this.deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.deleteItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteItem);
        this.moveUpItem.setText("Move Up");
        this.moveUpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.moveUpItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveUpItem);
        this.moveDownItem.setText("Move Down");
        this.moveDownItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.moveDownItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveDownItem);
        this.preferencesItem.setText("Preferences");
        this.preferencesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.preferencesItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.preferencesItem);
        sitePreferencesItem.setText("Site Preferences");
        sitePreferencesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.sitePreferencesItemActionPerformed(evt);
            }
        });
        this.editMenu.add(sitePreferencesItem);
        jMenuBar1.add(this.editMenu);
        this.toolsMenu.setText("Tools");
        this.multiItem.setText("Multi Classes Manager");
        this.multiItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.multiItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.multiItem);
        jMenuBar1.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.colorItem.setText("On Color");
        this.colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.colorItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.colorItem);
        releaseItem.setText("Release Notes");
        releaseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.releaseItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(releaseItem);
        this.aboutItem.setText("about");
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.aboutItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.helpMenu.add(jSeparator2);
        tangoItem.setText("Tango Pages");
        tangoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.tangoItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(tangoItem);
        pogoItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        pogoItem.setText("Pogo Pages");
        pogoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.pogoItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(pogoItem);
        kernelItem.setText("Kernel Pages");
        kernelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.kernelItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(kernelItem);
        classItem.setText("Device Class Pages");
        classItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoGUI.this.classItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(classItem);
        jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void recentItemActionPerformed(ActionEvent evt) {
        String proj_name = ((JMenuItem)evt.getSource()).getText();
        this.loadDeviceClassFromFile(proj_name);
    }

    private void openItemActionPerformed(ActionEvent evt) {
        File file;
        chooser.setFileFilter(pogoFilter);
        int retval = chooser.showOpenDialog(this);
        if (retval == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            homeDir = file.getParentFile().toString();
            this.loadDeviceClassFromFile(file.getAbsolutePath());
        }
    }

    private void buildTree(DeviceClass devclass) {
        ClassIdentification id = devclass.getPogoDeviceClass().getDescription().getIdentification();
        if (id == null && !Utils.isTrue(System.getenv("TEST_MODE"))) {
            Utils.getInstance().stopSplashRefresher();
            this.setCursor(new Cursor(0));
            DeviceIdDialog dialog = new DeviceIdDialog(this);
            if (dialog.showDialog() == 0) {
                id = dialog.getInputs();
                devclass.getPogoDeviceClass().getDescription().setIdentification(id);
            } else {
                return;
            }
        }
        this.reBuildTabbedPane = true;
        this.tabbedPane.removeAll();
        this.class_panels.addPanels(devclass);
        this.reBuildTabbedPane = false;
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        this.exitAppli();
    }

    private void exitForm(WindowEvent evt) {
        if (this.exitAppli() == 2) {
            new SetVisibleLater(this).start();
        }
    }

    private int checkModifications() {
        for (ClassPanel class_panel : this.class_panels) {
            if (class_panel.getTree() == null || !class_panel.getTree().getModified()) continue;
            String name = class_panel.getName();
            Object[] options = new Object[]{"Generate", "Discard", "Cancel"};
            switch (JOptionPane.showOptionDialog(this, String.valueOf(name) + " project has not been generated !\n\n", "Warning", -1, 2, null, options, options[0])) {
                case 0: {
                    this.generateSourceFiles(class_panel.getTree());
                    break;
                }
                case 1: {
                    break;
                }
                case -1: 
                case 2: {
                    return 2;
                }
            }
        }
        return 0;
    }

    private int exitAppli() {
        if (this.checkModifications() == 0) {
            this.setVisible(false);
            for (JFrame frame : runningApplis) {
                if (!frame.isVisible()) continue;
                return 0;
            }
            if (multiClassesPanel != null && multiClassesPanel.isVisible()) {
                return 0;
            }
            System.exit(0);
        }
        return 2;
    }

    String getMainClassName() {
        return this.class_panels.getPanelNameAt(0);
    }

    private void generateItemActionPerformed(ActionEvent evt) {
        int idx = this.tabbedPane.getSelectedIndex();
        ClassTree tree = this.class_panels.getSelectedTree();
        if (tree == null) {
            return;
        }
        this.generateSourceFiles(tree);
    }

    private boolean generateSourceFiles(ClassTree tree) {
        GenerateDialog dialog = new GenerateDialog(this);
        DeviceClass devclass = tree.getDeviceClass();
        if (devclass == null) {
            return true;
        }
        if (dialog.showDialog(devclass) == 0) {
            Cursor cursor = new Cursor(3);
            this.setCursor(cursor);
            try {
                devclass = dialog.getDevClass();
                Utils.getInstance().startSplashRefresher("Generate class: " + devclass.getPogoDeviceClass().getName());
                devclass.generate(tree.getDeletedObjects(), tree.getRenamedObjects());
                Utils.getInstance().stopSplashRefresher();
                tree.setModified(false);
                tree.setSrcPath(devclass.getPogoDeviceClass().getDescription().getSourcePath());
                this.manageRecentMenu(devclass.getProjectFilename());
            }
            catch (Exception e) {
                Utils.getInstance().stopSplashRefresher();
                cursor = new Cursor(0);
                this.setCursor(cursor);
                ErrorPane.showErrorMessage((Component)this, null, e);
                return false;
            }
            cursor = new Cursor(0);
            this.setCursor(cursor);
            return true;
        }
        return false;
    }

    private void newItemActionPerformed(ActionEvent evt) {
        ClassDialog dialog = new ClassDialog(this);
        if (dialog.showDialog() == 0) {
            DeviceClass devclass = dialog.getInputs();
            if (this.class_panels.getSelectedTree() != null) {
                try {
                    new PogoGUI(devclass, true);
                    return;
                }
                catch (Exception e) {
                    Utils.getInstance().stopSplashRefresher();
                    ErrorPane.showErrorMessage((Component)this, null, e);
                }
            }
            this.reBuildTabbedPane = true;
            this.tabbedPane.removeAll();
            this.class_panels.addPanels(devclass);
            this.class_panels.checkWarnings();
            this.reBuildTabbedPane = false;
        }
    }

    private void deleteItemActionPerformed(ActionEvent evt) {
        ClassTree tree = this.class_panels.getSelectedTree();
        Object selection = tree.getSelectedEditableObject();
        if (selection != null) {
            tree.removeSelectedItem();
        }
    }

    private void moveUpItemActionPerformed(ActionEvent evt) {
        ClassTree tree = this.class_panels.getSelectedTree();
        Object selection = tree.getSelectedEditableObject();
        if (selection != null) {
            tree.moveSelectedItem(true);
        }
    }

    private void moveDownItemActionPerformed(ActionEvent evt) {
        ClassTree tree = this.class_panels.getSelectedTree();
        Object selection = tree.getSelectedEditableObject();
        if (selection != null) {
            tree.moveSelectedItem(false);
        }
    }

    private void reloadProject() {
        String filename;
        if (this.class_panels.getSelectedTree() != null && this.checkModifications() == 0 && (filename = ((ClassPanel)this.class_panels.get(0)).getTree().getClassFileName()) != null) {
            this.loadDeviceClassFromFile(filename, false);
        }
    }

    private void topButtonActionPerformed(ActionEvent evt) {
        JButton src = (JButton)evt.getSource();
        int i = 0;
        while (i < this.topButtons.size()) {
            if (this.topButtons.get(i) == src) {
                switch (i) {
                    case 0: {
                        this.reloadProject();
                        break;
                    }
                    case 1: {
                        this.newItemActionPerformed(evt);
                        break;
                    }
                    case 2: {
                        this.openItemActionPerformed(evt);
                        break;
                    }
                    case 3: {
                        this.generateItemActionPerformed(evt);
                    }
                }
            }
            ++i;
        }
    }

    private void paletteActionPerformed(ActionEvent evt) {
        ClassTree tree = this.class_panels.getSelectedTree();
        if (tree != null) {
            JButton btn = (JButton)evt.getSource();
            String txt = btn.getToolTipText();
            tree.addItem(txt);
        }
    }

    private void stateMachineItemActionPerformed(ActionEvent evt) {
        ClassTree tree = this.class_panels.getSelectedTree();
        if (tree != null) {
            tree.editStateMachine();
        }
    }

    private void editMenuStateChanged(ChangeEvent evt) {
        if (this.class_panels == null) {
            return;
        }
        ClassTree tree = this.class_panels.getSelectedTree();
        boolean visible = tree != null && (!this.editMenu.isSelected() || tree.getSelectedEditableObject() != null);
        this.deleteItem.setEnabled(visible);
        this.moveUpItem.setEnabled(visible);
        this.moveDownItem.setEnabled(visible);
    }

    private void colorItemActionPerformed(ActionEvent evt) {
        new PopupColorCode(this).setVisible(true);
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "             Pogo  (Tango Code Generator)\nThis programme is able to generate, update and modify\n                 Tango device classes.\n\nRelease 8.0.7  -  Fri Jun 29 15:04:39 CEST 2012\n\nhttp://www.tango-controls.org/     -    tango@esrf.fr", "Help Window", 1);
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        this.class_panels.updateInheritancePanelForSelection();
    }

    private void preferencesItemActionPerformed(ActionEvent evt) {
        new PreferencesDialog(this).setVisible(true);
    }

    private void releaseItemActionPerformed(ActionEvent evt) {
        new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> Release Note </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n<Center>\t<h2>Pogo Release Note</h2>\n\t(Generated Fri Jun 29 15:04:40 CEST 2012)</Center><Br>\n<li><b>Pogo-8.0.7 - 27/06/2012:</b><Br>\n&nbsp; &nbsp; Problem in allocation data member when inherited fixed.<Br>\n<li><b>Pogo-8.0.6 - 21/06/2012:</b><Br>\n&nbsp; &nbsp; Problem in write dynamic attribute fixed.<Br>\n<li><b>Pogo-8.0.5 - 11/06/2012:</b><Br>\n&nbsp; &nbsp; VC 10 pb with dll fixed.<Br>\n<li><b>Pogo-8.0.4 - 04/06/2012:</b><Br>\n&nbsp; &nbsp; zmq.lib added to vc9 project.<Br>\n<li><b>Pogo-8.0.3 - 29/05/2012:</b><Br>\n&nbsp; &nbsp; Improve vc10 project.<Br>\n&nbsp; &nbsp; Modify file filter for java classes.<Br>\n<li><b>Pogo-8.0.2 - 03/05/2012:</b><Br>\n&nbsp; &nbsp; Bug on abstract command inherited fixed.<Br>\n<li><b>Pogo-8.0.1 - 05/04/2012:</b><Br>\n&nbsp; &nbsp; Pb with inherited object when DevRestart command received fixed.<Br>\n&nbsp; &nbsp; Event criteria management added for attributes (new Tango 8 feature)<Br>\n&nbsp; &nbsp; Pb in inheritance for attribute_factory() fixed.<Br>\n<li><b>Pogo-8.0.0 - 05/03/2012:</b><Br>\n&nbsp; &nbsp; Improve inheritance<Br>\n&nbsp; &nbsp; Add polling on State and Status<Br>\n&nbsp; &nbsp; Make corrections to remove warnings when compile with -Wall<Br>\n&nbsp; &nbsp; Add ULong64 and ULong64Array.<Br>\n&nbsp; &nbsp; Add DevEncoded for Command.<Br>\n&nbsp; &nbsp; Fix a problem in non double dynamic attribute.<Br>\n<li><b>Pogo-7.5.0 - 30/01/2012:</b><Br>\n&nbsp; &nbsp; Win64/VC10 project added.<Br>\n&nbsp; &nbsp; Call for init/delete device and command factory added when class is inherited.<Br>\n<li><b>Pogo-7.4.0 - 01/12/2011:</b><Br>\n&nbsp; &nbsp; Workflow upgrade (Eclipse-3.7, XText-2.0, XPand-1.1)<Br>\n<li><b>Pogo-7.3.2 - 08/09/2011:</b><Br>\n&nbsp; &nbsp; Bug with DevVarLongStringArray and DevVarDoubleStringArray fixed.<Br>\n<li><b>Pogo-7.3.1 - 27/07/2011:</b><Br>\n&nbsp; &nbsp; Pb with dev_state() method in case of ALARM state fixed.<Br>\n&nbsp; &nbsp; Pb in case of main.cpp missing (convertion from pogo-6) fixed.<Br>\n&nbsp; &nbsp; Buttons for java projects added.<Br>\n<li><b>Pogo-7.3.0 - 27/07/2011:</b><Br>\n&nbsp; &nbsp; Dynamic attributes management added.<Br>\n<li><b>Pogo-7.2.7 - 15/06/2011:</b><Br>\n&nbsp; &nbsp; Problem in property dialog (description & default value) fixed.<Br>\n<li><b>Pogo-7.2.6 - 19/05/2011:</b><Br>\n&nbsp; &nbsp; Mandatory device property management added.<Br>\n&nbsp; &nbsp; Change ToolTips management.<Br>\n<li><b>Pogo-7.2.5 - 16/05/2011:</b><Br>\n&nbsp; &nbsp; Litle bug in checkLinesToRemove() method fixed.<Br>\n&nbsp; &nbsp; Problem with omniORB library release number in vc project files fixed.<Br>\n<li><b>Pogo-7.2.4 - 02/05/2011:</b><Br>\n&nbsp; &nbsp; Pb in headers when class name has changed fixed.<Br>\n<li><b>Pogo-7.2.3 - 19/04/2011:</b><Br>\n&nbsp; &nbsp; Associated attribute for READ_WITH_WRITE added.<Br>\n&nbsp; &nbsp; Fixe a pb between Long and Long64.<Br>\n<li><b>Pogo-7.2.2 - 15/04/2011:</b><Br>\n&nbsp; &nbsp; Does not generate read_xxx() metod if xxx attribute is WRITE type.<Br>\n&nbsp; &nbsp; Add a filter on Tango types for commands.<Br>\n<li><b>Pogo-7.2.1 - 14/03/2011:</b><Br>\n&nbsp; &nbsp; Tools to modified keys (for compatibility with PogoDsl changes) in xmi file added.<Br>\n&nbsp; &nbsp; Exclude not generated files from vcX_proj dir for workflow.<Br>\n<li><b>Pogo-7.2.0 - 16/02/2011:</b><Br>\n&nbsp; &nbsp; Multi classes manager tool added.<Br>\n&nbsp; &nbsp; Additional files added for Makefile and vc9 projects.<Br>\n&nbsp; &nbsp; VC9 project templates improved.<Br>\n&nbsp; &nbsp; Bug in multi lines attribute description fixed.<Br>\n<li><b>Pogo-7.1.1 - 14/02/2011:</b><Br>\n&nbsp; &nbsp; Does not generate Classfactory.cpp and main.cpp if clas is abstract.<Br>\n&nbsp; &nbsp; Pb in commnads table fixed.<Br>\n<li><b>Pogo-7.1.0 - 10/02/2011:</b><Br>\n&nbsp; &nbsp; Class name change is now managed.<Br>\n&nbsp; &nbsp; If a xmi file is in current directory, it is proposed to be loaded.<Br>\n<li><b>Pogo-7.0.8 - 07/02/2011:</b><Br>\n&nbsp; &nbsp; Pb in command factory (args description) fixed.<Br>\n&nbsp; &nbsp; Fire DatReady event added on attribute.<Br>\n<li><b>Pogo-7.0.7 - 01/02/2011:</b><Br>\n&nbsp; &nbsp; VC9 project generation added.<Br>\n<li><b>Pogo-7.0.6 - 27/01/2011:</b><Br>\n&nbsp; &nbsp; The files and sub directories not scaned at workflow is now passed dynamicaly to the workflow.<Br>\n<li><b>Pogo-7.0.5 - 26/01/2011:</b><Br>\n&nbsp; &nbsp; Some files and sub directories are not scaned any more at workflow.<Br>\n<li><b>Pogo-7.0.4 - 04/01/2011:</b><Br>\n&nbsp; &nbsp; Pb with inherited class path for Pogo-6 convertion fixed.<Br>\n<li><b>Pogo-7.0.3 - 20/12/2010:</b><Br>\n&nbsp; &nbsp; Pb with DevVarLongArray and DevVarULongArray fixed.<Br>\n&nbsp; &nbsp; Pb with special characters in comments fixed.<Br>\n<li><b>Pogo-7.0.2 - 15/12/2010:</b><Br>\n&nbsp; &nbsp; Pb on command polled (by default) fixed.<Br>\n<li><b>Pogo-7.0.1 - 30/11/2010:</b><Br>\n&nbsp; &nbsp; State/Status polling forbidden.<Br>\n<li><b>Pogo-7.0.0 - 24/09/2010:</b><Br>\n&nbsp; &nbsp; First release for Tango distribution.<Br>\n</Body>\n</Html>\n", 550, 400);
    }

    private DeviceClass generateFromOldAndReload(DeviceClass devclass, String filename) throws DevFailed {
        boolean recoverCode;
        Utils.getInstance().stopSplashRefresher();
        Cursor cursor = new Cursor(0);
        this.setCursor(cursor);
        String message = "         Class:  " + devclass.toString() + "  loaded.\n" + "         This device class has been generated by an old version of Pogo\n\n" + "                       Do you want to convert and reload ?\n\n";
        if (devclass.isOldPogoModelAbstract()) {
            if (JOptionPane.showConfirmDialog(this, message, "Confirmation Window", 0) != 0) {
                return null;
            }
            recoverCode = false;
        } else {
            Object[] options = new Object[]{"Convert and Insert User Code", "Convert Class Only", "Cancel"};
            int choice = JOptionPane.showOptionDialog(this, message, "Confirmation Window", -1, 2, null, options, options[0]);
            switch (choice) {
                case 0: {
                    if (OldPogoModel.checkForInheritance(this, devclass) == 2) {
                        return null;
                    }
                    recoverCode = true;
                    break;
                }
                case 1: {
                    if (OldPogoModel.checkForInheritance(this, devclass) == 2) {
                        return null;
                    }
                    recoverCode = false;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        cursor = new Cursor(0);
        this.setCursor(cursor);
        Utils.getInstance().startSplashRefresher("Generate  source files fo " + devclass.getPogoDeviceClass().getName());
        devclass.generateFromOldModel(filename, recoverCode);
        String env = System.getenv("TEST_MODE");
        String dir = Utils.isTrue(env) ? "/new_src" : "";
        String new_filename = String.valueOf(Utils.getPath(filename)) + dir + "/" + devclass.getPogoDeviceClass().getName() + ".xmi";
        Utils.getInstance().startSplashRefresher("Loading  " + Utils.getRelativeFilename(new_filename));
        devclass = new DeviceClass(new_filename);
        JOptionPane.showMessageDialog(new JFrame(), "Device class source files have been generated in :\n" + Utils.getPath(filename) + dir, "Message Window", 1);
        this.manageRecentMenu(devclass.getProjectFilename());
        return devclass;
    }

    private void reLoadItemActionPerformed(ActionEvent evt) {
        this.reloadProject();
    }

    private void tangoItemActionPerformed(ActionEvent evt) {
        Utils.showInHtmBrowser(PogoConst.tangoHTTP[0]);
    }

    private void kernelItemActionPerformed(ActionEvent evt) {
        Utils.showInHtmBrowser(PogoConst.tangoHTTP[2]);
    }

    private void classItemActionPerformed(ActionEvent evt) {
        Utils.showInHtmBrowser(PogoConst.tangoHTTP[3]);
    }

    private void pogoItemActionPerformed(ActionEvent evt) {
        Utils.showInHtmBrowser(PogoConst.tangoHTTP[1]);
    }

    private void sitePreferencesItemActionPerformed(ActionEvent evt) {
        new PogoConfiguration(this).showDialog();
    }

    private void multiItemActionPerformed(ActionEvent evt) {
        try {
            if (multiClassesPanel == null) {
                multiClassesPanel = new MultiClassesPanel(this, null);
            }
            multiClassesPanel.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
    }

    private void loadDeviceClassFromFile(String filename) {
        this.loadDeviceClassFromFile(filename, true);
    }

    private void loadDeviceClassFromFile(String filename, boolean checkForNewFrame) {
        Cursor cursor;
        block8: {
            cursor = new Cursor(3);
            try {
                File f = new File(filename);
                filename = f.getCanonicalFile().toString();
                this.manageRecentMenu(filename);
            }
            catch (IOException f) {
                // empty catch block
            }
            if (filename.endsWith(".java") && !dbg_java || filename.endsWith(".py") && !dbg_python) {
                System.out.println("-------> filename: " + filename + "   - Starting old Pogo");
                this.startOldPogo(filename);
                return;
            }
            try {
                if (checkForNewFrame && this.class_panels.getSelectedTree() != null) {
                    new PogoGUI(filename);
                    return;
                }
                this.setCursor(cursor);
                Utils.getInstance().startSplashRefresher("Loading  " + Utils.getRelativeFilename(filename));
                DeviceClass devclass = new DeviceClass(filename);
                if (devclass.isOldPogoModel() && (devclass = this.generateFromOldAndReload(devclass, filename)) == null) {
                    return;
                }
                Utils.getInstance().startSplashRefresher("Building  " + Utils.getRelativeFilename(filename));
                this.buildTree(devclass);
                this.setTitle("TANGO Code Generator - " + devclass.toString());
                cursor = new Cursor(0);
                this.setCursor(cursor);
                Utils.getInstance().stopSplashRefresher();
            }
            catch (DevFailed e) {
                Utils.getInstance().stopSplashRefresher();
                if (startup) {
                    System.err.println(e.errors[0].desc);
                }
                if (e.errors[0].reason.equals("CANCEL")) break block8;
                ErrorPane.showErrorMessage((Component)this, filename, e);
                if (this.class_panels.getPanelNameAt(0) != null || runningApplis.size() <= 1) break block8;
                this.setVisible(false);
            }
        }
        cursor = new Cursor(0);
        this.setCursor(cursor);
        this.class_panels.checkWarnings();
    }

    boolean itemAlreadyExists(String name, int type) {
        ClassTree tree = this.class_panels.getSelectedTree();
        return tree.itemAlreadyExists(name, type);
    }

    ClassPanels getClassPanels() {
        return this.class_panels;
    }

    void setTabbedPaneSelection(ClassPanel panel) {
        this.tabbedPane.setSelectedComponent(panel);
    }

    void fireClassHaveChanged() {
        int i = 0;
        while (i < this.class_panels.size()) {
            this.tabbedPane.setTitleAt(i, ((ClassPanel)this.class_panels.get(i)).toString());
            ++i;
        }
    }

    private class ClassPanels
    extends ArrayList<ClassPanel> {
        private PogoGUI gui;
        private String warnings = "";
        private static final long serialVersionUID = -3468411367658544269L;

        private ClassPanels(PogoGUI gui) {
            this.gui = gui;
        }

        private String getPanelNameAt(int idx) {
            ClassPanel panel = (ClassPanel)PogoGUI.this.tabbedPane.getComponent(idx);
            return panel.getName();
        }

        private ClassTree getSelectedTree() {
            return ((ClassPanel)this.get(PogoGUI.this.tabbedPane.getSelectedIndex())).getTree();
        }

        private void addPanel(DeviceClass devclass) {
            ClassPanel cp = new ClassPanel(this.gui);
            cp.setTree(devclass, this.size() > 0);
            this.add(cp);
            PogoGUI.this.tabbedPane.add(cp);
        }

        private void addPanels(DeviceClass devclass) {
            this.removeAll(this);
            PogoGUI.this.tabbedPane.removeAll();
            this.warnings = InheritanceUtils.getInstance().manageInheritanceItems(devclass);
            this.addPanel(devclass);
            ArrayList<DeviceClass> ancestors = devclass.getAncestors();
            int i = ancestors.size() - 1;
            while (i >= 0) {
                this.addPanel(ancestors.get(i));
                --i;
            }
            PogoGUI.this.getContentPane().remove(PogoGUI.this.inherPanel);
            PogoGUI.this.inherPanel = new InheritancePanel(devclass, this.gui);
            PogoGUI.this.getContentPane().add((Component)PogoGUI.this.inherPanel, "East");
            PogoGUI.this.pack();
        }

        private void checkWarnings() {
            if (this.warnings.length() > 0) {
                Utils.getInstance().stopSplashRefresher();
                JOptionPane.showMessageDialog(this.gui, "Inheritance change(s):\n" + this.warnings, "Warning Window", 2);
            }
        }

        private void updateInheritancePanelForSelection() {
            if (!PogoGUI.this.reBuildTabbedPane) {
                ClassPanel panel = (ClassPanel)PogoGUI.this.tabbedPane.getSelectedComponent();
                if (PogoGUI.this.inherPanel instanceof InheritancePanel) {
                    ((InheritancePanel)PogoGUI.this.inherPanel).setSelected(panel.getName());
                }
            }
        }
    }

    private class SetVisibleLater
    extends Thread {
        private Component component;

        private SetVisibleLater(Component component) {
            this.component = component;
        }

        @Override
        public void run() {
            try {
                SetVisibleLater.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.component.setVisible(true);
        }
    }
}

