/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.MultiClassesPanel;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class Pogo {
    private static final int GENE_SRC = 0;
    private static final int GENE_DOC = 1;
    private static final int MULTI = 2;
    private static final int HELP = 3;
    private static final String[] known_actions = new String[]{"-src", "-doc", "-multi", "-?"};
    private DeviceClass deviceClass = null;
    private DevFailed devFailed = null;
    private ArrayList<String> sourcefiles = new ArrayList();

    public Pogo() throws DevFailed {
        PogoProperty.init().displayProperties();
    }

    public Pogo(String filename) throws DevFailed {
        this();
        this.sourcefiles.add(filename);
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public boolean hasFailed() {
        return this.devFailed != null;
    }

    public DevFailed getDevFailed() {
        return this.devFailed;
    }

    public void generateSourceFiles() {
        try {
            for (String filename : this.sourcefiles) {
                this.deviceClass = new DeviceClass(filename);
                PogoDeviceClass pogoclass = this.deviceClass.getPogoDeviceClass();
                if (this.deviceClass.isOldPogoModel()) {
                    this.deviceClass.generateFromOldModel(filename, true);
                    continue;
                }
                this.deviceClass.getPogoDeviceClass().getDescription().setFilestogenerate("Code files");
                OAWutils.getInstance().generate(pogoclass);
            }
        }
        catch (DevFailed e) {
            Except.print_exception(e);
            this.devFailed = e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.devFailed = this.buildDevFailed(e.toString());
        }
    }

    public void generateDocumentation() {
        try {
            for (String filename : this.sourcefiles) {
                System.out.println("===============================================================");
                System.out.println("\tBuild doc from " + filename);
                System.out.println("===============================================================");
                this.deviceClass = new DeviceClass(filename);
                PogoDeviceClass pogoclass = this.deviceClass.getPogoDeviceClass();
                this.deviceClass.getPogoDeviceClass().getDescription().setFilestogenerate("html");
                OAWutils.getInstance().generate(pogoclass);
                if (!this.deviceClass.isOldPogoModel()) continue;
                this.deviceClass.generateDocFromOldModel(filename, null);
            }
        }
        catch (DevFailed e) {
            Except.print_exception(e);
            this.devFailed = e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.devFailed = this.buildDevFailed(e.toString());
        }
    }

    private void startPogoGUI() {
        try {
            if (this.sourcefiles.size() == 0) {
                new PogoGUI(null);
            } else {
                new PogoGUI(this.sourcefiles.get(0));
            }
        }
        catch (Exception e) {
            Utils.getInstance().stopSplashRefresher();
            ErrorPane.showErrorMessage((Component)new JFrame(), null, e);
            System.exit(-1);
        }
        catch (Error e) {
            Utils.getInstance().stopSplashRefresher();
            JOptionPane.showMessageDialog(new JFrame(), e.toString(), "Error Window", 0);
            System.exit(-1);
        }
    }

    private void startPogoMulti() {
        try {
            if (!Utils.osIsUnix()) {
                Except.throw_exception("BAD_OS", "Running only on Linux", "Pogo.startPogoMulti()");
            }
            if (this.sourcefiles.size() == 0) {
                new MultiClassesPanel(new JFrame(), null).setVisible(true);
            } else {
                new MultiClassesPanel(new JFrame(), this.sourcefiles.get(0)).setVisible(true);
            }
        }
        catch (Exception e) {
            Utils.getInstance().stopSplashRefresher();
            ErrorPane.showErrorMessage((Component)new JFrame(), null, e);
            System.exit(-1);
        }
        catch (Error e) {
            Utils.getInstance().stopSplashRefresher();
            JOptionPane.showMessageDialog(new JFrame(), e.toString(), "Error Window", 0);
            System.exit(-1);
        }
    }

    private DevFailed buildDevFailed(String desc) {
        try {
            Except.throw_exception("POGO_FAILED", desc, "Pogo class");
        }
        catch (DevFailed e) {
            return e;
        }
        return null;
    }

    private int manageArgs(String[] args) {
        int action = -1;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            boolean found = false;
            int j = 0;
            while (!found && j < known_actions.length) {
                found = arg.equals(known_actions[j]);
                if (found) {
                    action = j;
                }
                ++j;
            }
            if (!found) {
                this.sourcefiles.add(arg);
            }
            ++n2;
        }
        return action;
    }

    private static void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("pogo <action> <filename1> <filename2>....");
        System.out.println();
        System.out.println("Without option, pogo start the Graphic User Interface");
        System.out.println();
        System.out.println("Actions:");
        System.out.println("\t-src:\twill re-generate the device server source files.");
        System.out.println("\t-multi:\twill start Pogo for multi class server.");
        System.out.println("\t-doc:\twill generate the device server documentation.");
        System.out.println();
    }

    public static void main(String[] args) {
        try {
            Pogo pogo = new Pogo();
            switch (pogo.manageArgs(args)) {
                case 0: {
                    pogo.generateSourceFiles();
                    System.exit(0);
                    break;
                }
                case 1: {
                    pogo.generateDocumentation();
                    System.exit(0);
                    break;
                }
                case 2: {
                    pogo.startPogoMulti();
                    break;
                }
                case 3: {
                    Pogo.displaySyntax();
                    System.exit(0);
                    break;
                }
                default: {
                    pogo.startPogoGUI();
                    break;
                }
            }
        }
        catch (DevFailed e) {
            Except.print_exception(e);
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

